/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.TypeReferenceAdjustment;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class TypeReferenceAdjustment
extends AsmVisitorWrapper.AbstractBase {
    private final boolean strict;
    private final ElementMatcher.Junction<? super TypeDescription> filter;

    protected TypeReferenceAdjustment(boolean strict, ElementMatcher.Junction<? super TypeDescription> filter) {
        this.strict = strict;
        this.filter = filter;
    }

    public static TypeReferenceAdjustment strict() {
        return new TypeReferenceAdjustment(true, ElementMatchers.none());
    }

    public static TypeReferenceAdjustment relaxed() {
        return new TypeReferenceAdjustment(false, ElementMatchers.none());
    }

    public TypeReferenceAdjustment filter(ElementMatcher<? super TypeDescription> filter) {
        return new TypeReferenceAdjustment(this.strict, this.filter.or(filter));
    }

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new TypeReferenceClassVisitor(classVisitor, this.strict, (ElementMatcher)this.filter, typePool);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.strict != ((TypeReferenceAdjustment)object).strict) {
            return false;
        }
        return this.filter.equals(((TypeReferenceAdjustment)object).filter);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.strict) * 31 + this.filter.hashCode();
    }
}

