/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.kickstart.execution.GraphQLObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Map<String, Object> assertNoGraphQLErrors(GraphQL gql, String query) {
        return TestUtils.assertNoGraphQLErrors(gql, new HashMap<String, Object>(), new Object(), query);
    }

    public static Map<String, Object> assertNoGraphQLErrors(GraphQL gql, Map<String, Object> args, Object context, String query) {
        ExecutionResult result = TestUtils.execute(gql, args, context, query);
        if (!result.getErrors().isEmpty()) {
            String errors = TestUtils.formatErrors(result);
            throw new AssertionError((Object)("GraphQL result contained errors!\n" + errors));
        }
        return (Map)result.getData();
    }

    private static String formatErrors(ExecutionResult result) {
        return result.getErrors().stream().map(TestUtils::toString).collect(Collectors.joining("\n"));
    }

    private static ExecutionResult execute(GraphQL gql, Map<String, Object> args, Object context, String query) {
        return gql.execute(ExecutionInput.newExecutionInput().query(query).context(context).root(context).variables(args));
    }

    public static void assertGraphQLError(GraphQL gql, String query, GraphQLError error, GraphQLObjectMapper objectMapper) {
        ExecutionResult result = objectMapper.sanitizeErrors(TestUtils.execute(gql, new HashMap<String, Object>(), new Object(), query));
        String expectedError = TestUtils.toString(error);
        if (result.getErrors().isEmpty()) {
            throw new AssertionError((Object)("GraphQL result did not contain any errors!Expected: \n" + expectedError));
        }
        if (result.getErrors().stream().map(TestUtils::toString).noneMatch(e -> e.equals(expectedError))) {
            throw new AssertionError((Object)("GraphQL result did not contain expected error!\nExpected:" + expectedError + "\nActual:" + TestUtils.formatErrors(result)));
        }
    }

    private static String toString(GraphQLError error) {
        try {
            return mapper.writeValueAsString((Object)error.toSpecification());
        }
        catch (JsonProcessingException e) {
            log.error("Cannot write error {} as string", (Object)error, (Object)e);
            return null;
        }
    }

    @Generated
    private TestUtils() {
    }
}

