/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools.directive;

import graphql.Assert;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.kickstart.tools.directive.SchemaDirectiveWiringEnvironmentImpl;
import graphql.language.NamedNode;
import graphql.language.NodeParentTree;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlElementParentTree;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.WiringFactory;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Internal
public class SchemaGeneratorDirectiveHelper {
    public static <T extends GraphQLDirectiveContainer> boolean schemaDirectiveWiringIsRequired(T directiveContainer, TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        boolean thereAreSome;
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        Map registeredWiring = runtimeWiring.getRegisteredDirectiveWiring();
        List otherWiring = runtimeWiring.getDirectiveWiring();
        boolean bl = thereAreSome = !registeredWiring.isEmpty() || !otherWiring.isEmpty();
        if (thereAreSome) {
            return true;
        }
        Parameters params = new Parameters(typeRegistry, runtimeWiring, new HashMap<String, Object>(), null);
        SchemaDirectiveWiringEnvironmentImpl<T> env = new SchemaDirectiveWiringEnvironmentImpl<T>(directiveContainer, directiveContainer.getDirectives(), null, params);
        return wiringFactory.providesSchemaDirectiveWiring(env);
    }

    private NodeParentTree<NamedNode<?>> buildAstTree(NamedNode<?> ... nodes) {
        ArrayDeque nodeStack = new ArrayDeque();
        for (NamedNode<?> node : nodes) {
            nodeStack.push(node);
        }
        return new NodeParentTree(nodeStack);
    }

    private GraphqlElementParentTree buildRuntimeTree(GraphQLSchemaElement ... elements) {
        ArrayDeque<GraphQLSchemaElement> nodeStack = new ArrayDeque<GraphQLSchemaElement>();
        for (GraphQLSchemaElement element : elements) {
            nodeStack.push(element);
        }
        return new GraphqlElementParentTree(nodeStack);
    }

    private List<GraphQLArgument> wireArguments(GraphQLFieldDefinition fieldDefinition, GraphQLFieldsContainer fieldsContainer, NamedNode<?> fieldsContainerNode, Parameters params, GraphQLFieldDefinition field) {
        return ImmutableKit.map((Iterable)field.getArguments(), argument -> {
            NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{fieldsContainerNode, field.getDefinition(), argument.getDefinition()});
            GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{fieldsContainer, field, argument});
            Parameters argParams = params.newParams(fieldDefinition, fieldsContainer, nodeParentTree, elementParentTree);
            return this.onArgument((GraphQLArgument)argument, argParams);
        });
    }

    private List<GraphQLFieldDefinition> wireFields(GraphQLFieldsContainer fieldsContainer, NamedNode<?> fieldsContainerNode, Parameters params) {
        return ImmutableKit.map((Iterable)fieldsContainer.getFieldDefinitions(), fieldDefinition -> {
            List<GraphQLArgument> newArgs;
            List startingArgs = fieldDefinition.getArguments();
            if (this.isNotTheSameObjects(startingArgs, newArgs = this.wireArguments((GraphQLFieldDefinition)fieldDefinition, fieldsContainer, fieldsContainerNode, params, (GraphQLFieldDefinition)fieldDefinition))) {
                fieldDefinition = fieldDefinition.transform(builder -> builder.clearArguments().arguments(newArgs));
            }
            NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{fieldsContainerNode, fieldDefinition.getDefinition()});
            GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{fieldsContainer, fieldDefinition});
            Parameters fieldParams = params.newParams((GraphQLFieldDefinition)fieldDefinition, fieldsContainer, nodeParentTree, elementParentTree);
            return this.onField((GraphQLFieldDefinition)fieldDefinition, fieldParams);
        });
    }

    public GraphQLObjectType onObject(GraphQLObjectType objectType, Parameters params) {
        List startingFields = objectType.getFieldDefinitions();
        List<GraphQLFieldDefinition> newFields = this.wireFields((GraphQLFieldsContainer)objectType, (NamedNode<?>)objectType.getDefinition(), params);
        GraphQLObjectType newObjectType = objectType;
        if (this.isNotTheSameObjects(startingFields, newFields)) {
            newObjectType = objectType.transform(builder -> builder.clearFields().fields(newFields));
        }
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{newObjectType.getDefinition()});
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{newObjectType});
        Parameters newParams = params.newParams((GraphQLFieldsContainer)newObjectType, nodeParentTree, elementParentTree);
        return this.wireDirectives(params, newObjectType, newObjectType.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLObjectType>((GraphQLObjectType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onObject);
    }

    public GraphQLInterfaceType onInterface(GraphQLInterfaceType interfaceType, Parameters params) {
        List startingFields = interfaceType.getFieldDefinitions();
        List<GraphQLFieldDefinition> newFields = this.wireFields((GraphQLFieldsContainer)interfaceType, (NamedNode<?>)interfaceType.getDefinition(), params);
        GraphQLInterfaceType newInterfaceType = interfaceType;
        if (this.isNotTheSameObjects(startingFields, newFields)) {
            newInterfaceType = interfaceType.transform(builder -> builder.clearFields().fields(newFields));
        }
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{newInterfaceType.getDefinition()});
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{newInterfaceType});
        Parameters newParams = params.newParams((GraphQLFieldsContainer)newInterfaceType, nodeParentTree, elementParentTree);
        return this.wireDirectives(params, newInterfaceType, newInterfaceType.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLInterfaceType>((GraphQLInterfaceType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onInterface);
    }

    public GraphQLEnumType onEnum(GraphQLEnumType enumType, Parameters params) {
        List startingEnumValues = enumType.getValues();
        ImmutableList newEnumValues = ImmutableKit.map((Iterable)startingEnumValues, enumValueDefinition -> {
            NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{enumType.getDefinition(), enumValueDefinition.getDefinition()});
            GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{enumType, enumValueDefinition});
            Parameters fieldParams = params.newParams(nodeParentTree, elementParentTree);
            return this.onEnumValue((GraphQLEnumValueDefinition)enumValueDefinition, fieldParams);
        });
        GraphQLEnumType newEnumType = enumType;
        if (this.isNotTheSameObjects(startingEnumValues, (List)newEnumValues)) {
            newEnumType = enumType.transform(arg_0 -> SchemaGeneratorDirectiveHelper.lambda$onEnum$8((List)newEnumValues, arg_0));
        }
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{newEnumType.getDefinition()});
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{newEnumType});
        Parameters newParams = params.newParams(nodeParentTree, elementParentTree);
        return this.wireDirectives(params, newEnumType, newEnumType.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLEnumType>((GraphQLEnumType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onEnum);
    }

    public GraphQLInputObjectType onInputObjectType(GraphQLInputObjectType inputObjectType, Parameters params) {
        List startingFields = inputObjectType.getFieldDefinitions();
        ImmutableList newFields = ImmutableKit.map((Iterable)startingFields, inputField -> {
            NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{inputObjectType.getDefinition(), inputField.getDefinition()});
            GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{inputObjectType, inputField});
            Parameters fieldParams = params.newParams(nodeParentTree, elementParentTree);
            return this.onInputObjectField((GraphQLInputObjectField)inputField, fieldParams);
        });
        GraphQLInputObjectType newInputObjectType = inputObjectType;
        if (this.isNotTheSameObjects(startingFields, (List)newFields)) {
            newInputObjectType = inputObjectType.transform(arg_0 -> SchemaGeneratorDirectiveHelper.lambda$onInputObjectType$11((List)newFields, arg_0));
        }
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{newInputObjectType.getDefinition()});
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{newInputObjectType});
        Parameters newParams = params.newParams(nodeParentTree, elementParentTree);
        return this.wireDirectives(params, newInputObjectType, newInputObjectType.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLInputObjectType>((GraphQLInputObjectType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onInputObjectType);
    }

    public GraphQLUnionType onUnion(GraphQLUnionType element, Parameters params) {
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{element.getDefinition()});
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{element});
        Parameters newParams = params.newParams(nodeParentTree, elementParentTree);
        return this.wireDirectives(params, element, element.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLUnionType>((GraphQLUnionType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onUnion);
    }

    public GraphQLScalarType onScalar(GraphQLScalarType element, Parameters params) {
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(new NamedNode[]{element.getDefinition()});
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(new GraphQLSchemaElement[]{element});
        Parameters newParams = params.newParams(nodeParentTree, elementParentTree);
        return this.wireDirectives(params, element, element.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLScalarType>((GraphQLScalarType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onScalar);
    }

    private GraphQLFieldDefinition onField(GraphQLFieldDefinition fieldDefinition, Parameters params) {
        return this.wireDirectives(params, fieldDefinition, fieldDefinition.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLFieldDefinition>((GraphQLFieldDefinition)outputElement, directives, registeredDirective, params), SchemaDirectiveWiring::onField);
    }

    private GraphQLInputObjectField onInputObjectField(GraphQLInputObjectField element, Parameters params) {
        return this.wireDirectives(params, element, element.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLInputObjectField>((GraphQLInputObjectField)outputElement, directives, registeredDirective, params), SchemaDirectiveWiring::onInputObjectField);
    }

    private GraphQLEnumValueDefinition onEnumValue(GraphQLEnumValueDefinition enumValueDefinition, Parameters params) {
        return this.wireDirectives(params, enumValueDefinition, enumValueDefinition.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLEnumValueDefinition>((GraphQLEnumValueDefinition)outputElement, directives, registeredDirective, params), SchemaDirectiveWiring::onEnumValue);
    }

    private GraphQLArgument onArgument(GraphQLArgument argument, Parameters params) {
        return this.wireDirectives(params, argument, argument.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLArgument>((GraphQLArgument)outputElement, directives, registeredDirective, params), SchemaDirectiveWiring::onArgument);
    }

    private <T extends GraphQLDirectiveContainer> T wireDirectives(Parameters parameters, T element, List<GraphQLDirective> allDirectives, EnvBuilder<T> envBuilder, EnvInvoker<T> invoker) {
        SchemaDirectiveWiringEnvironment<T> env;
        SchemaDirectiveWiring schemaDirectiveWiring;
        RuntimeWiring runtimeWiring = parameters.getRuntimeWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        T outputObject = element;
        Map mapOfWiring = runtimeWiring.getRegisteredDirectiveWiring();
        for (GraphQLDirective directive : allDirectives) {
            schemaDirectiveWiring = (SchemaDirectiveWiring)mapOfWiring.get(directive.getName());
            if (schemaDirectiveWiring == null) continue;
            env = envBuilder.apply(outputObject, allDirectives, directive);
            outputObject = this.invokeWiring(outputObject, invoker, schemaDirectiveWiring, env);
        }
        for (SchemaDirectiveWiring directiveWiring : runtimeWiring.getDirectiveWiring()) {
            env = envBuilder.apply(outputObject, allDirectives, null);
            outputObject = this.invokeWiring(outputObject, invoker, directiveWiring, env);
        }
        env = envBuilder.apply(outputObject, allDirectives, null);
        if (wiringFactory.providesSchemaDirectiveWiring(env)) {
            schemaDirectiveWiring = (SchemaDirectiveWiring)Assert.assertNotNull((Object)wiringFactory.getSchemaDirectiveWiring(env), () -> "Your WiringFactory MUST provide a non null SchemaDirectiveWiring");
            outputObject = this.invokeWiring(outputObject, invoker, schemaDirectiveWiring, env);
        }
        return outputObject;
    }

    private <T extends GraphQLDirectiveContainer> T invokeWiring(T element, EnvInvoker<T> invoker, SchemaDirectiveWiring schemaDirectiveWiring, SchemaDirectiveWiringEnvironment<T> env) {
        T newElement = invoker.apply(schemaDirectiveWiring, env);
        Assert.assertNotNull(newElement, () -> "The SchemaDirectiveWiring MUST return a non null return value for element '" + element.getName() + "'");
        return newElement;
    }

    private <T> boolean isNotTheSameObjects(List<T> starting, List<T> ending) {
        if (starting == ending) {
            return false;
        }
        if (ending.size() != starting.size()) {
            return true;
        }
        for (int i = 0; i < starting.size(); ++i) {
            T endObj;
            T startObj = starting.get(i);
            if (startObj == (endObj = ending.get(i))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$onInputObjectType$11(List newFields, GraphQLInputObjectType.Builder builder) {
        builder.clearFields().fields(newFields);
    }

    private static /* synthetic */ void lambda$onEnum$8(List newEnumValues, GraphQLEnumType.Builder builder) {
        builder.clearValues().values(newEnumValues);
    }

    static interface EnvInvoker<T extends GraphQLDirectiveContainer> {
        public T apply(SchemaDirectiveWiring var1, SchemaDirectiveWiringEnvironment<T> var2);
    }

    static interface EnvBuilder<T extends GraphQLDirectiveContainer> {
        public SchemaDirectiveWiringEnvironment<T> apply(T var1, List<GraphQLDirective> var2, GraphQLDirective var3);
    }

    public static class Parameters {
        private final TypeDefinitionRegistry typeRegistry;
        private final RuntimeWiring runtimeWiring;
        private final NodeParentTree<NamedNode<?>> nodeParentTree;
        private final Map<String, Object> context;
        private final GraphQLCodeRegistry.Builder codeRegistry;
        private final GraphqlElementParentTree elementParentTree;
        private final GraphQLFieldsContainer fieldsContainer;
        private final GraphQLFieldDefinition fieldDefinition;

        public Parameters(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring, Map<String, Object> context, GraphQLCodeRegistry.Builder codeRegistry) {
            this(typeRegistry, runtimeWiring, context, codeRegistry, null, null, null, null);
        }

        public Parameters(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring, Map<String, Object> context, GraphQLCodeRegistry.Builder codeRegistry, NodeParentTree<NamedNode<?>> nodeParentTree, GraphqlElementParentTree elementParentTree, GraphQLFieldsContainer fieldsContainer, GraphQLFieldDefinition fieldDefinition) {
            this.typeRegistry = typeRegistry;
            this.runtimeWiring = runtimeWiring;
            this.nodeParentTree = nodeParentTree;
            this.context = context;
            this.codeRegistry = codeRegistry;
            this.elementParentTree = elementParentTree;
            this.fieldsContainer = fieldsContainer;
            this.fieldDefinition = fieldDefinition;
        }

        public TypeDefinitionRegistry getTypeRegistry() {
            return this.typeRegistry;
        }

        public RuntimeWiring getRuntimeWiring() {
            return this.runtimeWiring;
        }

        public NodeParentTree<NamedNode<?>> getNodeParentTree() {
            return this.nodeParentTree;
        }

        public GraphqlElementParentTree getElementParentTree() {
            return this.elementParentTree;
        }

        public GraphQLFieldsContainer getFieldsContainer() {
            return this.fieldsContainer;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public GraphQLCodeRegistry.Builder getCodeRegistry() {
            return this.codeRegistry;
        }

        public GraphQLFieldDefinition getFieldsDefinition() {
            return this.fieldDefinition;
        }

        public Parameters newParams(GraphQLFieldsContainer fieldsContainer, NodeParentTree<NamedNode<?>> nodeParentTree, GraphqlElementParentTree elementParentTree) {
            return new Parameters(this.typeRegistry, this.runtimeWiring, this.context, this.codeRegistry, nodeParentTree, elementParentTree, fieldsContainer, this.fieldDefinition);
        }

        public Parameters newParams(GraphQLFieldDefinition fieldDefinition, GraphQLFieldsContainer fieldsContainer, NodeParentTree<NamedNode<?>> nodeParentTree, GraphqlElementParentTree elementParentTree) {
            return new Parameters(this.typeRegistry, this.runtimeWiring, this.context, this.codeRegistry, nodeParentTree, elementParentTree, fieldsContainer, fieldDefinition);
        }

        public Parameters newParams(NodeParentTree<NamedNode<?>> nodeParentTree, GraphqlElementParentTree elementParentTree) {
            return new Parameters(this.typeRegistry, this.runtimeWiring, this.context, this.codeRegistry, nodeParentTree, elementParentTree, this.fieldsContainer, this.fieldDefinition);
        }
    }
}

