/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.instrumentation;

import graphql.Assert;
import graphql.execution.ExecutionId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RequestStack {
    private final Map<ExecutionId, CallStack> activeRequests = new LinkedHashMap<ExecutionId, CallStack>();
    private final Map<ExecutionId, Boolean> status = new LinkedHashMap<ExecutionId, Boolean>();

    public void setStatus(ExecutionId executionId, boolean toState) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Can not set status for execution %s, it is not managed by this request stack", executionId));
        }
        if (toState) {
            this.status.put(executionId, true);
        }
    }

    public boolean allReady() {
        return this.status.values().stream().noneMatch(Boolean.FALSE::equals) && this.activeRequests.values().stream().map(rec$ -> ((CallStack)rec$).getDispatchedLevels()).distinct().count() <= 1L;
    }

    public void allReset() {
        this.status.keySet().forEach(key -> this.status.put((ExecutionId)key, false));
    }

    public boolean contains(ExecutionId executionId) {
        return this.activeRequests.containsKey(executionId);
    }

    public void removeExecution(ExecutionId executionId) {
        this.activeRequests.remove(executionId);
        this.status.remove(executionId);
    }

    public void addExecution(ExecutionId executionId) {
        if (this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("An execution already exists for %s, can not create one", executionId));
        }
        CallStack callStack = new CallStack();
        this.status.put(executionId, false);
        this.activeRequests.put(executionId, callStack);
    }

    public void increaseExpectedFetchCount(ExecutionId executionId, int curLevel, int fieldCount) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not increase expected fetch count", executionId));
        }
        this.activeRequests.get(executionId).increaseExpectedFetchCount(curLevel, fieldCount);
    }

    public void increaseHappenedStrategyCalls(ExecutionId executionId, int curLevel) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not increase happened happened strategy calls", executionId));
        }
        this.activeRequests.get(executionId).increaseHappenedStrategyCalls(curLevel);
    }

    public void increaseHappenedOnFieldValueCalls(ExecutionId executionId, int curLevel) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not increase happened on field calls", executionId));
        }
        this.activeRequests.get(executionId).increaseHappenedOnFieldValueCalls(curLevel);
    }

    public void increaseExpectedStrategyCalls(ExecutionId executionId, int curLevel, int expectedStrategyCalls) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not increase expected strategy calls", executionId));
        }
        this.activeRequests.get(executionId).increaseExpectedStrategyCalls(curLevel, expectedStrategyCalls);
    }

    public boolean allFetchesHappened(ExecutionId executionId, int level) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not get all fetches happened value", executionId));
        }
        return this.activeRequests.get(executionId).allFetchesHappened(level);
    }

    public boolean allOnFieldCallsHappened(ExecutionId executionId, int level) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not get all on field calls happened value", executionId));
        }
        return this.activeRequests.get(executionId).allOnFieldCallsHappened(level);
    }

    public boolean allStrategyCallsHappened(ExecutionId executionId, int level) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not get all strategy calls happened value", executionId));
        }
        return this.activeRequests.get(executionId).allStrategyCallsHappened(level);
    }

    public boolean dispatchIfNotDispatchedBefore(ExecutionId executionId, int level) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not get dispatch if not dispatched before value", executionId));
        }
        return this.activeRequests.get(executionId).dispatchIfNotDispatchedBefore(level);
    }

    public void increaseFetchCount(ExecutionId executionId, int level) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not increase fetch count", executionId));
        }
        this.activeRequests.get(executionId).increaseFetchCount(level);
    }

    public void clearAndMarkCurrentLevelAsReady(ExecutionId executionId, int level) {
        if (!this.activeRequests.containsKey(executionId)) {
            throw new IllegalStateException(String.format("Execution %s not managed by this RequestStack, can not clea and mark current level as ready", executionId));
        }
        this.activeRequests.get(executionId).clearAndMarkCurrentLevelAsReady(level);
    }

    private static class CallStack {
        private final Map<Integer, Integer> expectedFetchCountPerLevel = new LinkedHashMap<Integer, Integer>();
        private final Map<Integer, Integer> fetchCountPerLevel = new LinkedHashMap<Integer, Integer>();
        private final Map<Integer, Integer> expectedStrategyCallsPerLevel = new LinkedHashMap<Integer, Integer>();
        private final Map<Integer, Integer> happenedStrategyCallsPerLevel = new LinkedHashMap<Integer, Integer>();
        private final Map<Integer, Integer> happenedOnFieldValueCallsPerLevel = new LinkedHashMap<Integer, Integer>();
        private final List<Integer> dispatchedLevels = new ArrayList<Integer>();

        private CallStack() {
            this.expectedStrategyCallsPerLevel.put(1, 1);
        }

        private void increaseExpectedFetchCount(int level, int count) {
            this.expectedFetchCountPerLevel.put(level, this.expectedFetchCountPerLevel.getOrDefault(level, 0) + count);
        }

        private void increaseFetchCount(int level) {
            this.fetchCountPerLevel.put(level, this.fetchCountPerLevel.getOrDefault(level, 0) + 1);
        }

        private void increaseExpectedStrategyCalls(int level, int count) {
            this.expectedStrategyCallsPerLevel.put(level, this.expectedStrategyCallsPerLevel.getOrDefault(level, 0) + count);
        }

        private void increaseHappenedStrategyCalls(int level) {
            this.happenedStrategyCallsPerLevel.put(level, this.happenedStrategyCallsPerLevel.getOrDefault(level, 0) + 1);
        }

        private void increaseHappenedOnFieldValueCalls(int level) {
            this.happenedOnFieldValueCallsPerLevel.put(level, this.happenedOnFieldValueCallsPerLevel.getOrDefault(level, 0) + 1);
        }

        private boolean allStrategyCallsHappened(int level) {
            return Objects.equals(this.happenedStrategyCallsPerLevel.get(level), this.expectedStrategyCallsPerLevel.get(level));
        }

        private boolean allOnFieldCallsHappened(int level) {
            return Objects.equals(this.happenedOnFieldValueCallsPerLevel.get(level), this.expectedStrategyCallsPerLevel.get(level));
        }

        private boolean allFetchesHappened(int level) {
            return Objects.equals(this.fetchCountPerLevel.get(level), this.expectedFetchCountPerLevel.get(level));
        }

        private List<Integer> getDispatchedLevels() {
            return this.dispatchedLevels;
        }

        public String toString() {
            return "CallStack{expectedFetchCountPerLevel=" + this.expectedFetchCountPerLevel + ", fetchCountPerLevel=" + this.fetchCountPerLevel + ", expectedStrategyCallsPerLevel=" + this.expectedStrategyCallsPerLevel + ", happenedStrategyCallsPerLevel=" + this.happenedStrategyCallsPerLevel + ", happenedOnFieldValueCallsPerLevel=" + this.happenedOnFieldValueCallsPerLevel + ", dispatchedLevels" + this.dispatchedLevels + '}';
        }

        private boolean dispatchIfNotDispatchedBefore(int level) {
            if (this.dispatchedLevels.contains(level)) {
                Assert.assertShouldNeverHappen((String)("level " + level + " already dispatched"), (Object[])new Object[0]);
                return false;
            }
            this.dispatchedLevels.add(level);
            return true;
        }

        private void clearAndMarkCurrentLevelAsReady(int level) {
            this.expectedFetchCountPerLevel.clear();
            this.fetchCountPerLevel.clear();
            this.expectedStrategyCallsPerLevel.clear();
            this.happenedStrategyCallsPerLevel.clear();
            this.happenedOnFieldValueCallsPerLevel.clear();
            this.dispatchedLevels.clear();
            this.expectedFetchCountPerLevel.put(level, 1);
            this.expectedStrategyCallsPerLevel.put(level, 1);
            this.happenedStrategyCallsPerLevel.put(level, 1);
        }
    }
}

