/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.config;

import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.kickstart.execution.config.DefaultExecutionStrategyProvider;
import graphql.kickstart.execution.config.ExecutionStrategyProvider;
import graphql.kickstart.execution.config.GraphQLSchemaProvider;
import graphql.schema.GraphQLSchema;
import java.util.function.Supplier;

public class GraphQLBuilder {
    private Supplier<ExecutionStrategyProvider> executionStrategyProviderSupplier = DefaultExecutionStrategyProvider::new;
    private Supplier<PreparsedDocumentProvider> preparsedDocumentProviderSupplier = () -> NoOpPreparsedDocumentProvider.INSTANCE;
    private Supplier<Instrumentation> instrumentationSupplier = () -> SimpleInstrumentation.INSTANCE;

    public GraphQLBuilder executionStrategyProvider(Supplier<ExecutionStrategyProvider> supplier) {
        if (supplier != null) {
            this.executionStrategyProviderSupplier = supplier;
        }
        return this;
    }

    public GraphQLBuilder preparsedDocumentProvider(Supplier<PreparsedDocumentProvider> supplier) {
        if (supplier != null) {
            this.preparsedDocumentProviderSupplier = supplier;
        }
        return this;
    }

    public GraphQLBuilder instrumentation(Supplier<Instrumentation> supplier) {
        if (supplier != null) {
            this.instrumentationSupplier = supplier;
        }
        return this;
    }

    public GraphQL build(GraphQLSchemaProvider schemaProvider) {
        return this.build(schemaProvider.getSchema());
    }

    public GraphQL build(GraphQLSchema schema) {
        return this.build(schema, this.instrumentationSupplier);
    }

    public GraphQL build(GraphQLSchema schema, Supplier<Instrumentation> configuredInstrumentationSupplier) {
        ExecutionStrategyProvider executionStrategyProvider = this.executionStrategyProviderSupplier.get();
        GraphQL.Builder builder = GraphQL.newGraphQL((GraphQLSchema)schema).queryExecutionStrategy(executionStrategyProvider.getQueryExecutionStrategy()).mutationExecutionStrategy(executionStrategyProvider.getMutationExecutionStrategy()).subscriptionExecutionStrategy(executionStrategyProvider.getSubscriptionExecutionStrategy()).preparsedDocumentProvider(this.preparsedDocumentProviderSupplier.get());
        Instrumentation instrumentation = configuredInstrumentationSupplier.get();
        builder.instrumentation(instrumentation);
        if (this.containsDispatchInstrumentation(instrumentation)) {
            builder.doNotAddDefaultInstrumentations();
        }
        return builder.build();
    }

    private boolean containsDispatchInstrumentation(Instrumentation instrumentation) {
        if (instrumentation instanceof ChainedInstrumentation) {
            return ((ChainedInstrumentation)instrumentation).getInstrumentations().stream().anyMatch(this::containsDispatchInstrumentation);
        }
        return instrumentation instanceof DataLoaderDispatcherInstrumentation;
    }

    public Supplier<Instrumentation> getInstrumentationSupplier() {
        return this.instrumentationSupplier;
    }
}

