/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.kickstart.execution.BatchedDataLoaderGraphQLBuilder;
import graphql.kickstart.execution.GraphQLInvokerProxy;
import graphql.kickstart.execution.GraphQLQueryResult;
import graphql.kickstart.execution.config.GraphQLBuilder;
import graphql.kickstart.execution.input.GraphQLBatchedInvocationInput;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class GraphQLInvoker {
    private final GraphQLBuilder graphQLBuilder;
    private final BatchedDataLoaderGraphQLBuilder batchedDataLoaderGraphQLBuilder;
    private GraphQLInvokerProxy proxy = GraphQL::executeAsync;

    public CompletableFuture<ExecutionResult> executeAsync(GraphQLSingleInvocationInput invocationInput) {
        GraphQL graphQL = this.graphQLBuilder.build(invocationInput.getSchema());
        return this.proxy.executeAsync(graphQL, invocationInput.getExecutionInput());
    }

    public GraphQLQueryResult query(GraphQLInvocationInput invocationInput) {
        if (invocationInput instanceof GraphQLSingleInvocationInput) {
            return GraphQLQueryResult.create(this.query((GraphQLSingleInvocationInput)invocationInput));
        }
        GraphQLBatchedInvocationInput batchedInvocationInput = (GraphQLBatchedInvocationInput)invocationInput;
        return GraphQLQueryResult.create(this.query(batchedInvocationInput));
    }

    private ExecutionResult query(GraphQLSingleInvocationInput singleInvocationInput) {
        return this.executeAsync(singleInvocationInput).join();
    }

    private List<ExecutionResult> query(GraphQLBatchedInvocationInput batchedInvocationInput) {
        GraphQL graphQL = this.batchedDataLoaderGraphQLBuilder.newGraphQL(batchedInvocationInput, this.graphQLBuilder);
        return batchedInvocationInput.getExecutionInputs().stream().map(executionInput -> this.proxy.executeAsync(graphQL, (ExecutionInput)executionInput)).collect(Collectors.toList()).stream().map(CompletableFuture::join).collect(Collectors.toList());
    }

    public GraphQLInvoker(GraphQLBuilder graphQLBuilder, BatchedDataLoaderGraphQLBuilder batchedDataLoaderGraphQLBuilder, GraphQLInvokerProxy proxy) {
        this.graphQLBuilder = graphQLBuilder;
        this.batchedDataLoaderGraphQLBuilder = batchedDataLoaderGraphQLBuilder;
        this.proxy = proxy;
    }

    public GraphQLInvoker(GraphQLBuilder graphQLBuilder, BatchedDataLoaderGraphQLBuilder batchedDataLoaderGraphQLBuilder) {
        this.graphQLBuilder = graphQLBuilder;
        this.batchedDataLoaderGraphQLBuilder = batchedDataLoaderGraphQLBuilder;
    }
}

