/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.servlet.ExecutionResultSubscriber;
import graphql.servlet.QueryResponseWriter;
import graphql.servlet.StaticDataPublisher;
import graphql.servlet.SubscriptionAsyncListener;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class SingleAsynchronousQueryResponseWriter
implements QueryResponseWriter {
    private final ExecutionResult result;
    private final GraphQLObjectMapper graphQLObjectMapper;
    private final long subscriptionTimeout;

    @Override
    public void write(HttpServletRequest request, HttpServletResponse response) {
        Objects.requireNonNull(request, "Http servlet request cannot be null");
        response.setContentType("text/event-stream;charset=UTF-8");
        response.setStatus(200);
        boolean isInAsyncThread = request.isAsyncStarted();
        AsyncContext asyncContext = isInAsyncThread ? request.getAsyncContext() : request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(this.subscriptionTimeout);
        AtomicReference<Subscription> subscriptionRef = new AtomicReference<Subscription>();
        asyncContext.addListener((AsyncListener)new SubscriptionAsyncListener(subscriptionRef));
        ExecutionResultSubscriber subscriber = new ExecutionResultSubscriber(subscriptionRef, asyncContext, this.graphQLObjectMapper);
        ArrayList<Object> publishers = new ArrayList<Object>();
        if (this.result.getData() instanceof Publisher) {
            publishers.add(this.result.getData());
        } else {
            publishers.add(new StaticDataPublisher<ExecutionResult>(this.result));
            Publisher deferredResultsPublisher = (Publisher)this.result.getExtensions().get("deferredResults");
            publishers.add(deferredResultsPublisher);
        }
        publishers.forEach(it -> it.subscribe((Subscriber)subscriber));
        if (isInAsyncThread) {
            try {
                subscriber.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public SingleAsynchronousQueryResponseWriter(ExecutionResult result, GraphQLObjectMapper graphQLObjectMapper, long subscriptionTimeout) {
        this.result = result;
        this.graphQLObjectMapper = graphQLObjectMapper;
        this.subscriptionTimeout = subscriptionTimeout;
    }

    public ExecutionResult getResult() {
        return this.result;
    }
}

