/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.servlet.AbstractGraphQLHttpServlet;
import graphql.servlet.DefaultExecutionStrategyProvider;
import graphql.servlet.DefaultGraphQLContextBuilder;
import graphql.servlet.DefaultGraphQLErrorHandler;
import graphql.servlet.DefaultGraphQLRootObjectBuilder;
import graphql.servlet.DefaultGraphQLSchemaProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLContextBuilder;
import graphql.servlet.GraphQLErrorHandler;
import graphql.servlet.GraphQLInvocationInputFactory;
import graphql.servlet.GraphQLMutationProvider;
import graphql.servlet.GraphQLObjectMapper;
import graphql.servlet.GraphQLProvider;
import graphql.servlet.GraphQLQueryInvoker;
import graphql.servlet.GraphQLQueryProvider;
import graphql.servlet.GraphQLRootObjectBuilder;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.GraphQLSubscriptionProvider;
import graphql.servlet.GraphQLTypesProvider;
import graphql.servlet.InstrumentationProvider;
import graphql.servlet.NoOpInstrumentationProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={HttpServlet.class, Servlet.class}, property={"alias=/graphql", "jmx.objectname=graphql.servlet:type=graphql"})
public class OsgiGraphQLHttpServlet
extends AbstractGraphQLHttpServlet {
    private final List<GraphQLQueryProvider> queryProviders = new ArrayList<GraphQLQueryProvider>();
    private final List<GraphQLMutationProvider> mutationProviders = new ArrayList<GraphQLMutationProvider>();
    private final List<GraphQLSubscriptionProvider> subscriptionProviders = new ArrayList<GraphQLSubscriptionProvider>();
    private final List<GraphQLTypesProvider> typesProviders = new ArrayList<GraphQLTypesProvider>();
    private final GraphQLQueryInvoker queryInvoker;
    private final GraphQLInvocationInputFactory invocationInputFactory;
    private final GraphQLObjectMapper graphQLObjectMapper;
    private GraphQLContextBuilder contextBuilder = new DefaultGraphQLContextBuilder();
    private GraphQLRootObjectBuilder rootObjectBuilder = new DefaultGraphQLRootObjectBuilder();
    private ExecutionStrategyProvider executionStrategyProvider = new DefaultExecutionStrategyProvider();
    private InstrumentationProvider instrumentationProvider = new NoOpInstrumentationProvider();
    private GraphQLErrorHandler errorHandler = new DefaultGraphQLErrorHandler();
    private PreparsedDocumentProvider preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;
    private GraphQLSchemaProvider schemaProvider;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> updateFuture;
    private int schemaUpdateDelay;

    @Activate
    public void activate(Config config) {
        this.schemaUpdateDelay = config.schema_update_delay();
        if (this.schemaUpdateDelay != 0) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    protected GraphQLQueryInvoker getQueryInvoker() {
        return this.queryInvoker;
    }

    @Override
    protected GraphQLInvocationInputFactory getInvocationInputFactory() {
        return this.invocationInputFactory;
    }

    @Override
    protected GraphQLObjectMapper getGraphQLObjectMapper() {
        return this.graphQLObjectMapper;
    }

    @Override
    protected boolean isAsyncServletMode() {
        return false;
    }

    public OsgiGraphQLHttpServlet() {
        this.updateSchema();
        this.queryInvoker = GraphQLQueryInvoker.newBuilder().withPreparsedDocumentProvider(this::getPreparsedDocumentProvider).withInstrumentation(() -> this.getInstrumentationProvider().getInstrumentation()).withExecutionStrategyProvider(this::getExecutionStrategyProvider).build();
        this.invocationInputFactory = GraphQLInvocationInputFactory.newBuilder(this::getSchemaProvider).withGraphQLContextBuilder(this::getContextBuilder).withGraphQLRootObjectBuilder(this::getRootObjectBuilder).build();
        this.graphQLObjectMapper = GraphQLObjectMapper.newBuilder().withGraphQLErrorHandler(this::getErrorHandler).build();
    }

    protected void updateSchema() {
        if (this.schemaUpdateDelay == 0) {
            this.doUpdateSchema();
        } else {
            if (this.updateFuture != null) {
                this.updateFuture.cancel(true);
            }
            this.updateFuture = this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    OsgiGraphQLHttpServlet.this.doUpdateSchema();
                }
            }, (long)this.schemaUpdateDelay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doUpdateSchema() {
        void var3_7;
        GraphQLObjectType.Builder queryTypeBuilder = GraphQLObjectType.newObject().name("Query").description("Root query type");
        for (GraphQLQueryProvider graphQLQueryProvider : this.queryProviders) {
            if (graphQLQueryProvider.getQueries() == null || graphQLQueryProvider.getQueries().isEmpty()) continue;
            graphQLQueryProvider.getQueries().forEach(arg_0 -> ((GraphQLObjectType.Builder)queryTypeBuilder).field(arg_0));
        }
        HashSet<GraphQLType> types = new HashSet<GraphQLType>();
        for (GraphQLTypesProvider typesProvider : this.typesProviders) {
            types.addAll(typesProvider.getTypes());
        }
        Object var3_5 = null;
        if (!this.mutationProviders.isEmpty()) {
            GraphQLObjectType.Builder mutationTypeBuilder = GraphQLObjectType.newObject().name("Mutation").description("Root mutation type");
            for (GraphQLMutationProvider provider : this.mutationProviders) {
                provider.getMutations().forEach(arg_0 -> ((GraphQLObjectType.Builder)mutationTypeBuilder).field(arg_0));
            }
            if (!mutationTypeBuilder.build().getFieldDefinitions().isEmpty()) {
                GraphQLObjectType graphQLObjectType = mutationTypeBuilder.build();
            }
        }
        GraphQLObjectType subscriptionType = null;
        if (!this.subscriptionProviders.isEmpty()) {
            GraphQLObjectType.Builder subscriptionTypeBuilder = GraphQLObjectType.newObject().name("Subscription").description("Root subscription type");
            for (GraphQLSubscriptionProvider provider : this.subscriptionProviders) {
                provider.getSubscriptions().forEach(arg_0 -> ((GraphQLObjectType.Builder)subscriptionTypeBuilder).field(arg_0));
            }
            if (!subscriptionTypeBuilder.build().getFieldDefinitions().isEmpty()) {
                subscriptionType = subscriptionTypeBuilder.build();
            }
        }
        this.schemaProvider = new DefaultGraphQLSchemaProvider(GraphQLSchema.newSchema().query(queryTypeBuilder.build()).mutation((GraphQLObjectType)var3_7).subscription(subscriptionType).additionalTypes(types).build());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.queryProviders.add((GraphQLQueryProvider)provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.mutationProviders.add((GraphQLMutationProvider)provider);
        }
        if (provider instanceof GraphQLSubscriptionProvider) {
            this.subscriptionProviders.add((GraphQLSubscriptionProvider)provider);
        }
        if (provider instanceof GraphQLTypesProvider) {
            this.typesProviders.add((GraphQLTypesProvider)provider);
        }
        this.updateSchema();
    }

    public void unbindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.queryProviders.remove(provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.mutationProviders.remove(provider);
        }
        if (provider instanceof GraphQLSubscriptionProvider) {
            this.subscriptionProviders.remove(provider);
        }
        if (provider instanceof GraphQLTypesProvider) {
            this.typesProviders.remove(provider);
        }
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.add(queryProvider);
        this.updateSchema();
    }

    public void unbindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.remove(queryProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.add(mutationProvider);
        this.updateSchema();
    }

    public void unbindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.remove(mutationProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindSubscriptionProvider(GraphQLSubscriptionProvider subscriptionProvider) {
        this.subscriptionProviders.add(subscriptionProvider);
        this.updateSchema();
    }

    public void unbindSubscriptionProvider(GraphQLSubscriptionProvider subscriptionProvider) {
        this.subscriptionProviders.remove(subscriptionProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindTypesProvider(GraphQLTypesProvider typesProvider) {
        this.typesProviders.add(typesProvider);
        this.updateSchema();
    }

    public void unbindTypesProvider(GraphQLTypesProvider typesProvider) {
        this.typesProviders.remove(typesProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindServletListener(GraphQLServletListener listener) {
        this.addListener(listener);
    }

    public void unbindServletListener(GraphQLServletListener listener) {
        this.removeListener(listener);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setContextProvider(GraphQLContextBuilder contextBuilder) {
        this.contextBuilder = contextBuilder;
    }

    public void unsetContextProvider(GraphQLContextBuilder contextBuilder) {
        this.contextBuilder = new DefaultGraphQLContextBuilder();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setRootObjectBuilder(GraphQLRootObjectBuilder rootObjectBuilder) {
        this.rootObjectBuilder = rootObjectBuilder;
    }

    public void unsetRootObjectBuilder(GraphQLRootObjectBuilder rootObjectBuilder) {
        this.rootObjectBuilder = new DefaultGraphQLRootObjectBuilder();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = provider;
    }

    public void unsetExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = new DefaultExecutionStrategyProvider();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setInstrumentationProvider(InstrumentationProvider provider) {
        this.instrumentationProvider = provider;
    }

    public void unsetInstrumentationProvider(InstrumentationProvider provider) {
        this.instrumentationProvider = new NoOpInstrumentationProvider();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setErrorHandler(GraphQLErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void unsetErrorHandler(GraphQLErrorHandler errorHandler) {
        this.errorHandler = new DefaultGraphQLErrorHandler();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setPreparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
        this.preparsedDocumentProvider = preparsedDocumentProvider;
    }

    public void unsetPreparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
        this.preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;
    }

    public GraphQLContextBuilder getContextBuilder() {
        return this.contextBuilder;
    }

    public GraphQLRootObjectBuilder getRootObjectBuilder() {
        return this.rootObjectBuilder;
    }

    public ExecutionStrategyProvider getExecutionStrategyProvider() {
        return this.executionStrategyProvider;
    }

    public InstrumentationProvider getInstrumentationProvider() {
        return this.instrumentationProvider;
    }

    public GraphQLErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public PreparsedDocumentProvider getPreparsedDocumentProvider() {
        return this.preparsedDocumentProvider;
    }

    public GraphQLSchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    static @interface Config {
        public int schema_update_delay() default 0;
    }
}

