/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.internal;

import graphql.servlet.internal.ApolloSubscriptionProtocolHandler;
import graphql.servlet.internal.SubscriptionSender;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApolloSubscriptionKeepAliveRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ApolloSubscriptionKeepAliveRunner.class);
    private static final int EXECUTOR_POOL_SIZE = 10;
    private final ScheduledExecutorService executor;
    private final SubscriptionSender sender;
    private final ApolloSubscriptionProtocolHandler.OperationMessage keepAliveMessage;
    private final Map<Session, Future<?>> futures;
    private final long keepAliveIntervalSeconds;

    ApolloSubscriptionKeepAliveRunner(SubscriptionSender sender, Duration keepAliveInterval) {
        this.sender = Objects.requireNonNull(sender);
        this.keepAliveMessage = ApolloSubscriptionProtocolHandler.OperationMessage.newKeepAliveMessage();
        this.executor = Executors.newScheduledThreadPool(10);
        this.futures = new ConcurrentHashMap();
        this.keepAliveIntervalSeconds = keepAliveInterval.getSeconds();
    }

    void keepAlive(Session session) {
        this.futures.computeIfAbsent(session, this::startKeepAlive);
    }

    private ScheduledFuture<?> startKeepAlive(Session session) {
        return this.executor.scheduleAtFixedRate(() -> {
            try {
                if (session.isOpen()) {
                    this.sender.send(session, this.keepAliveMessage);
                } else {
                    LOG.warn("Session appears to be closed. Aborting keep alive");
                    this.abort(session);
                }
            }
            catch (Throwable t) {
                LOG.error("Cannot send keep alive message. Aborting keep alive", t);
                this.abort(session);
            }
        }, 0L, this.keepAliveIntervalSeconds, TimeUnit.SECONDS);
    }

    void abort(Session session) {
        Future<?> future = this.futures.remove(session);
        if (future != null) {
            future.cancel(true);
        }
    }
}

