/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import graphql.ExecutionResult;
import graphql.schema.GraphQLFieldDefinition;
import graphql.servlet.GraphQLBatchedInvocationInput;
import graphql.servlet.GraphQLConfiguration;
import graphql.servlet.GraphQLInvocationInputFactory;
import graphql.servlet.GraphQLMBean;
import graphql.servlet.GraphQLObjectMapper;
import graphql.servlet.GraphQLQueryInvoker;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.GraphQLSingleInvocationInput;
import graphql.servlet.internal.GraphQLRequest;
import graphql.servlet.internal.VariableMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphQLHttpServlet
extends HttpServlet
implements Servlet,
GraphQLMBean {
    public static final Logger log = LoggerFactory.getLogger(AbstractGraphQLHttpServlet.class);
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final String APPLICATION_GRAPHQL = "application/graphql";
    public static final int STATUS_OK = 200;
    public static final int STATUS_BAD_REQUEST = 400;
    private static final GraphQLRequest INTROSPECTION_REQUEST = new GraphQLRequest("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n", new HashMap<String, Object>(), null);
    private static final String[] MULTIPART_KEYS = new String[]{"operations", "graphql", "query"};
    private GraphQLConfiguration configuration;
    @Deprecated
    private final List<GraphQLServletListener> listeners;
    private HttpRequestHandler getHandler;
    private HttpRequestHandler postHandler;

    @Deprecated
    protected abstract GraphQLQueryInvoker getQueryInvoker();

    @Deprecated
    protected abstract GraphQLInvocationInputFactory getInvocationInputFactory();

    @Deprecated
    protected abstract GraphQLObjectMapper getGraphQLObjectMapper();

    @Deprecated
    protected abstract boolean isAsyncServletMode();

    protected GraphQLConfiguration getConfiguration() {
        return GraphQLConfiguration.with(this.getInvocationInputFactory()).with(this.getQueryInvoker()).with(this.getGraphQLObjectMapper()).with(this.isAsyncServletMode()).with(this.listeners).build();
    }

    public AbstractGraphQLHttpServlet() {
        this(null);
    }

    public AbstractGraphQLHttpServlet(List<GraphQLServletListener> listeners) {
        this.listeners = listeners != null ? new ArrayList<GraphQLServletListener>(listeners) : new ArrayList();
    }

    public void init(ServletConfig servletConfig) {
        this.configuration = this.getConfiguration();
        this.getHandler = (request, response) -> {
            GraphQLInvocationInputFactory invocationInputFactory = this.configuration.getInvocationInputFactory();
            GraphQLObjectMapper graphQLObjectMapper = this.configuration.getObjectMapper();
            GraphQLQueryInvoker queryInvoker = this.configuration.getQueryInvoker();
            String path = request.getPathInfo();
            if (path == null) {
                path = request.getServletPath();
            }
            if (path.contentEquals("/schema.json")) {
                this.query(queryInvoker, graphQLObjectMapper, invocationInputFactory.create(INTROSPECTION_REQUEST, request, response), response);
            } else {
                String query = request.getParameter("query");
                if (query != null) {
                    if (this.isBatchedQuery(query)) {
                        this.queryBatched(queryInvoker, graphQLObjectMapper, invocationInputFactory.createReadOnly(graphQLObjectMapper.readBatchedGraphQLRequest(query), request, response), response);
                    } else {
                        HashMap<String, Object> variables = new HashMap<String, Object>();
                        if (request.getParameter("variables") != null) {
                            variables.putAll(graphQLObjectMapper.deserializeVariables(request.getParameter("variables")));
                        }
                        String operationName = request.getParameter("operationName");
                        this.query(queryInvoker, graphQLObjectMapper, invocationInputFactory.createReadOnly(new GraphQLRequest(query, variables, operationName), request, response), response);
                    }
                } else {
                    response.setStatus(400);
                    log.info("Bad GET request: path was not \"/schema.json\" or no query variable named \"query\" given");
                }
            }
        };
        this.postHandler = (request, response) -> {
            GraphQLInvocationInputFactory invocationInputFactory = this.configuration.getInvocationInputFactory();
            GraphQLObjectMapper graphQLObjectMapper = this.configuration.getObjectMapper();
            GraphQLQueryInvoker queryInvoker = this.configuration.getQueryInvoker();
            try {
                if (APPLICATION_GRAPHQL.equals(request.getContentType())) {
                    String query = CharStreams.toString((Readable)request.getReader());
                    this.query(queryInvoker, graphQLObjectMapper, invocationInputFactory.create(new GraphQLRequest(query, null, null)), response);
                } else if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data") && !request.getParts().isEmpty()) {
                    Map<String, List<Part>> fileItems = request.getParts().stream().collect(Collectors.groupingBy(Part::getName));
                    for (String key : MULTIPART_KEYS) {
                        if (!fileItems.containsKey(key)) continue;
                        Optional<Part> queryItem = this.getFileItem(fileItems, key);
                        if (!queryItem.isPresent()) break;
                        InputStream inputStream = AbstractGraphQLHttpServlet.asMarkableInputStream(queryItem.get().getInputStream());
                        Optional<Map> variablesMap = this.getFileItem(fileItems, "map").map(graphQLObjectMapper::deserializeMultipartMap);
                        if (this.isBatchedQuery(inputStream)) {
                            List<GraphQLRequest> graphQLRequests = graphQLObjectMapper.readBatchedGraphQLRequest(inputStream);
                            variablesMap.ifPresent(map -> graphQLRequests.forEach(r -> this.mapMultipartVariables((GraphQLRequest)r, (Map<String, List<String>>)map, fileItems)));
                            GraphQLBatchedInvocationInput invocationInput = invocationInputFactory.create(graphQLRequests, request, response);
                            invocationInput.getContext().setParts(fileItems);
                            this.queryBatched(queryInvoker, graphQLObjectMapper, invocationInput, response);
                            return;
                        }
                        GraphQLRequest graphQLRequest = "query".equals(key) ? this.buildRequestFromQuery(inputStream, graphQLObjectMapper, fileItems) : graphQLObjectMapper.readGraphQLRequest(inputStream);
                        variablesMap.ifPresent(m -> this.mapMultipartVariables(graphQLRequest, (Map<String, List<String>>)m, fileItems));
                        GraphQLSingleInvocationInput invocationInput = invocationInputFactory.create(graphQLRequest, request, response);
                        invocationInput.getContext().setParts(fileItems);
                        this.query(queryInvoker, graphQLObjectMapper, invocationInput, response);
                        return;
                    }
                    response.setStatus(400);
                    log.info("Bad POST multipart request: no part named " + Arrays.toString(MULTIPART_KEYS));
                } else {
                    InputStream inputStream = AbstractGraphQLHttpServlet.asMarkableInputStream((InputStream)request.getInputStream());
                    if (this.isBatchedQuery(inputStream)) {
                        this.queryBatched(queryInvoker, graphQLObjectMapper, invocationInputFactory.create(graphQLObjectMapper.readBatchedGraphQLRequest(inputStream), request, response), response);
                    } else {
                        this.query(queryInvoker, graphQLObjectMapper, invocationInputFactory.create(graphQLObjectMapper.readGraphQLRequest(inputStream), request, response), response);
                    }
                }
            }
            catch (Exception e) {
                log.info("Bad POST request: parsing failed", (Throwable)e);
                response.setStatus(400);
            }
        };
    }

    private static InputStream asMarkableInputStream(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return inputStream;
    }

    private GraphQLRequest buildRequestFromQuery(InputStream inputStream, GraphQLObjectMapper graphQLObjectMapper, Map<String, List<Part>> fileItems) throws IOException {
        String query = new String(ByteStreams.toByteArray((InputStream)inputStream));
        Map<String, Object> variables = null;
        Optional<Part> variablesItem = this.getFileItem(fileItems, "variables");
        if (variablesItem.isPresent()) {
            variables = graphQLObjectMapper.deserializeVariables(new String(ByteStreams.toByteArray((InputStream)variablesItem.get().getInputStream())));
        }
        String operationName = null;
        Optional<Part> operationNameItem = this.getFileItem(fileItems, "operationName");
        if (operationNameItem.isPresent()) {
            operationName = new String(ByteStreams.toByteArray((InputStream)operationNameItem.get().getInputStream())).trim();
        }
        GraphQLRequest graphQLRequest = new GraphQLRequest(query, variables, operationName);
        return graphQLRequest;
    }

    private void mapMultipartVariables(GraphQLRequest request, Map<String, List<String>> variablesMap, Map<String, List<Part>> fileItems) {
        Map<String, Object> variables = request.getVariables();
        variablesMap.forEach((partName, objectPaths) -> {
            Part part = this.getFileItem(fileItems, (String)partName).orElseThrow(() -> new RuntimeException("unable to find part name " + partName + " as referenced in the variables map"));
            objectPaths.forEach(objectPath -> VariableMapper.mapVariable(objectPath, variables, part));
        });
    }

    public void addListener(GraphQLServletListener servletListener) {
        this.configuration.add(servletListener);
    }

    public void removeListener(GraphQLServletListener servletListener) {
        this.configuration.remove(servletListener);
    }

    @Override
    public String[] getQueries() {
        return (String[])this.configuration.getInvocationInputFactory().getSchemaProvider().getSchema().getQueryType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String[] getMutations() {
        return (String[])this.configuration.getInvocationInputFactory().getSchemaProvider().getSchema().getMutationType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String executeQuery(String query) {
        try {
            return this.configuration.getObjectMapper().serializeResultAsJson(this.configuration.getQueryInvoker().query(this.configuration.getInvocationInputFactory().create(new GraphQLRequest(query, new HashMap<String, Object>(), null))));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private void doRequestAsync(HttpServletRequest request, HttpServletResponse response, HttpRequestHandler handler) {
        if (this.configuration.isAsyncServletModeEnabled()) {
            AsyncContext asyncContext = request.startAsync();
            HttpServletRequest asyncRequest = (HttpServletRequest)asyncContext.getRequest();
            HttpServletResponse asyncResponse = (HttpServletResponse)asyncContext.getResponse();
            new Thread(() -> this.doRequest(asyncRequest, asyncResponse, handler, asyncContext)).start();
        } else {
            this.doRequest(request, response, handler, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(HttpServletRequest request, HttpServletResponse response, HttpRequestHandler handler, AsyncContext asyncContext) {
        List<GraphQLServletListener.RequestCallback> requestCallbacks = this.runListeners(l -> l.onRequest(request, response));
        try {
            handler.handle(request, response);
            this.runCallbacks(requestCallbacks, c -> c.onSuccess(request, response));
        }
        catch (Throwable t) {
            response.setStatus(500);
            log.error("Error executing GraphQL request!", t);
            this.runCallbacks(requestCallbacks, c -> c.onError(request, response, t));
        }
        finally {
            this.runCallbacks(requestCallbacks, c -> c.onFinally(request, response));
            if (asyncContext != null) {
                asyncContext.complete();
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequestAsync(req, resp, this.getHandler);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequestAsync(req, resp, this.postHandler);
    }

    private Optional<Part> getFileItem(Map<String, List<Part>> fileItems, String name) {
        return Optional.ofNullable(fileItems.get(name)).filter(list -> !list.isEmpty()).map(list -> (Part)list.get(0));
    }

    private void query(GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper graphQLObjectMapper, GraphQLSingleInvocationInput invocationInput, HttpServletResponse resp) throws IOException {
        ExecutionResult result = queryInvoker.query(invocationInput);
        resp.setContentType(APPLICATION_JSON_UTF8);
        resp.setStatus(200);
        resp.getWriter().write(graphQLObjectMapper.serializeResultAsJson(result));
    }

    private void queryBatched(GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper graphQLObjectMapper, GraphQLBatchedInvocationInput invocationInput, HttpServletResponse resp) throws Exception {
        resp.setContentType(APPLICATION_JSON_UTF8);
        resp.setStatus(200);
        PrintWriter respWriter = resp.getWriter();
        ((Writer)respWriter).write(91);
        queryInvoker.query(invocationInput, (result, hasNext) -> {
            respWriter.write(graphQLObjectMapper.serializeResultAsJson(result));
            if (hasNext.booleanValue()) {
                respWriter.write(44);
            }
        });
        ((Writer)respWriter).write(93);
    }

    private <R> List<R> runListeners(Function<? super GraphQLServletListener, R> action) {
        return this.configuration.getListeners().stream().map(listener -> {
            try {
                return action.apply((GraphQLServletListener)listener);
            }
            catch (Throwable t) {
                log.error("Error running listener: {}", listener, (Object)t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T> void runCallbacks(List<T> callbacks, Consumer<T> action) {
        callbacks.forEach(callback -> {
            try {
                action.accept(callback);
            }
            catch (Throwable t) {
                log.error("Error running callback: {}", callback, (Object)t);
            }
        });
    }

    private boolean isBatchedQuery(InputStream inputStream) throws IOException {
        int length;
        if (inputStream == null) {
            return false;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[128];
        inputStream.mark(0);
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
            String chunk = result.toString();
            Boolean isArrayStart = this.isArrayStart(chunk);
            if (isArrayStart == null) continue;
            inputStream.reset();
            return isArrayStart;
        }
        inputStream.reset();
        return false;
    }

    private boolean isBatchedQuery(String query) {
        if (query == null) {
            return false;
        }
        Boolean isArrayStart = this.isArrayStart(query);
        return isArrayStart != null && isArrayStart != false;
    }

    private Boolean isArrayStart(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return ch == '[';
        }
        return null;
    }

    protected static interface HttpRequestHandler
    extends BiConsumer<HttpServletRequest, HttpServletResponse> {
        @Override
        default public void accept(HttpServletRequest request, HttpServletResponse response) {
            try {
                this.handle(request, response);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void handle(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
    }
}

