/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.DecoratedExecutionResult;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.core.GraphQLMBean;
import graphql.kickstart.servlet.core.GraphQLServletListener;
import graphql.schema.GraphQLFieldDefinition;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphQLHttpServlet
extends HttpServlet
implements Servlet,
GraphQLMBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGraphQLHttpServlet.class);

    protected abstract GraphQLConfiguration getConfiguration();

    public void addListener(GraphQLServletListener servletListener) {
        this.getConfiguration().add(servletListener);
    }

    public void removeListener(GraphQLServletListener servletListener) {
        this.getConfiguration().remove(servletListener);
    }

    @Override
    public String[] getQueries() {
        return (String[])this.getConfiguration().getInvocationInputFactory().getSchemaProvider().getSchema().getQueryType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String[] getMutations() {
        return (String[])this.getConfiguration().getInvocationInputFactory().getSchemaProvider().getSchema().getMutationType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String executeQuery(String query) {
        try {
            GraphQLRequest graphQLRequest = GraphQLRequest.createQueryOnlyRequest((String)query);
            GraphQLSingleInvocationInput invocationInput = this.getConfiguration().getInvocationInputFactory().create(graphQLRequest);
            DecoratedExecutionResult result = this.getConfiguration().getGraphQLInvoker().query((GraphQLInvocationInput)invocationInput).getResult();
            return this.getConfiguration().getObjectMapper().serializeResultAsJson((ExecutionResult)result);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.doRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.doRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(HttpServletRequest request, HttpServletResponse response) {
        List<GraphQLServletListener.RequestCallback> requestCallbacks = this.runListeners(l -> l.onRequest(request, response));
        try {
            this.getConfiguration().getHttpRequestHandler().handle(request, response);
            this.runCallbacks(requestCallbacks, c -> c.onSuccess(request, response));
        }
        catch (Exception t) {
            log.error("Error executing GraphQL request!", (Throwable)t);
            this.runCallbacks(requestCallbacks, c -> c.onError(request, response, t));
        }
        finally {
            this.runCallbacks(requestCallbacks, c -> c.onFinally(request, response));
        }
    }

    private <R> List<R> runListeners(Function<? super GraphQLServletListener, R> action) {
        return this.getConfiguration().getListeners().stream().map(listener -> {
            try {
                return action.apply((GraphQLServletListener)listener);
            }
            catch (Exception t) {
                log.error("Error running listener: {}", listener, (Object)t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T> void runCallbacks(List<T> callbacks, Consumer<T> action) {
        callbacks.forEach(callback -> {
            try {
                action.accept(callback);
            }
            catch (Exception t) {
                log.error("Error running callback: {}", callback, (Object)t);
            }
        });
    }
}

