/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets.tasks;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import io.dropwizard.servlets.tasks.Task;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogConfigurationTask
extends Task {
    private final ILoggerFactory loggerContext;
    private final AtomicReference<Timer> timerReference = new AtomicReference();

    public LogConfigurationTask() {
        this(LoggerFactory.getILoggerFactory());
    }

    public LogConfigurationTask(ILoggerFactory loggerContext) {
        super("log-level");
        this.loggerContext = loggerContext;
    }

    @Override
    public void execute(Map<String, List<String>> parameters, PrintWriter output) throws Exception {
        List<String> loggerNames = this.getLoggerNames(parameters);
        Level loggerLevel = this.getLoggerLevel(parameters);
        Duration duration = this.getDuration(parameters);
        for (String loggerName : loggerNames) {
            final Logger logger2 = ((LoggerContext)this.loggerContext).getLogger(loggerName);
            String message = String.format("Configured logging level for %s to %s", loggerName, loggerLevel);
            if (loggerLevel != null && duration != null) {
                long millis = duration.toMillis();
                this.getTimer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        logger2.setLevel(null);
                    }
                }, millis);
                message = message + String.format(" for %s milliseconds", millis);
            }
            logger2.setLevel(loggerLevel);
            output.println(message);
            output.flush();
        }
    }

    private List<String> getLoggerNames(Map<String, List<String>> parameters) {
        return parameters.getOrDefault("logger", Collections.emptyList());
    }

    @Nullable
    private Level getLoggerLevel(Map<String, List<String>> parameters) {
        List loggerLevels = parameters.getOrDefault("level", Collections.emptyList());
        return loggerLevels.isEmpty() ? null : Level.valueOf((String)loggerLevels.get(0));
    }

    @Nullable
    private Duration getDuration(Map<String, List<String>> parameters) {
        List durations = parameters.getOrDefault("duration", Collections.emptyList());
        return durations.isEmpty() ? null : Duration.parse((CharSequence)durations.get(0));
    }

    @Nonnull
    private Timer getTimer() {
        return this.timerReference.updateAndGet(timer -> timer == null ? new Timer(LogConfigurationTask.class.getSimpleName(), true) : timer);
    }
}

