/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;

public class AngleCalc {
    public static final AngleCalc ANGLE_CALC = new AngleCalc();
    private static final double PI_4 = 0.7853981633974483;
    private static final double PI_2 = 1.5707963267948966;
    private static final double PI3_4 = 2.356194490192345;

    static double atan2(double y, double x) {
        double angle;
        double r;
        double absY = Math.abs(y) + 1.0E-10;
        if (x < 0.0) {
            r = (x + absY) / (absY - x);
            angle = 2.356194490192345;
        } else {
            r = (x - absY) / (x + absY);
            angle = 0.7853981633974483;
        }
        angle += (0.1963 * r * r - 0.9817) * r;
        if (y < 0.0) {
            return -angle;
        }
        return angle;
    }

    public double calcOrientation(double lat1, double lon1, double lat2, double lon2) {
        return this.calcOrientation(lat1, lon1, lat2, lon2, true);
    }

    public double calcOrientation(double lat1, double lon1, double lat2, double lon2, boolean exact) {
        double shrinkFactor = Math.cos(Math.toRadians((lat1 + lat2) / 2.0));
        if (exact) {
            return Math.atan2(lat2 - lat1, shrinkFactor * (lon2 - lon1));
        }
        return AngleCalc.atan2(lat2 - lat1, shrinkFactor * (lon2 - lon1));
    }

    public double convertAzimuth2xaxisAngle(double azimuth) {
        if (Double.compare(azimuth, 360.0) > 0 || Double.compare(azimuth, 0.0) < 0) {
            throw new IllegalArgumentException("Azimuth " + azimuth + " must be in (0, 360)");
        }
        double angleXY = 1.5707963267948966 - azimuth / 180.0 * Math.PI;
        if (angleXY < -Math.PI) {
            angleXY += Math.PI * 2;
        }
        if (angleXY > Math.PI) {
            angleXY -= Math.PI * 2;
        }
        return angleXY;
    }

    public double alignOrientation(double baseOrientation, double orientation) {
        double resultOrientation = baseOrientation >= 0.0 ? (orientation < -Math.PI + baseOrientation ? orientation + Math.PI * 2 : orientation) : (orientation > Math.PI + baseOrientation ? orientation - Math.PI * 2 : orientation);
        return resultOrientation;
    }

    public double calcAzimuth(double lat1, double lon1, double lat2, double lon2) {
        double orientation = 1.5707963267948966 - this.calcOrientation(lat1, lon1, lat2, lon2);
        if (orientation < 0.0) {
            orientation += Math.PI * 2;
        }
        return Math.toDegrees(Helper.round4(orientation)) % 360.0;
    }

    public String azimuth2compassPoint(double azimuth) {
        double slice = 22.5;
        String cp = azimuth < slice ? "N" : (azimuth < slice * 3.0 ? "NE" : (azimuth < slice * 5.0 ? "E" : (azimuth < slice * 7.0 ? "SE" : (azimuth < slice * 9.0 ? "S" : (azimuth < slice * 11.0 ? "SW" : (azimuth < slice * 13.0 ? "W" : (azimuth < slice * 15.0 ? "NW" : "N")))))));
        return cp;
    }

    public boolean isClockwise(double aX, double aY, double bX, double bY, double cX, double cY) {
        double angleDiff = (cX - aX) * (bY - aY) - (cY - aY) * (bX - aX);
        return angleDiff < 0.0;
    }
}

