/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.util.Helper;

public enum Smoothness {
    MISSING("missing"),
    EXCELLENT("excellent"),
    GOOD("good"),
    INTERMEDIATE("intermediate"),
    BAD("bad"),
    VERY_BAD("very_bad"),
    HORRIBLE("horrible"),
    VERY_HORRIBLE("very_horrible"),
    IMPASSABLE("impassable"),
    OTHER("other");

    public static final String KEY = "smoothness";
    private final String name;

    private Smoothness(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static Smoothness find(String name) {
        if (Helper.isEmpty(name)) {
            return MISSING;
        }
        try {
            return Smoothness.valueOf(Helper.toUpperCase(name));
        }
        catch (IllegalArgumentException ex) {
            return OTHER;
        }
    }
}

