/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.Profile;
import com.graphhopper.http.GHPointParam;
import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.isochrone.algorithm.ShortestPathTree;
import com.graphhopper.isochrone.algorithm.Triangulator;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.routing.ProfileResolver;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.FiniteWeightFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import io.dropwizard.jersey.params.IntParam;
import io.dropwizard.jersey.params.LongParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.ToDoubleFunction;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hibernate.validator.constraints.Range;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="isochrone")
public class IsochroneResource {
    private static final Logger logger = LoggerFactory.getLogger(IsochroneResource.class);
    private final GraphHopper graphHopper;
    private final Triangulator triangulator;
    private final ProfileResolver profileResolver;

    @Inject
    public IsochroneResource(GraphHopper graphHopper, Triangulator triangulator, ProfileResolver profileResolver) {
        this.graphHopper = graphHopper;
        this.triangulator = triangulator;
        this.profileResolver = profileResolver;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context UriInfo uriInfo, @QueryParam(value="profile") String profileName, @QueryParam(value="buckets") @Range(min=1L, max=20L) @DefaultValue(value="1") @Range(min=1L, max=20L) IntParam nBuckets, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="point") @NotNull GHPointParam point, @QueryParam(value="time_limit") @DefaultValue(value="600") LongParam timeLimitInSeconds, @QueryParam(value="distance_limit") @DefaultValue(value="-1") LongParam distanceLimitInMeter, @QueryParam(value="weight_limit") @DefaultValue(value="-1") LongParam weightLimit, @QueryParam(value="type") @DefaultValue(value="json") ResponseType respType, @QueryParam(value="tolerance") @DefaultValue(value="0") double toleranceInMeter, @QueryParam(value="full_geometry") @DefaultValue(value="false") boolean fullGeometry) {
        double limit;
        Snap snap;
        StopWatch sw = new StopWatch().start();
        PMap hintsMap = new PMap();
        RouteResource.initHints(hintsMap, uriInfo.getQueryParameters());
        hintsMap.putObject("ch.disable", true);
        hintsMap.putObject("lm.disable", true);
        if (Helper.isEmpty(profileName)) {
            profileName = this.profileResolver.resolveProfile(hintsMap).getName();
            RouteResource.removeLegacyParameters(hintsMap);
        }
        RouteResource.errorIfLegacyParameters(hintsMap);
        Profile profile = this.graphHopper.getProfile(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("The requested profile '" + profileName + "' does not exist");
        }
        LocationIndex locationIndex = this.graphHopper.getLocationIndex();
        GraphHopperStorage graph = this.graphHopper.getGraphHopperStorage();
        Weighting weighting = this.graphHopper.createWeighting(profile, hintsMap);
        BooleanEncodedValue inSubnetworkEnc = this.graphHopper.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(profileName));
        if (hintsMap.has("block_area")) {
            GraphEdgeIdFinder.BlockArea blockArea = GraphEdgeIdFinder.createBlockArea(graph, locationIndex, Collections.singletonList(point.get()), hintsMap, new FiniteWeightFilter(weighting));
            weighting = new BlockAreaWeighting(weighting, blockArea);
        }
        if (!(snap = locationIndex.findClosest(((GHPoint)point.get()).lat, ((GHPoint)point.get()).lon, new DefaultSnapFilter(weighting, inSubnetworkEnc))).isValid()) {
            throw new IllegalArgumentException("Point not found:" + point);
        }
        QueryGraph queryGraph = QueryGraph.create((Graph)graph, snap);
        TraversalMode traversalMode = profile.isTurnCosts() ? TraversalMode.EDGE_BASED : TraversalMode.NODE_BASED;
        ShortestPathTree shortestPathTree = new ShortestPathTree(queryGraph, queryGraph.wrapWeighting(weighting), reverseFlow, traversalMode);
        if ((Long)weightLimit.get() > 0L) {
            limit = ((Long)weightLimit.get()).longValue();
            shortestPathTree.setWeightLimit(limit + Math.max(limit * 0.14, 2000.0));
        } else if ((Long)distanceLimitInMeter.get() > 0L) {
            limit = ((Long)distanceLimitInMeter.get()).longValue();
            shortestPathTree.setDistanceLimit(limit + Math.max(limit * 0.14, 2000.0));
        } else {
            limit = (Long)timeLimitInSeconds.get() * 1000L;
            shortestPathTree.setTimeLimit(limit + Math.max(limit * 0.14, 200000.0));
        }
        ArrayList<Double> zs = new ArrayList<Double>();
        double delta = limit / (double)((Integer)nBuckets.get()).intValue();
        for (int i = 0; i < (Integer)nBuckets.get(); ++i) {
            zs.add((double)(i + 1) * delta);
        }
        ToDoubleFunction<ShortestPathTree.IsoLabel> fz = (Long)weightLimit.get() > 0L ? l -> l.weight : ((Long)distanceLimitInMeter.get() > 0L ? l -> l.distance : l -> l.time);
        Triangulator.Result result = this.triangulator.triangulate(snap, queryGraph, shortestPathTree, fz, IsochroneResource.degreesFromMeters(toleranceInMeter));
        ContourBuilder contourBuilder = new ContourBuilder(result.triangulation);
        ArrayList<Geometry> isochrones = new ArrayList<Geometry>();
        for (Double d : zs) {
            logger.info("Building contour z={}", (Object)d);
            Geometry isochrone = contourBuilder.computeIsoline(d, result.seedEdges);
            if (((GeometryCollection)isochrone).isEmpty()) continue;
            if (fullGeometry) {
                isochrones.add(isochrone);
                continue;
            }
            Polygon maxPolygon = this.heuristicallyFindMainConnectedComponent((MultiPolygon)isochrone, isochrone.getFactory().createPoint(new Coordinate(((GHPoint)point.get()).lon, ((GHPoint)point.get()).lat)));
            isochrones.add(isochrone.getFactory().createPolygon((LinearRing)maxPolygon.getExteriorRing()));
        }
        ArrayList<JsonFeature> features = new ArrayList<JsonFeature>();
        for (Geometry isochrone : isochrones) {
            JsonFeature feature = new JsonFeature();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("bucket", features.size());
            if (respType == ResponseType.geojson) {
                properties.put("copyrights", ResponsePathSerializer.COPYRIGHTS);
            }
            feature.setProperties(properties);
            feature.setGeometry(isochrone);
            features.add(feature);
        }
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        sw.stop();
        ObjectNode finalJson = null;
        if (respType == ResponseType.geojson) {
            objectNode.put("type", "FeatureCollection");
            objectNode.putPOJO("features", features);
            finalJson = objectNode;
        } else {
            objectNode.putPOJO("polygons", features);
            ObjectNode info = objectNode.putObject("info");
            info.putPOJO("copyrights", ResponsePathSerializer.COPYRIGHTS);
            info.put("took", Math.round(sw.getMillis()));
            finalJson = objectNode;
        }
        logger.info("took: " + sw.getSeconds() + ", visited nodes:" + shortestPathTree.getVisitedNodes());
        return Response.ok(finalJson).header("X-GH-Took", "" + sw.getSeconds() * 1000.0f).build();
    }

    private Polygon heuristicallyFindMainConnectedComponent(MultiPolygon multiPolygon, Point point) {
        int maxPoints = 0;
        Polygon maxPolygon = null;
        for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
            if (polygon.contains(point)) {
                return polygon;
            }
            if (polygon.getNumPoints() <= maxPoints) continue;
            maxPoints = polygon.getNumPoints();
            maxPolygon = polygon;
        }
        return maxPolygon;
    }

    static double degreesFromMeters(double distanceInMeters) {
        return distanceInMeters / 111194.92664455873;
    }

    public static enum ResponseType {
        json,
        geojson;

    }
}

