/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.google.common.collect.ArrayListMultimap;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class WrapperGraph
implements Graph {
    private final Graph mainGraph;
    private final IntObjectMap<EdgeIteratorState> extraEdges = new IntObjectHashMap<EdgeIteratorState>();
    private final ArrayListMultimap<Integer, VirtualEdgeIteratorState> extraEdgesBySource = ArrayListMultimap.create();
    private final ArrayListMultimap<Integer, VirtualEdgeIteratorState> extraEdgesByDestination = ArrayListMultimap.create();

    public WrapperGraph(Graph mainGraph, List<VirtualEdgeIteratorState> extraEdges) {
        this.mainGraph = mainGraph;
        extraEdges.forEach(e -> this.extraEdges.put(e.getEdge(), (EdgeIteratorState)e));
        for (VirtualEdgeIteratorState extraEdge : extraEdges) {
            if (extraEdge == null) {
                throw new RuntimeException();
            }
            this.extraEdgesBySource.put((Object)extraEdge.getBaseNode(), (Object)extraEdge);
            this.extraEdgesByDestination.put((Object)extraEdge.getAdjNode(), (Object)new VirtualEdgeIteratorState(extraEdge.getOriginalEdgeKey(), extraEdge.getEdgeKey(), extraEdge.getAdjNode(), extraEdge.getBaseNode(), extraEdge.getDistance(), extraEdge.getFlags(), extraEdge.getName(), extraEdge.fetchWayGeometry(FetchMode.ALL), true));
        }
    }

    @Override
    public Graph getBaseGraph() {
        return this;
    }

    @Override
    public int getNodes() {
        return IntStream.concat(IntStream.of(this.mainGraph.getNodes() - 1), StreamSupport.stream(this.extraEdges.values().spliterator(), false).flatMapToInt(cursor -> IntStream.of(((EdgeIteratorState)cursor.value).getBaseNode(), ((EdgeIteratorState)cursor.value).getAdjNode()))).max().getAsInt() + 1;
    }

    @Override
    public int getEdges() {
        return this.getAllEdges().length();
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.mainGraph.getNodeAccess();
    }

    @Override
    public BBox getBounds() {
        return this.mainGraph.getBounds();
    }

    @Override
    public EdgeIteratorState edge(int a, int b) {
        throw new RuntimeException();
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
        EdgeIteratorState edgeIteratorState = this.extraEdges.get(edgeId);
        if (edgeIteratorState != null) {
            return edgeIteratorState;
        }
        return this.mainGraph.getEdgeIteratorState(edgeId, adjNode);
    }

    @Override
    public EdgeIteratorState getEdgeIteratorStateForKey(int edgeKey) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return new AllEdgesIterator(){

            @Override
            public int length() {
                return IntStream.concat(IntStream.of(WrapperGraph.this.mainGraph.getAllEdges().length() - 1), StreamSupport.stream(WrapperGraph.this.extraEdges.values().spliterator(), false).mapToInt(cursor -> ((EdgeIteratorState)cursor.value).getEdge())).max().getAsInt() + 1;
            }

            @Override
            public boolean next() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getEdge() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getEdgeKey() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getOrigEdgeFirst() {
                return this.getEdge();
            }

            @Override
            public int getOrigEdgeLast() {
                return this.getEdge();
            }

            @Override
            public int getBaseNode() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getAdjNode() {
                throw new UnsupportedOperationException();
            }

            @Override
            public PointList fetchWayGeometry(FetchMode mode) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState setWayGeometry(PointList list) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double getDistance() {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState setDistance(double dist) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IntsRef getFlags() {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState setFlags(IntsRef flags) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean get(BooleanEncodedValue property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean getReverse(BooleanEncodedValue property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState set(BooleanEncodedValue property, boolean fwd, boolean bwd) {
                return this;
            }

            @Override
            public int get(IntEncodedValue property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getReverse(IntEncodedValue property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState set(IntEncodedValue property, int value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState set(IntEncodedValue property, int fwd, int bwd) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double get(DecimalEncodedValue property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double getReverse(DecimalEncodedValue property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState set(DecimalEncodedValue property, double value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState set(DecimalEncodedValue property, double fwd, double bwd) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T extends Enum<?>> T get(EnumEncodedValue<T> property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T extends Enum<?>> T getReverse(EnumEncodedValue<T> property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T extends Enum<?>> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T fwd, T bwd) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String get(StringEncodedValue property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState set(StringEncodedValue property, String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getReverse(StringEncodedValue property) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState setReverse(StringEncodedValue property, String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState set(StringEncodedValue property, String fwd, String bwd) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getName() {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState setName(String name) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState detach(boolean reverse) {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgeIteratorState copyPropertiesFrom(EdgeIteratorState e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public EdgeExplorer createEdgeExplorer(final EdgeFilter filter) {
        final EdgeExplorer baseGraphEdgeExplorer = this.mainGraph.createEdgeExplorer(filter);
        return new EdgeExplorer(){

            @Override
            public EdgeIterator setBaseNode(final int baseNode) {
                ArrayList extraEdges = new ArrayList();
                extraEdges.addAll(WrapperGraph.this.extraEdgesBySource.get((Object)baseNode));
                extraEdges.addAll(WrapperGraph.this.extraEdgesByDestination.get((Object)baseNode));
                final Iterator iterator = extraEdges.iterator();
                return new EdgeIterator(){
                    EdgeIteratorState current = null;
                    EdgeIterator baseGraphEdgeIterator = this.baseGraphIterator();

                    private EdgeIterator baseGraphIterator() {
                        if (baseNode < WrapperGraph.this.mainGraph.getNodes()) {
                            return baseGraphEdgeExplorer.setBaseNode(baseNode);
                        }
                        return null;
                    }

                    @Override
                    public boolean next() {
                        if (this.baseGraphEdgeIterator != null) {
                            if (this.baseGraphEdgeIterator.next()) {
                                this.current = this.baseGraphEdgeIterator;
                                return true;
                            }
                            this.baseGraphEdgeIterator = null;
                        }
                        while (iterator.hasNext()) {
                            this.current = (EdgeIteratorState)iterator.next();
                            if (!filter.accept(this.current)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int getEdge() {
                        return this.current.getEdge();
                    }

                    @Override
                    public int getEdgeKey() {
                        return this.current.getEdgeKey();
                    }

                    @Override
                    public int getOrigEdgeFirst() {
                        return this.current.getOrigEdgeFirst();
                    }

                    @Override
                    public int getOrigEdgeLast() {
                        return this.current.getOrigEdgeLast();
                    }

                    @Override
                    public int getBaseNode() {
                        return this.current.getBaseNode();
                    }

                    @Override
                    public int getAdjNode() {
                        return this.current.getAdjNode();
                    }

                    @Override
                    public PointList fetchWayGeometry(FetchMode mode) {
                        return this.current.fetchWayGeometry(mode);
                    }

                    @Override
                    public EdgeIteratorState setWayGeometry(PointList list) {
                        this.current.setWayGeometry(list);
                        return this;
                    }

                    @Override
                    public double getDistance() {
                        return this.current.getDistance();
                    }

                    @Override
                    public EdgeIteratorState setDistance(double dist) {
                        this.current.setDistance(dist);
                        return this;
                    }

                    @Override
                    public IntsRef getFlags() {
                        return this.current.getFlags();
                    }

                    @Override
                    public EdgeIteratorState setFlags(IntsRef edgeFlags) {
                        this.current.setFlags(edgeFlags);
                        return this;
                    }

                    @Override
                    public boolean get(BooleanEncodedValue property) {
                        return this.current.get(property);
                    }

                    @Override
                    public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
                        this.current.set(property, value);
                        return this;
                    }

                    @Override
                    public boolean getReverse(BooleanEncodedValue property) {
                        return this.current.getReverse(property);
                    }

                    @Override
                    public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
                        this.current.setReverse(property, value);
                        return this;
                    }

                    @Override
                    public EdgeIteratorState set(BooleanEncodedValue property, boolean fwd, boolean bwd) {
                        this.current.set(property, fwd, bwd);
                        return this;
                    }

                    @Override
                    public int get(IntEncodedValue property) {
                        return this.current.get(property);
                    }

                    @Override
                    public EdgeIteratorState set(IntEncodedValue property, int value) {
                        this.current.set(property, value);
                        return this;
                    }

                    @Override
                    public int getReverse(IntEncodedValue property) {
                        return this.current.getReverse(property);
                    }

                    @Override
                    public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
                        this.current.setReverse(property, value);
                        return this;
                    }

                    @Override
                    public EdgeIteratorState set(IntEncodedValue property, int fwd, int bwd) {
                        this.current.set(property, fwd, bwd);
                        return this;
                    }

                    @Override
                    public double get(DecimalEncodedValue property) {
                        return this.current.get(property);
                    }

                    @Override
                    public EdgeIteratorState set(DecimalEncodedValue property, double value) {
                        this.current.set(property, value);
                        return this;
                    }

                    @Override
                    public double getReverse(DecimalEncodedValue property) {
                        return this.current.getReverse(property);
                    }

                    @Override
                    public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
                        this.current.setReverse(property, value);
                        return this;
                    }

                    @Override
                    public EdgeIteratorState set(DecimalEncodedValue property, double fwd, double bwd) {
                        this.current.set(property, fwd, bwd);
                        return this;
                    }

                    @Override
                    public <T extends Enum<?>> T get(EnumEncodedValue<T> property) {
                        return this.current.get(property);
                    }

                    @Override
                    public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
                        this.current.set(property, value);
                        return this;
                    }

                    @Override
                    public <T extends Enum<?>> T getReverse(EnumEncodedValue<T> property) {
                        return this.current.getReverse(property);
                    }

                    @Override
                    public <T extends Enum<?>> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
                        this.current.setReverse(property, value);
                        return this;
                    }

                    @Override
                    public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T fwd, T bwd) {
                        this.current.set(property, fwd, bwd);
                        return this;
                    }

                    @Override
                    public String get(StringEncodedValue property) {
                        return this.current.get(property);
                    }

                    @Override
                    public EdgeIteratorState set(StringEncodedValue property, String value) {
                        this.current.set(property, value);
                        return this;
                    }

                    @Override
                    public String getReverse(StringEncodedValue property) {
                        return this.current.getReverse(property);
                    }

                    @Override
                    public EdgeIteratorState setReverse(StringEncodedValue property, String value) {
                        this.current.setReverse(property, value);
                        return this;
                    }

                    @Override
                    public EdgeIteratorState set(StringEncodedValue property, String fwd, String bwd) {
                        this.current.set(property, fwd, bwd);
                        return this;
                    }

                    @Override
                    public String getName() {
                        return this.current.getName();
                    }

                    @Override
                    public EdgeIteratorState setName(String name) {
                        this.current.setName(name);
                        return this;
                    }

                    @Override
                    public EdgeIteratorState detach(boolean reverse) {
                        return this.current.detach(reverse);
                    }

                    @Override
                    public EdgeIteratorState copyPropertiesFrom(EdgeIteratorState e) {
                        return this.current.copyPropertiesFrom(e);
                    }

                    public String toString() {
                        return this.current.toString();
                    }
                };
            }
        };
    }

    @Override
    public TurnCostStorage getTurnCostStorage() {
        return this.mainGraph.getTurnCostStorage();
    }

    @Override
    public Weighting wrapWeighting(Weighting weighting) {
        return this.mainGraph.wrapWeighting(weighting);
    }

    @Override
    public int getOtherNode(int edge, int node) {
        return this.mainGraph.getOtherNode(edge, node);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        return this.mainGraph.isAdjacentToNode(edge, node);
    }
}

