/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.apache.commons.collections;

import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntFloatBinaryHeap {
    private static final int GROW_FACTOR = 2;
    private int size;
    private int[] elements;
    private float[] keys;

    public IntFloatBinaryHeap() {
        this(1000);
    }

    public IntFloatBinaryHeap(int initialCapacity) {
        this.elements = new int[initialCapacity + 1];
        this.keys = new float[initialCapacity + 1];
        this.keys[0] = Float.NEGATIVE_INFINITY;
    }

    private boolean isFull() {
        return this.elements.length == this.size + 1;
    }

    public void update(double key, int element) {
        int i;
        for (i = 1; i <= this.size && this.elements[i] != element; ++i) {
        }
        if (i > this.size) {
            return;
        }
        if (key > (double)this.keys[i]) {
            this.keys[i] = (float)key;
            this.percolateDownMinHeap(i);
        } else {
            this.keys[i] = (float)key;
            this.percolateUpMinHeap(i);
        }
    }

    public void insert(double key, int element) {
        if (this.isFull()) {
            this.ensureCapacity(this.elements.length * 2);
        }
        ++this.size;
        this.elements[this.size] = element;
        this.keys[this.size] = (float)key;
        this.percolateUpMinHeap(this.size);
    }

    public int peekElement() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Heap is empty. Cannot peek element.");
        }
        return this.elements[1];
    }

    public float peekKey() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Heap is empty. Cannot peek key.");
        }
        return this.keys[1];
    }

    public int poll() {
        int result = this.peekElement();
        this.elements[1] = this.elements[this.size];
        this.keys[1] = this.keys[this.size];
        --this.size;
        if (this.size != 0) {
            this.percolateDownMinHeap(1);
        }
        return result;
    }

    final void percolateDownMinHeap(int index) {
        int element = this.elements[index];
        float key = this.keys[index];
        int hole = index;
        while (hole * 2 <= this.size) {
            int child = hole * 2;
            if (child != this.size && this.keys[child + 1] < this.keys[child]) {
                ++child;
            }
            if (this.keys[child] >= key) break;
            this.elements[hole] = this.elements[child];
            this.keys[hole] = this.keys[child];
            hole = child;
        }
        this.elements[hole] = element;
        this.keys[hole] = key;
    }

    final void percolateUpMinHeap(int index) {
        int hole = index;
        int element = this.elements[hole];
        float key = this.keys[hole];
        while (key < this.keys[hole / 2]) {
            int next = hole / 2;
            this.elements[hole] = this.elements[next];
            this.keys[hole] = this.keys[next];
            hole = next;
        }
        this.elements[hole] = element;
        this.keys[hole] = key;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.trimTo(0);
    }

    void trimTo(int toSize) {
        this.size = toSize++;
        Arrays.fill(this.elements, toSize, this.size + 1, 0);
    }

    public void ensureCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalStateException("IntFloatBinaryHeap contains too many elements to fit in new capacity.");
        }
        this.elements = Arrays.copyOf(this.elements, capacity + 1);
        this.keys = Arrays.copyOf(this.keys, capacity + 1);
    }

    public long getCapacity() {
        return this.elements.length;
    }

    public long getMemoryUsage() {
        return (long)this.elements.length * 4L + (long)this.keys.length * 4L;
    }
}

