/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import java.io.IOException;
import org.joda.time.DateTimeZone;

public class DateTimeZoneDeserializer
extends JodaDeserializerBase<DateTimeZone> {
    private static final long serialVersionUID = 1L;

    public DateTimeZoneDeserializer() {
        super(DateTimeZone.class);
    }

    @Override
    public DateTimeZone deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return DateTimeZone.forOffsetHours(p.getIntValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            return DateTimeZone.forID(p.getText().trim());
        }
        return (DateTimeZone)this._handleNotNumberOrString(p, ctxt);
    }
}

