/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.server;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.codahale.metrics.jetty9.InstrumentedQueuedThreadPool;
import com.codahale.metrics.servlets.AdminServlet;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jersey.filter.AllowedMethodsFilter;
import io.dropwizard.jersey.jackson.JacksonFeature;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.jersey.validation.HibernateValidationBinder;
import io.dropwizard.jetty.GzipHandlerFactory;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.jetty.ServerPushFilterFactory;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.request.logging.LogbackAccessRequestLogFactory;
import io.dropwizard.request.logging.RequestLogFactory;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.servlets.ThreadNameFilter;
import io.dropwizard.setup.ExceptionMapperBinder;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import io.dropwizard.validation.ValidationMethod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.setuid.RLimit;
import org.eclipse.jetty.setuid.SetUIDListener;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerFactory
implements ServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerFactory.class);
    @Valid
    @Nullable
    private RequestLogFactory<?> requestLog;
    @Valid
    @NotNull
    private GzipHandlerFactory gzip = new GzipHandlerFactory();
    @Valid
    @NotNull
    private ServerPushFilterFactory serverPush = new ServerPushFilterFactory();
    @Min(value=4L)
    private @Min(value=4L) int maxThreads = 1024;
    @Min(value=1L)
    private @Min(value=1L) int minThreads = 8;
    private int maxQueuedRequests = 1024;
    @MinDuration(value=1L)
    private @MinDuration(value=1L) Duration idleThreadTimeout = Duration.minutes(1L);
    @Min(value=1L)
    @Nullable
    private @Min(value=1L) Integer nofileSoftLimit;
    @Min(value=1L)
    @Nullable
    private @Min(value=1L) Integer nofileHardLimit;
    @Nullable
    private Integer gid;
    @Nullable
    private Integer uid;
    @Nullable
    private String user;
    @Nullable
    private String group;
    @Nullable
    private String umask;
    @Nullable
    private Boolean startsAsRoot;
    private Boolean registerDefaultExceptionMappers = Boolean.TRUE;
    private Boolean detailedJsonProcessingExceptionMapper = Boolean.FALSE;
    private Duration shutdownGracePeriod = Duration.seconds(30L);
    @NotNull
    private Set<String> allowedMethods = AllowedMethodsFilter.DEFAULT_ALLOWED_METHODS;
    private Optional<String> jerseyRootPath = Optional.empty();
    private boolean enableThreadNameFilter = true;
    private boolean dumpAfterStart = false;
    private boolean dumpBeforeStop = false;

    @JsonIgnore
    @ValidationMethod(message="must have a smaller minThreads than maxThreads")
    public boolean isThreadPoolSizedCorrectly() {
        return this.minThreads <= this.maxThreads;
    }

    @JsonProperty(value="requestLog")
    public synchronized RequestLogFactory<?> getRequestLogFactory() {
        if (this.requestLog == null) {
            this.requestLog = new LogbackAccessRequestLogFactory();
        }
        return this.requestLog;
    }

    @JsonProperty(value="requestLog")
    public synchronized void setRequestLogFactory(RequestLogFactory<?> requestLog) {
        this.requestLog = requestLog;
    }

    @JsonProperty(value="gzip")
    public GzipHandlerFactory getGzipFilterFactory() {
        return this.gzip;
    }

    @JsonProperty(value="gzip")
    public void setGzipFilterFactory(GzipHandlerFactory gzip) {
        this.gzip = gzip;
    }

    @JsonProperty(value="serverPush")
    public ServerPushFilterFactory getServerPush() {
        return this.serverPush;
    }

    @JsonProperty(value="serverPush")
    public void setServerPush(ServerPushFilterFactory serverPush) {
        this.serverPush = serverPush;
    }

    @JsonProperty
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @JsonProperty
    public void setMaxThreads(int count) {
        this.maxThreads = count;
    }

    @JsonProperty
    public int getMinThreads() {
        return this.minThreads;
    }

    @JsonProperty
    public void setMinThreads(int count) {
        this.minThreads = count;
    }

    @JsonProperty
    public int getMaxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    @JsonProperty
    public void setMaxQueuedRequests(int maxQueuedRequests) {
        this.maxQueuedRequests = maxQueuedRequests;
    }

    @JsonProperty
    public Duration getIdleThreadTimeout() {
        return this.idleThreadTimeout;
    }

    @JsonProperty
    public void setIdleThreadTimeout(Duration idleThreadTimeout) {
        this.idleThreadTimeout = idleThreadTimeout;
    }

    @JsonProperty
    @Nullable
    public Integer getNofileSoftLimit() {
        return this.nofileSoftLimit;
    }

    @JsonProperty
    public void setNofileSoftLimit(Integer nofileSoftLimit) {
        this.nofileSoftLimit = nofileSoftLimit;
    }

    @JsonProperty
    @Nullable
    public Integer getNofileHardLimit() {
        return this.nofileHardLimit;
    }

    @JsonProperty
    public void setNofileHardLimit(Integer nofileHardLimit) {
        this.nofileHardLimit = nofileHardLimit;
    }

    @JsonProperty
    @Nullable
    public Integer getGid() {
        return this.gid;
    }

    @JsonProperty
    public void setGid(Integer gid) {
        this.gid = gid;
    }

    @JsonProperty
    @Nullable
    public Integer getUid() {
        return this.uid;
    }

    @JsonProperty
    public void setUid(Integer uid) {
        this.uid = uid;
    }

    @JsonProperty
    @Nullable
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public void setUser(String user) {
        this.user = user;
    }

    @JsonProperty
    @Nullable
    public String getGroup() {
        return this.group;
    }

    @JsonProperty
    public void setGroup(String group) {
        this.group = group;
    }

    @JsonProperty
    @Nullable
    public String getUmask() {
        return this.umask;
    }

    @JsonProperty
    public void setUmask(String umask) {
        this.umask = umask;
    }

    @JsonProperty
    @Nullable
    public Boolean getStartsAsRoot() {
        return this.startsAsRoot;
    }

    @JsonProperty
    public void setStartsAsRoot(Boolean startsAsRoot) {
        this.startsAsRoot = startsAsRoot;
    }

    public Boolean getRegisterDefaultExceptionMappers() {
        return this.registerDefaultExceptionMappers;
    }

    @JsonProperty
    public void setRegisterDefaultExceptionMappers(Boolean registerDefaultExceptionMappers) {
        this.registerDefaultExceptionMappers = registerDefaultExceptionMappers;
    }

    public Boolean getDetailedJsonProcessingExceptionMapper() {
        return this.detailedJsonProcessingExceptionMapper;
    }

    @JsonProperty
    public void setDetailedJsonProcessingExceptionMapper(Boolean detailedJsonProcessingExceptionMapper) {
        this.detailedJsonProcessingExceptionMapper = detailedJsonProcessingExceptionMapper;
    }

    @JsonProperty
    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    @JsonProperty
    public void setShutdownGracePeriod(Duration shutdownGracePeriod) {
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    @JsonProperty
    public Set<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    @JsonProperty
    public void setAllowedMethods(Set<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    @JsonProperty(value="rootPath")
    public Optional<String> getJerseyRootPath() {
        return this.jerseyRootPath;
    }

    @JsonProperty(value="rootPath")
    public void setJerseyRootPath(String jerseyRootPath) {
        this.jerseyRootPath = Optional.ofNullable(jerseyRootPath);
    }

    @JsonProperty
    public boolean getEnableThreadNameFilter() {
        return this.enableThreadNameFilter;
    }

    @JsonProperty
    public void setEnableThreadNameFilter(boolean enableThreadNameFilter) {
        this.enableThreadNameFilter = enableThreadNameFilter;
    }

    @JsonProperty
    public boolean getDumpAfterStart() {
        return this.dumpAfterStart;
    }

    @JsonProperty
    public void setDumpAfterStart(boolean dumpAfterStart) {
        this.dumpAfterStart = dumpAfterStart;
    }

    @JsonProperty
    public boolean getDumpBeforeStop() {
        return this.dumpBeforeStop;
    }

    @JsonProperty
    public void setDumpBeforeStop(boolean dumpBeforeStop) {
        this.dumpBeforeStop = dumpBeforeStop;
    }

    protected Handler createAdminServlet(Server server, MutableServletContextHandler handler, MetricRegistry metrics, HealthCheckRegistry healthChecks) {
        this.configureSessionsAndSecurity(handler, server);
        handler.setServer(server);
        handler.getServletContext().setAttribute(MetricsServlet.METRICS_REGISTRY, metrics);
        handler.getServletContext().setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, healthChecks);
        handler.addServlet(AdminServlet.class, "/*");
        String allowedMethodsParam = String.join((CharSequence)",", this.allowedMethods);
        handler.addFilter(AllowedMethodsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedMethods", allowedMethodsParam);
        return handler;
    }

    private void configureSessionsAndSecurity(MutableServletContextHandler handler, Server server) {
        handler.setServer(server);
        if (handler.isSecurityEnabled()) {
            handler.getSecurityHandler().setServer(server);
        }
        if (handler.isSessionsEnabled()) {
            handler.getSessionHandler().setServer(server);
        }
    }

    protected Handler createAppServlet(Server server, JerseyEnvironment jersey, ObjectMapper objectMapper, Validator validator, MutableServletContextHandler handler, @Nullable Servlet jerseyContainer, MetricRegistry metricRegistry) {
        this.configureSessionsAndSecurity(handler, server);
        String allowedMethodsParam = String.join((CharSequence)",", this.allowedMethods);
        handler.addFilter(AllowedMethodsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedMethods", allowedMethodsParam);
        if (this.enableThreadNameFilter) {
            handler.addFilter(ThreadNameFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        this.serverPush.addFilter(handler);
        if (jerseyContainer != null) {
            this.jerseyRootPath.ifPresent(jersey::setUrlPattern);
            jersey.register(new JacksonFeature(objectMapper));
            jersey.register(new HibernateValidationBinder(validator));
            if (this.registerDefaultExceptionMappers == null || this.registerDefaultExceptionMappers.booleanValue()) {
                jersey.register(new ExceptionMapperBinder(this.detailedJsonProcessingExceptionMapper));
            }
            handler.addServlet(new ServletHolder("jersey", jerseyContainer), jersey.getUrlPattern());
        }
        InstrumentedHandler instrumented = new InstrumentedHandler(metricRegistry);
        instrumented.setServer(server);
        instrumented.setHandler(handler);
        return instrumented;
    }

    protected ThreadPool createThreadPool(MetricRegistry metricRegistry) {
        BlockingArrayQueue<Runnable> queue = new BlockingArrayQueue<Runnable>(this.minThreads, this.maxThreads, this.maxQueuedRequests);
        InstrumentedQueuedThreadPool threadPool = new InstrumentedQueuedThreadPool(metricRegistry, this.maxThreads, this.minThreads, (int)this.idleThreadTimeout.toMilliseconds(), queue);
        threadPool.setName("dw");
        return threadPool;
    }

    protected Server buildServer(LifecycleEnvironment lifecycle, ThreadPool threadPool) {
        Server server = new Server(threadPool);
        server.addLifeCycleListener(this.buildSetUIDListener());
        lifecycle.attach(server);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setServer(server);
        errorHandler.setShowStacks(false);
        server.addBean(errorHandler);
        server.setStopAtShutdown(true);
        server.setStopTimeout(this.shutdownGracePeriod.toMilliseconds());
        server.setDumpAfterStart(this.dumpAfterStart);
        server.setDumpBeforeStop(this.dumpBeforeStop);
        return server;
    }

    protected SetUIDListener buildSetUIDListener() {
        SetUIDListener listener = new SetUIDListener();
        if (this.startsAsRoot != null) {
            listener.setStartServerAsPrivileged(this.startsAsRoot);
        }
        if (this.gid != null) {
            listener.setGid(this.gid);
        }
        if (this.uid != null) {
            listener.setUid(this.uid);
        }
        if (this.user != null) {
            listener.setUsername(this.user);
        }
        if (this.group != null) {
            listener.setGroupname(this.group);
        }
        if (this.nofileHardLimit != null || this.nofileSoftLimit != null) {
            RLimit rlimit = new RLimit();
            if (this.nofileHardLimit != null) {
                rlimit.setHard(this.nofileHardLimit);
            }
            if (this.nofileSoftLimit != null) {
                rlimit.setSoft(this.nofileSoftLimit);
            }
            listener.setRLimitNoFiles(rlimit);
        }
        if (this.umask != null) {
            listener.setUmaskOctal(this.umask);
        }
        return listener;
    }

    protected Handler addRequestLog(Server server, Handler handler, String name) {
        if (this.getRequestLogFactory().isEnabled()) {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog((RequestLog)this.getRequestLogFactory().build(name));
            server.addBean(requestLogHandler.getRequestLog(), true);
            requestLogHandler.setHandler(handler);
            return requestLogHandler;
        }
        return handler;
    }

    protected Handler addStatsHandler(Handler handler) {
        StatisticsHandler statisticsHandler = new StatisticsHandler();
        statisticsHandler.setHandler(handler);
        return statisticsHandler;
    }

    protected Handler buildGzipHandler(Handler handler) {
        return this.gzip.isEnabled() ? this.gzip.build(handler) : handler;
    }

    protected void printBanner(String name) {
        String msg = "Starting " + name;
        URL resource = Thread.currentThread().getContextClassLoader().getResource("banner.txt");
        if (resource != null) {
            try (InputStream resourceStream = resource.openStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(resourceStream);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String banner = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
                msg = String.format("Starting %s%n%s", name, banner);
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        LOGGER.info(msg);
    }
}

