/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.util.shapes.BBox;
import java.util.function.Consumer;
import org.locationtech.jts.geom.Coordinate;

public class PixelGridTraversal {
    private final double deltaY;
    private final double deltaX;
    int parts;
    BBox bounds;

    public PixelGridTraversal(int parts, BBox bounds) {
        this.parts = parts;
        this.bounds = bounds;
        this.deltaY = (bounds.maxLat - bounds.minLat) / (double)parts;
        this.deltaX = (bounds.maxLon - bounds.minLon) / (double)parts;
    }

    public void traverse(Coordinate a, Coordinate b, Consumer<Coordinate> consumer) {
        double ax = a.x - this.bounds.minLon;
        double ay = a.y - this.bounds.minLat;
        double bx = b.x - this.bounds.minLon;
        double by = b.y - this.bounds.minLat;
        int stepX = ax < bx ? 1 : -1;
        int stepY = ay < by ? 1 : -1;
        double tDeltaX = this.deltaX / Math.abs(bx - ax);
        double tDeltaY = this.deltaY / Math.abs(by - ay);
        int x = Math.min((int)(ax / this.deltaX), this.parts - 1);
        int y = Math.min((int)(ay / this.deltaY), this.parts - 1);
        int x2 = Math.min((int)(bx / this.deltaX), this.parts - 1);
        int y2 = Math.min((int)(by / this.deltaY), this.parts - 1);
        double tMaxX = ((double)(x + (stepX < 0 ? 0 : 1)) * this.deltaX - ax) / (bx - ax);
        double tMaxY = ((double)(y + (stepY < 0 ? 0 : 1)) * this.deltaY - ay) / (by - ay);
        consumer.accept(new Coordinate(x, y));
        while (y != y2 || x != x2) {
            if ((tMaxX < tMaxY || y == y2) && x != x2) {
                tMaxX += tDeltaX;
                x += stepX;
            } else {
                tMaxY += tDeltaY;
                y += stepY;
            }
            consumer.accept(new Coordinate(x, y));
        }
    }
}

