/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.tour;

import com.graphhopper.routing.util.tour.TourStrategy;
import java.util.Random;

public class MultiPointTour
extends TourStrategy {
    private final int allPoints;
    private final double initialHeading;

    public MultiPointTour(Random random, double distanceInMeter, int allPoints) {
        this(random, distanceInMeter, allPoints, Double.NaN);
    }

    public MultiPointTour(Random random, double distanceInMeter, int allPoints, double initialHeading) {
        super(random, distanceInMeter);
        this.allPoints = allPoints;
        this.initialHeading = Double.isNaN(initialHeading) ? (double)random.nextInt(360) : initialHeading;
    }

    @Override
    public int getNumberOfGeneratedPoints() {
        return this.allPoints - 1;
    }

    @Override
    public double getDistanceForIteration(int iteration) {
        return this.slightlyModifyDistance(this.overallDistance / (double)(this.allPoints + 1));
    }

    @Override
    public double getHeadingForIteration(int iteration) {
        if (iteration == 0) {
            return this.initialHeading;
        }
        return this.initialHeading + 360.0 * (double)iteration / (double)this.allPoints;
    }
}

