/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.MaxAxleLoad;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import java.util.Collections;
import java.util.List;

public class OSMMaxAxleLoadParser
implements TagParser {
    private final DecimalEncodedValue maxAxleLoadEncoder;

    public OSMMaxAxleLoadParser() {
        this(MaxAxleLoad.create());
    }

    public OSMMaxAxleLoadParser(DecimalEncodedValue maxAxleLoadEncoder) {
        this.maxAxleLoadEncoder = maxAxleLoadEncoder;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        registerNewEncodedValue.add(this.maxAxleLoadEncoder);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, boolean ferry, IntsRef relationFlags) {
        OSMValueExtractor.extractTons(edgeFlags, way, this.maxAxleLoadEncoder, Collections.singletonList("maxaxleload"));
        return edgeFlags;
    }
}

