/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.util.Helper;

public enum Surface {
    MISSING("missing"),
    PAVED("paved"),
    ASPHALT("asphalt"),
    CONCRETE("concrete"),
    PAVING_STONES("paving_stones"),
    COBBLESTONE("cobblestone"),
    UNPAVED("unpaved"),
    COMPACTED("compacted"),
    FINE_GRAVEL("fine_gravel"),
    GRAVEL("gravel"),
    GROUND("ground"),
    DIRT("dirt"),
    GRASS("grass"),
    SAND("sand"),
    OTHER("other");

    public static final String KEY = "surface";
    private final String name;

    private Surface(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static Surface find(String name) {
        if (Helper.isEmpty(name)) {
            return MISSING;
        }
        try {
            return Surface.valueOf(Helper.toUpperCase(name));
        }
        catch (IllegalArgumentException ex) {
            return OTHER;
        }
    }
}

