/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AbstractBidirCHAlgo;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.ch.CHEntry;
import com.graphhopper.routing.ch.EdgeBasedCHBidirPathExtractor;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.storage.CHEdgeFilter;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;

public abstract class AbstractBidirectionEdgeCHNoSOD
extends AbstractBidirCHAlgo {
    private final EdgeExplorer innerExplorer;

    public AbstractBidirectionEdgeCHNoSOD(RoutingCHGraph graph) {
        super(graph, TraversalMode.EDGE_BASED);
        if (!graph.isEdgeBased()) {
            throw new IllegalArgumentException("Edge-based CH algorithms only work with edge-based CH graphs");
        }
        this.innerExplorer = graph.getBaseGraph().createEdgeExplorer();
        this.setPathExtractorSupplier(() -> new EdgeBasedCHBidirPathExtractor(graph));
    }

    @Override
    protected void postInitFrom() {
        if (this.fromOutEdge == -2) {
            this.fillEdgesFromUsingFilter(CHEdgeFilter.ALL_EDGES);
        } else {
            this.fillEdgesFromUsingFilter(edgeState -> edgeState.getOrigEdgeFirst() == this.fromOutEdge);
        }
    }

    @Override
    protected void postInitTo() {
        if (this.toInEdge == -2) {
            this.fillEdgesToUsingFilter(CHEdgeFilter.ALL_EDGES);
        } else {
            this.fillEdgesToUsingFilter(edgeState -> edgeState.getOrigEdgeLast() == this.toInEdge);
        }
    }

    @Override
    protected void updateBestPath(double edgeWeight, SPTEntry entry, int origEdgeId, int traversalId, boolean reverse) {
        boolean oppositeEdgeRestricted;
        int oppositeEdge;
        assert (Double.isInfinite(edgeWeight)) : "edge-based CH does not use pre-calculated edge weight";
        int oppositeNode = reverse ? this.from : this.to;
        int n = oppositeEdge = reverse ? this.fromOutEdge : this.toInEdge;
        boolean bl = reverse ? this.fromOutEdge != -2 : (oppositeEdgeRestricted = this.toInEdge != -2);
        if (entry.adjNode == oppositeNode && (!oppositeEdgeRestricted || origEdgeId == oppositeEdge) && entry.getWeightOfVisitedPath() < this.bestWeight) {
            this.bestFwdEntry = reverse ? new CHEntry(oppositeNode, 0.0) : entry;
            this.bestBwdEntry = reverse ? entry : new CHEntry(oppositeNode, 0.0);
            this.bestWeight = entry.getWeightOfVisitedPath();
            return;
        }
        EdgeIterator iter = this.innerExplorer.setBaseNode(entry.adjNode);
        while (iter.next()) {
            double turnCostsAtBridgeNode;
            int edgeId = iter.getEdge();
            int key = GHUtility.createEdgeKey(iter.getAdjNode(), iter.getBaseNode(), edgeId, !reverse);
            SPTEntry entryOther = (SPTEntry)this.bestWeightMapOther.get(key);
            if (entryOther == null) continue;
            double d = turnCostsAtBridgeNode = reverse ? this.graph.getTurnWeight(edgeId, iter.getBaseNode(), origEdgeId) : this.graph.getTurnWeight(origEdgeId, iter.getBaseNode(), edgeId);
            double newWeight = entry.getWeightOfVisitedPath() + entryOther.getWeightOfVisitedPath() + turnCostsAtBridgeNode;
            if (!(newWeight < this.bestWeight)) continue;
            this.bestFwdEntry = reverse ? entryOther : entry;
            this.bestBwdEntry = reverse ? entry : entryOther;
            this.bestWeight = newWeight;
        }
    }

    @Override
    protected int getOrigEdgeId(RoutingCHEdgeIteratorState edge, boolean reverse) {
        return reverse ? edge.getOrigEdgeFirst() : edge.getOrigEdgeLast();
    }

    @Override
    protected int getIncomingEdge(SPTEntry entry) {
        return ((CHEntry)entry).incEdge;
    }

    @Override
    protected int getTraversalId(RoutingCHEdgeIteratorState edge, int origEdgeId, boolean reverse) {
        int baseNode = this.getOtherNode(origEdgeId, edge.getAdjNode());
        return GHUtility.createEdgeKey(baseNode, edge.getAdjNode(), origEdgeId, reverse);
    }

    @Override
    protected boolean accept(RoutingCHEdgeIteratorState edge, SPTEntry currEdge, boolean reverse) {
        return this.levelEdgeFilter == null || this.levelEdgeFilter.accept(edge);
    }
}

