/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntLongMap;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongIndexedContainer;
import com.carrotsearch.hppc.LongLongMap;
import com.carrotsearch.hppc.LongSet;
import com.graphhopper.coll.GHIntLongHashMap;
import com.graphhopper.coll.GHLongHashSet;
import com.graphhopper.coll.GHLongIntBTree;
import com.graphhopper.coll.GHLongLongHashMap;
import com.graphhopper.coll.LongIntMap;
import com.graphhopper.reader.OSMTurnRelation;
import com.graphhopper.reader.PillarInfo;
import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.dem.EdgeSampling;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GraphElevationSmoothing;
import com.graphhopper.reader.osm.OSMFileHeader;
import com.graphhopper.reader.osm.OSMInput;
import com.graphhopper.reader.osm.OSMInputFile;
import com.graphhopper.reader.osm.OSMReaderUtility;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TurnCostParser;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.GraphStorage;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMReader
implements TurnCostParser.ExternalInternalMap {
    protected static final int EMPTY_NODE = -1;
    protected static final int PILLAR_NODE = 1;
    protected static final int TOWER_NODE = -2;
    private static final Logger LOGGER = LoggerFactory.getLogger(OSMReader.class);
    private final GraphStorage ghStorage;
    private final Graph graph;
    private final NodeAccess nodeAccess;
    private final LongIndexedContainer barrierNodeIds = new LongArrayList();
    private final DistanceCalc distCalc = DistanceCalcEarth.DIST_EARTH;
    private final DouglasPeucker simplifyAlgo = new DouglasPeucker();
    private boolean smoothElevation = false;
    private double longEdgeSamplingDistance = 0.0;
    protected long zeroCounter = 0L;
    protected PillarInfo pillarInfo;
    private long locations;
    private final EncodingManager encodingManager;
    private int workerThreads = 2;
    private LongIntMap osmNodeIdToInternalNodeMap;
    private GHLongLongHashMap osmNodeIdToNodeFlagsMap;
    private GHLongLongHashMap osmWayIdToRouteWeightMap;
    private GHLongHashSet osmWayIdSet = new GHLongHashSet();
    private IntLongMap edgeIdToOsmWayIdMap;
    private boolean doSimplify = true;
    private int nextTowerId = 0;
    private int nextPillarId = 0;
    private long newUniqueOsmId = -9223372036854775807L;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private File osmFile;
    private Date osmDataDate;
    private final IntsRef tempRelFlags;
    private final TurnCostStorage tcs;

    public OSMReader(GraphHopperStorage ghStorage) {
        this.ghStorage = ghStorage;
        this.graph = ghStorage;
        this.nodeAccess = this.graph.getNodeAccess();
        this.encodingManager = ghStorage.getEncodingManager();
        this.osmNodeIdToInternalNodeMap = new GHLongIntBTree(200);
        this.osmNodeIdToNodeFlagsMap = new GHLongLongHashMap(200, 0.5);
        this.osmWayIdToRouteWeightMap = new GHLongLongHashMap(200, 0.5);
        this.pillarInfo = new PillarInfo(this.nodeAccess.is3D(), ghStorage.getDirectory());
        this.tempRelFlags = this.encodingManager.createRelationFlags();
        if (this.tempRelFlags.length != 2) {
            throw new IllegalArgumentException("Cannot use relation flags with != 2 integers");
        }
        this.tcs = this.graph.getTurnCostStorage();
    }

    public void readGraph() throws IOException {
        if (this.encodingManager == null) {
            throw new IllegalStateException("Encoding manager was not set.");
        }
        if (this.osmFile == null) {
            throw new IllegalStateException("No OSM file specified");
        }
        if (!this.osmFile.exists()) {
            throw new IllegalStateException("Your specified OSM file does not exist:" + this.osmFile.getAbsolutePath());
        }
        StopWatch sw1 = new StopWatch().start();
        this.preProcess(this.osmFile);
        sw1.stop();
        StopWatch sw2 = new StopWatch().start();
        this.writeOsmToGraph(this.osmFile);
        sw2.stop();
        LOGGER.info("time pass1:" + (int)sw1.getSeconds() + "s, pass2:" + (int)sw2.getSeconds() + "s, total:" + (int)(sw1.getSeconds() + sw2.getSeconds()) + "s");
    }

    void preProcess(File osmFile) {
        LOGGER.info("Starting to process OSM file: '" + osmFile + "'");
        try (OSMInput in = this.openOsmInputFile(osmFile);){
            ReaderElement item;
            long tmpWayCounter = 1L;
            long tmpRelationCounter = 1L;
            while ((item = in.getNext()) != null) {
                if (item.isType(1)) {
                    ReaderWay way = (ReaderWay)item;
                    boolean valid = this.filterWay(way);
                    if (!valid) continue;
                    LongArrayList wayNodes = way.getNodes();
                    int s2 = wayNodes.size();
                    for (int index = 0; index < s2; ++index) {
                        this.prepareHighwayNode(wayNodes.get(index));
                    }
                    if (++tmpWayCounter % 10000000L != 0L) continue;
                    LOGGER.info(Helper.nf(tmpWayCounter) + " (preprocess), osmIdMap:" + Helper.nf(this.getNodeMap().getSize()) + " (" + this.getNodeMap().getMemoryUsage() + "MB) " + Helper.getMemInfo());
                    continue;
                }
                if (item.isType(2)) {
                    ReaderRelation relation = (ReaderRelation)item;
                    if (!relation.isMetaRelation() && relation.hasTag("type", (Object)"route")) {
                        this.prepareWaysWithRelationInfo(relation);
                    }
                    if (relation.hasTag("type", (Object)"restriction")) {
                        this.prepareRestrictionRelation(relation);
                    }
                    if (++tmpRelationCounter % 100000L != 0L) continue;
                    LOGGER.info(Helper.nf(tmpRelationCounter) + " (preprocess), osmWayMap:" + Helper.nf(this.getRelFlagsMapSize()) + ", " + Helper.getMemInfo());
                    continue;
                }
                if (!item.isType(3)) continue;
                OSMFileHeader fileHeader = (OSMFileHeader)item;
                this.osmDataDate = Helper.createFormatter().parse(fileHeader.getTag("timestamp"));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem while parsing file", ex);
        }
    }

    private void prepareRestrictionRelation(ReaderRelation relation) {
        List<OSMTurnRelation> turnRelations = this.createTurnRelations(relation);
        for (OSMTurnRelation turnRelation : turnRelations) {
            this.getOsmWayIdSet().add(turnRelation.getOsmIdFrom());
            this.getOsmWayIdSet().add(turnRelation.getOsmIdTo());
        }
    }

    private LongSet getOsmWayIdSet() {
        return this.osmWayIdSet;
    }

    private IntLongMap getEdgeIdToOsmWayIdMap() {
        if (this.edgeIdToOsmWayIdMap == null) {
            this.edgeIdToOsmWayIdMap = new GHIntLongHashMap(this.getOsmWayIdSet().size(), 0.5);
        }
        return this.edgeIdToOsmWayIdMap;
    }

    boolean filterWay(ReaderWay item) {
        if (item.getNodes().size() < 2) {
            return false;
        }
        if (!item.hasTags()) {
            return false;
        }
        return this.encodingManager.acceptWay(item, new EncodingManager.AcceptWay());
    }

    private void writeOsmToGraph(File osmFile) {
        int tmp = (int)Math.max(this.getNodeMap().getSize() / 50L, 100L);
        LOGGER.info("creating graph. Found nodes (pillar+tower):" + Helper.nf(this.getNodeMap().getSize()) + ", " + Helper.getMemInfo());
        this.ghStorage.create(tmp);
        long wayStart = -1L;
        long relationStart = -1L;
        long counter = 1L;
        try (OSMInput in = this.openOsmInputFile(osmFile);){
            ReaderElement item;
            LongIntMap nodeFilter = this.getNodeMap();
            while ((item = in.getNext()) != null) {
                switch (item.getType()) {
                    case 0: {
                        if (nodeFilter.get(item.getId()) == -1) break;
                        this.processNode((ReaderNode)item);
                        break;
                    }
                    case 1: {
                        if (wayStart < 0L) {
                            LOGGER.info(Helper.nf(counter) + ", now parsing ways");
                            wayStart = counter;
                        }
                        this.processWay((ReaderWay)item);
                        break;
                    }
                    case 2: {
                        if (relationStart < 0L) {
                            LOGGER.info(Helper.nf(counter) + ", now parsing relations");
                            relationStart = counter;
                        }
                        this.processRelation((ReaderRelation)item);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown type " + item.getType());
                    }
                }
                if (++counter % 200000000L != 0L) continue;
                LOGGER.info(Helper.nf(counter) + ", locs:" + Helper.nf(this.locations) + ", " + Helper.getMemInfo());
            }
            if (in.getUnprocessedElements() > 0) {
                throw new IllegalStateException("Still unprocessed elements in reader queue " + in.getUnprocessedElements());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't process file " + osmFile + ", error: " + ex.getMessage(), ex);
        }
        this.finishedReading();
        if (this.graph.getNodes() == 0) {
            throw new RuntimeException("Graph after reading OSM must not be empty. Read " + counter + " items and " + this.locations + " locations");
        }
    }

    protected OSMInput openOsmInputFile(File osmFile) throws XMLStreamException, IOException {
        return new OSMInputFile(osmFile).setWorkerThreads(this.workerThreads).open();
    }

    protected void processWay(ReaderWay way) {
        IntsRef edgeFlags;
        if (way.getNodes().size() < 2) {
            return;
        }
        if (!way.hasTags()) {
            return;
        }
        long wayOsmId = way.getId();
        EncodingManager.AcceptWay acceptWay = new EncodingManager.AcceptWay();
        if (!this.encodingManager.acceptWay(way, acceptWay)) {
            return;
        }
        IntsRef relationFlags = this.getRelFlagsMap(way.getId());
        LongArrayList osmNodeIds = way.getNodes();
        int first = this.getNodeMap().get(osmNodeIds.get(0));
        int last = this.getNodeMap().get(osmNodeIds.get(osmNodeIds.size() - 1));
        double firstLat = this.getTmpLatitude(first);
        double firstLon = this.getTmpLongitude(first);
        double lastLat = this.getTmpLatitude(last);
        double lastLon = this.getTmpLongitude(last);
        if (!(Double.isNaN(firstLat) || Double.isNaN(firstLon) || Double.isNaN(lastLat) || Double.isNaN(lastLon))) {
            double estimatedDist = this.distCalc.calcDist(firstLat, firstLon, lastLat, lastLon);
            way.setTag("estimated_distance", estimatedDist);
            way.setTag("estimated_center", new GHPoint((firstLat + lastLat) / 2.0, (firstLon + lastLon) / 2.0));
        }
        if (way.getTag("duration") != null) {
            try {
                long dur = OSMReaderUtility.parseDuration(way.getTag("duration"));
                way.setTag("duration:seconds", Long.toString(dur));
            }
            catch (Exception ex) {
                LOGGER.warn("Parsing error in way with OSMID=" + way.getId() + " : " + ex.getMessage());
            }
        }
        if ((edgeFlags = this.encodingManager.handleWayTags(way, acceptWay, relationFlags)).isEmpty()) {
            return;
        }
        ArrayList<EdgeIteratorState> createdEdges = new ArrayList<EdgeIteratorState>();
        int size = osmNodeIds.size();
        int lastBarrier = -1;
        for (int i = 0; i < size; ++i) {
            long nodeId = osmNodeIds.get(i);
            long nodeFlags = this.getNodeFlagsMap().get(nodeId);
            if (nodeFlags <= 0L || !OSMReader.isOnePassable(this.encodingManager.getAccessEncFromNodeFlags(nodeFlags), edgeFlags)) continue;
            this.getNodeFlagsMap().put(nodeId, 0L);
            long newNodeId = this.addBarrierNode(nodeId);
            if (i > 0) {
                if (lastBarrier < 0) {
                    lastBarrier = 0;
                }
                int length = i - lastBarrier + 1;
                LongArrayList partNodeIds = new LongArrayList();
                partNodeIds.add(osmNodeIds.buffer, lastBarrier, length);
                partNodeIds.set(length - 1, newNodeId);
                createdEdges.addAll(this.addOSMWay(partNodeIds, edgeFlags, wayOsmId));
                createdEdges.addAll(this.addBarrierEdge(newNodeId, nodeId, edgeFlags, nodeFlags, wayOsmId));
            } else {
                createdEdges.addAll(this.addBarrierEdge(nodeId, newNodeId, edgeFlags, nodeFlags, wayOsmId));
                osmNodeIds.set(0, newNodeId);
            }
            lastBarrier = i;
        }
        if (lastBarrier >= 0) {
            if (lastBarrier < size - 1) {
                LongArrayList partNodeIds = new LongArrayList();
                partNodeIds.add(osmNodeIds.buffer, lastBarrier, size - lastBarrier);
                createdEdges.addAll(this.addOSMWay(partNodeIds, edgeFlags, wayOsmId));
            }
        } else {
            createdEdges.addAll(this.addOSMWay(way.getNodes(), edgeFlags, wayOsmId));
        }
        for (EdgeIteratorState edge : createdEdges) {
            this.encodingManager.applyWayTags(way, edge);
        }
    }

    protected void processRelation(ReaderRelation relation) {
        if (this.tcs != null && relation.hasTag("type", (Object)"restriction")) {
            this.storeTurnRelation(this.createTurnRelations(relation));
        }
    }

    void storeTurnRelation(List<OSMTurnRelation> turnRelations) {
        for (OSMTurnRelation turnRelation : turnRelations) {
            int viaNode = this.getInternalNodeIdOfOsmNode(turnRelation.getViaOsmNodeId());
            if (viaNode == -1) continue;
            this.encodingManager.handleTurnRelationTags(turnRelation, this, this.graph);
        }
    }

    @Override
    public long getOsmIdOfInternalEdge(int edgeId) {
        return this.getEdgeIdToOsmWayIdMap().get(edgeId);
    }

    @Override
    public int getInternalNodeIdOfOsmNode(long nodeOsmId) {
        int id = this.getNodeMap().get(nodeOsmId);
        if (id < -2) {
            return -id - 3;
        }
        return -1;
    }

    double getTmpLatitude(int id) {
        if (id == -1) {
            return Double.NaN;
        }
        if (id < -2) {
            id = -id - 3;
            return this.nodeAccess.getLat(id);
        }
        if (id > 2) {
            return this.pillarInfo.getLat(id -= 3);
        }
        return Double.NaN;
    }

    double getTmpLongitude(int id) {
        if (id == -1) {
            return Double.NaN;
        }
        if (id < -2) {
            id = -id - 3;
            return this.nodeAccess.getLon(id);
        }
        if (id > 2) {
            return this.pillarInfo.getLon(id -= 3);
        }
        return Double.NaN;
    }

    protected void processNode(ReaderNode node) {
        long nodeFlags;
        this.addNode(node);
        if (node.hasTags() && (nodeFlags = this.encodingManager.handleNodeTags(node)) != 0L) {
            this.getNodeFlagsMap().put(node.getId(), nodeFlags);
        }
        ++this.locations;
    }

    boolean addNode(ReaderNode node) {
        int nodeType = this.getNodeMap().get(node.getId());
        if (nodeType == -1) {
            return false;
        }
        double lat = node.getLat();
        double lon = node.getLon();
        double ele = this.eleProvider.getEle(lat, lon);
        if (nodeType == -2) {
            this.addTowerNode(node.getId(), lat, lon, ele);
        } else if (nodeType == 1) {
            this.pillarInfo.setNode(this.nextPillarId, lat, lon, ele);
            this.getNodeMap().put(node.getId(), this.nextPillarId + 3);
            ++this.nextPillarId;
        }
        return true;
    }

    private static boolean isOnePassable(List<BooleanEncodedValue> checkEncoders, IntsRef edgeFlags) {
        for (BooleanEncodedValue accessEnc : checkEncoders) {
            if (!accessEnc.getBool(false, edgeFlags) && !accessEnc.getBool(true, edgeFlags)) continue;
            return true;
        }
        return false;
    }

    void prepareWaysWithRelationInfo(ReaderRelation osmRelation) {
        for (ReaderRelation.Member member : osmRelation.getMembers()) {
            if (member.getType() != 1) continue;
            long osmId = member.getRef();
            IntsRef oldRelationFlags = this.getRelFlagsMap(osmId);
            IntsRef newRelationFlags = this.encodingManager.handleRelationTags(osmRelation, oldRelationFlags);
            this.putRelFlagsMap(osmId, newRelationFlags);
        }
    }

    void prepareHighwayNode(long osmId) {
        int tmpGHNodeId = this.getNodeMap().get(osmId);
        if (tmpGHNodeId == -1) {
            this.getNodeMap().put(osmId, 1);
        } else if (tmpGHNodeId > -1) {
            this.getNodeMap().put(osmId, -2);
        }
    }

    int addTowerNode(long osmId, double lat, double lon, double ele) {
        if (this.nodeAccess.is3D()) {
            this.nodeAccess.setNode(this.nextTowerId, lat, lon, ele);
        } else {
            this.nodeAccess.setNode(this.nextTowerId, lat, lon);
        }
        int id = -(this.nextTowerId + 3);
        this.getNodeMap().put(osmId, id);
        ++this.nextTowerId;
        return id;
    }

    Collection<EdgeIteratorState> addOSMWay(LongIndexedContainer osmNodeIds, IntsRef flags, long wayOsmId) {
        PointList pointList = new PointList(osmNodeIds.size(), this.nodeAccess.is3D());
        ArrayList<EdgeIteratorState> newEdges = new ArrayList<EdgeIteratorState>(5);
        int firstNode = -1;
        int lastInBoundsPillarNode = -1;
        try {
            long tmpNode;
            int i;
            int firstExisting = -1;
            int lastExisting = -1;
            for (i = 0; i < osmNodeIds.size(); ++i) {
                tmpNode = this.getNodeMap().get(osmNodeIds.get(i));
                if (tmpNode <= 2L && tmpNode >= -2L) continue;
                firstExisting = i;
                break;
            }
            for (i = osmNodeIds.size() - 1; i >= 0; --i) {
                tmpNode = this.getNodeMap().get(osmNodeIds.get(i));
                if (tmpNode <= 2L && tmpNode >= -2L) continue;
                lastExisting = i;
                break;
            }
            if (firstExisting < 0) {
                assert (lastExisting < 0);
                return newEdges;
            }
            for (i = firstExisting; i <= lastExisting; ++i) {
                long osmNodeId = osmNodeIds.get(i);
                int tmpNode2 = this.getNodeMap().get(osmNodeId);
                if (tmpNode2 == -1 || tmpNode2 == -2) continue;
                if (tmpNode2 == 1) {
                    if (pointList.isEmpty() || lastInBoundsPillarNode <= 2) continue;
                    tmpNode2 = lastInBoundsPillarNode;
                    tmpNode2 = this.handlePillarNode(tmpNode2, osmNodeId, null, true);
                    tmpNode2 = -tmpNode2 - 3;
                    if (pointList.size() > 1 && firstNode >= 0) {
                        newEdges.add(this.addEdge(firstNode, tmpNode2, pointList, flags, wayOsmId));
                        pointList.clear();
                        pointList.add(this.nodeAccess, tmpNode2);
                    }
                    firstNode = tmpNode2;
                    lastInBoundsPillarNode = -1;
                    continue;
                }
                if (tmpNode2 <= 2 && tmpNode2 >= -2) {
                    throw new AssertionError((Object)("Mapped index not in correct bounds " + tmpNode2 + ", " + osmNodeId));
                }
                if (tmpNode2 > 2) {
                    boolean convertToTowerNode;
                    boolean bl = convertToTowerNode = i == firstExisting || i == lastExisting;
                    if (!convertToTowerNode) {
                        lastInBoundsPillarNode = tmpNode2;
                    }
                    tmpNode2 = this.handlePillarNode(tmpNode2, osmNodeId, pointList, convertToTowerNode);
                }
                if (tmpNode2 >= -2) continue;
                tmpNode2 = -tmpNode2 - 3;
                if (firstNode >= 0 && firstNode == tmpNode2) {
                    long lastOsmNodeId = osmNodeIds.get(i - 1);
                    int lastGHNodeId = this.getNodeMap().get(lastOsmNodeId);
                    if (lastGHNodeId < -2) {
                        LOGGER.warn("Pillar node " + lastOsmNodeId + " is already a tower node and used in loop, see #1533. Fix mapping for way " + wayOsmId + ", nodes:" + osmNodeIds);
                        break;
                    }
                    int newEndNode = -this.handlePillarNode(lastGHNodeId, lastOsmNodeId, pointList, true) - 3;
                    newEdges.add(this.addEdge(firstNode, newEndNode, pointList, flags, wayOsmId));
                    pointList.clear();
                    pointList.add(this.nodeAccess, newEndNode);
                    firstNode = newEndNode;
                }
                pointList.add(this.nodeAccess, tmpNode2);
                if (firstNode >= 0) {
                    newEdges.add(this.addEdge(firstNode, tmpNode2, pointList, flags, wayOsmId));
                    pointList.clear();
                    pointList.add(this.nodeAccess, tmpNode2);
                }
                firstNode = tmpNode2;
            }
        }
        catch (RuntimeException ex) {
            LOGGER.error("Couldn't properly add edge with osm ids:" + osmNodeIds, ex);
            throw ex;
        }
        return newEdges;
    }

    EdgeIteratorState addEdge(int fromIndex, int toIndex, PointList pointList, IntsRef flags, long wayOsmId) {
        double towerNodeDistance;
        if (fromIndex < 0 || toIndex < 0) {
            throw new AssertionError((Object)("to or from index is invalid for this edge " + fromIndex + "->" + toIndex + ", points:" + pointList));
        }
        if (pointList.getDimension() != this.nodeAccess.getDimension()) {
            throw new AssertionError((Object)("Dimension does not match for pointList vs. nodeAccess " + pointList.getDimension() + " <-> " + this.nodeAccess.getDimension()));
        }
        if (this.smoothElevation) {
            pointList = GraphElevationSmoothing.smoothElevation(pointList);
        }
        if (this.longEdgeSamplingDistance < Double.MAX_VALUE && pointList.is3D()) {
            pointList = EdgeSampling.sample(pointList, this.longEdgeSamplingDistance, this.distCalc, this.eleProvider);
        }
        if (this.doSimplify && pointList.size() > 2) {
            this.simplifyAlgo.simplify(pointList);
        }
        if ((towerNodeDistance = this.distCalc.calcDistance(pointList)) < 0.001) {
            ++this.zeroCounter;
            towerNodeDistance = 0.001;
        }
        double maxDistance = 2147483.646;
        if (Double.isNaN(towerNodeDistance)) {
            LOGGER.warn("Bug in OSM or GraphHopper. Illegal tower node distance " + towerNodeDistance + " reset to 1m, osm way " + wayOsmId);
            towerNodeDistance = 1.0;
        }
        if (Double.isInfinite(towerNodeDistance) || towerNodeDistance > maxDistance) {
            LOGGER.warn("Bug in OSM or GraphHopper. Too big tower node distance " + towerNodeDistance + " reset to large value, osm way " + wayOsmId);
            towerNodeDistance = maxDistance;
        }
        EdgeIteratorState iter = this.graph.edge(fromIndex, toIndex).setDistance(towerNodeDistance).setFlags(flags);
        if (pointList.size() > 2) {
            this.checkCoordinates(fromIndex, pointList.get(0));
            this.checkCoordinates(toIndex, pointList.get(pointList.size() - 1));
            iter.setWayGeometry(pointList.shallowCopy(1, pointList.size() - 1, false));
        }
        this.checkDistance(iter);
        this.storeOsmWayID(iter.getEdge(), wayOsmId);
        return iter;
    }

    private void checkCoordinates(int nodeIndex, GHPoint point) {
        double tolerance = 1.0E-6;
        if (Math.abs(this.nodeAccess.getLat(nodeIndex) - point.getLat()) > 1.0E-6 || Math.abs(this.nodeAccess.getLon(nodeIndex) - point.getLon()) > 1.0E-6) {
            throw new IllegalStateException("Suspicious coordinates for node " + nodeIndex + ": (" + this.nodeAccess.getLat(nodeIndex) + "," + this.nodeAccess.getLon(nodeIndex) + ") vs. (" + point + ")");
        }
    }

    private void checkDistance(EdgeIteratorState edge) {
        double tolerance = 1.0;
        double edgeDistance = edge.getDistance();
        double geometryDistance = this.distCalc.calcDistance(edge.fetchWayGeometry(FetchMode.ALL));
        if (edgeDistance > 2000000.0) {
            LOGGER.warn("Very long edge detected: " + edge + " dist: " + edgeDistance);
        } else if (Math.abs(edgeDistance - geometryDistance) > 1.0) {
            throw new IllegalStateException("Suspicious distance for edge: " + edge + " " + edgeDistance + " vs. " + geometryDistance + ", difference: " + (edgeDistance - geometryDistance));
        }
    }

    protected void storeOsmWayID(int edgeId, long osmWayId) {
        if (this.getOsmWayIdSet().contains(osmWayId)) {
            this.getEdgeIdToOsmWayIdMap().put(edgeId, osmWayId);
        }
    }

    private int handlePillarNode(int tmpNode, long osmId, PointList pointList, boolean convertToTowerNode) {
        double lat = this.pillarInfo.getLat(tmpNode -= 3);
        double lon = this.pillarInfo.getLon(tmpNode);
        double ele = this.pillarInfo.getEle(tmpNode);
        if (lat == Double.MAX_VALUE || lon == Double.MAX_VALUE) {
            throw new RuntimeException("Conversion pillarNode to towerNode already happened!? osmId:" + osmId + " pillarIndex:" + tmpNode);
        }
        if (convertToTowerNode) {
            this.pillarInfo.setNode(tmpNode, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            tmpNode = this.addTowerNode(osmId, lat, lon, ele);
        } else if (pointList.is3D()) {
            pointList.add(lat, lon, ele);
        } else {
            pointList.add(lat, lon);
        }
        return tmpNode;
    }

    protected void finishedReading() {
        this.printInfo("way");
        this.pillarInfo.clear();
        this.encodingManager.releaseParsers();
        this.eleProvider.release();
        this.osmNodeIdToInternalNodeMap = null;
        this.osmNodeIdToNodeFlagsMap = null;
        this.osmWayIdToRouteWeightMap = null;
        this.osmWayIdSet = null;
        this.edgeIdToOsmWayIdMap = null;
    }

    long addBarrierNode(long nodeId) {
        ReaderNode newNode;
        int graphIndex = this.getNodeMap().get(nodeId);
        if (graphIndex < -2) {
            graphIndex = -graphIndex - 3;
            newNode = new ReaderNode(this.createNewNodeId(), this.nodeAccess.getLat(graphIndex), this.nodeAccess.getLon(graphIndex));
        } else {
            newNode = new ReaderNode(this.createNewNodeId(), this.pillarInfo.getLat(graphIndex -= 3), this.pillarInfo.getLon(graphIndex));
        }
        long id = newNode.getId();
        this.prepareHighwayNode(id);
        this.addNode(newNode);
        return id;
    }

    private long createNewNodeId() {
        return this.newUniqueOsmId++;
    }

    Collection<EdgeIteratorState> addBarrierEdge(long fromId, long toId, IntsRef inEdgeFlags, long nodeFlags, long wayOsmId) {
        IntsRef edgeFlags = IntsRef.deepCopyOf(inEdgeFlags);
        for (BooleanEncodedValue accessEnc : this.encodingManager.getAccessEncFromNodeFlags(nodeFlags)) {
            accessEnc.setBool(false, edgeFlags, false);
            accessEnc.setBool(true, edgeFlags, false);
        }
        this.barrierNodeIds.clear();
        this.barrierNodeIds.add(fromId);
        this.barrierNodeIds.add(toId);
        return this.addOSMWay(this.barrierNodeIds, edgeFlags, wayOsmId);
    }

    List<OSMTurnRelation> createTurnRelations(ReaderRelation relation) {
        String tagExcept;
        ArrayList<OSMTurnRelation> osmTurnRelations = new ArrayList<OSMTurnRelation>();
        String vehicleTypeRestricted = "";
        ArrayList<String> vehicleTypesExcept = new ArrayList<String>();
        if (relation.hasTag("except", new String[0]) && !Helper.isEmpty(tagExcept = relation.getTag("except"))) {
            ArrayList<String> vehicleTypes = new ArrayList<String>(Arrays.asList(tagExcept.split(";")));
            for (String vehicleType : vehicleTypes) {
                vehicleTypesExcept.add(vehicleType.trim());
            }
        }
        if (relation.hasTag("restriction", new String[0])) {
            OSMTurnRelation osmTurnRelation = this.createTurnRelation(relation, relation.getTag("restriction"), vehicleTypeRestricted, vehicleTypesExcept);
            if (osmTurnRelation != null) {
                osmTurnRelations.add(osmTurnRelation);
            }
            return osmTurnRelations;
        }
        if (relation.hasTagWithKeyPrefix("restriction:")) {
            List<String> vehicleTypesRestricted = relation.getKeysWithPrefix("restriction:");
            for (String vehicleType : vehicleTypesRestricted) {
                String restrictionType = relation.getTag(vehicleType);
                OSMTurnRelation osmTurnRelation = this.createTurnRelation(relation, restrictionType, vehicleTypeRestricted = vehicleType.replace("restriction:", "").trim(), vehicleTypesExcept);
                if (osmTurnRelation == null) continue;
                osmTurnRelations.add(osmTurnRelation);
            }
        }
        return osmTurnRelations;
    }

    OSMTurnRelation createTurnRelation(ReaderRelation relation, String restrictionType, String vehicleTypeRestricted, List<String> vehicleTypesExcept) {
        OSMTurnRelation.Type type = OSMTurnRelation.Type.getRestrictionType(restrictionType);
        if (type != OSMTurnRelation.Type.UNSUPPORTED) {
            long fromWayID = -1L;
            long viaNodeID = -1L;
            long toWayID = -1L;
            for (ReaderRelation.Member member : relation.getMembers()) {
                if (1 == member.getType()) {
                    if ("from".equals(member.getRole())) {
                        fromWayID = member.getRef();
                        continue;
                    }
                    if (!"to".equals(member.getRole())) continue;
                    toWayID = member.getRef();
                    continue;
                }
                if (0 != member.getType() || !"via".equals(member.getRole())) continue;
                viaNodeID = member.getRef();
            }
            if (fromWayID >= 0L && toWayID >= 0L && viaNodeID >= 0L) {
                OSMTurnRelation osmTurnRelation = new OSMTurnRelation(fromWayID, viaNodeID, toWayID, type);
                osmTurnRelation.setVehicleTypeRestricted(vehicleTypeRestricted);
                osmTurnRelation.setVehicleTypesExcept(vehicleTypesExcept);
                return osmTurnRelation;
            }
        }
        return null;
    }

    protected LongIntMap getNodeMap() {
        return this.osmNodeIdToInternalNodeMap;
    }

    protected LongLongMap getNodeFlagsMap() {
        return this.osmNodeIdToNodeFlagsMap;
    }

    int getRelFlagsMapSize() {
        return this.osmWayIdToRouteWeightMap.size();
    }

    IntsRef getRelFlagsMap(long osmId) {
        long relFlagsAsLong = this.osmWayIdToRouteWeightMap.get(osmId);
        this.tempRelFlags.ints[0] = (int)relFlagsAsLong;
        this.tempRelFlags.ints[1] = (int)(relFlagsAsLong >> 32);
        return this.tempRelFlags;
    }

    void putRelFlagsMap(long osmId, IntsRef relFlags) {
        long relFlagsAsLong = (long)relFlags.ints[1] << 32 | (long)relFlags.ints[0] & 0xFFFFFFFFL;
        this.osmWayIdToRouteWeightMap.put(osmId, relFlagsAsLong);
    }

    public OSMReader setWayPointMaxDistance(double maxDist) {
        this.doSimplify = maxDist > 0.0;
        this.simplifyAlgo.setMaxDistance(maxDist);
        return this;
    }

    public OSMReader setWayPointElevationMaxDistance(double elevationWayPointMaxDistance) {
        this.simplifyAlgo.setElevationMaxDistance(elevationWayPointMaxDistance);
        return this;
    }

    public OSMReader setSmoothElevation(boolean smoothElevation) {
        this.smoothElevation = smoothElevation;
        return this;
    }

    public OSMReader setLongEdgeSamplingDistance(double longEdgeSamplingDistance) {
        this.longEdgeSamplingDistance = longEdgeSamplingDistance;
        return this;
    }

    public OSMReader setWorkerThreads(int numOfWorkers) {
        this.workerThreads = numOfWorkers;
        return this;
    }

    public OSMReader setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null) {
            throw new IllegalStateException("Use the NOOP elevation provider instead of null or don't call setElevationProvider");
        }
        if (!this.nodeAccess.is3D() && ElevationProvider.NOOP != eleProvider) {
            throw new IllegalStateException("Make sure you graph accepts 3D data");
        }
        this.eleProvider = eleProvider;
        return this;
    }

    public OSMReader setFile(File osmFile) {
        this.osmFile = osmFile;
        return this;
    }

    private void printInfo(String str) {
        LOGGER.info("finished " + str + " processing. nodes: " + this.graph.getNodes() + ", osmIdMap.size:" + this.getNodeMap().getSize() + ", osmIdMap:" + this.getNodeMap().getMemoryUsage() + "MB, nodeFlagsMap.size:" + this.getNodeFlagsMap().size() + ", relFlagsMap.size:" + this.getRelFlagsMapSize() + ", zeroCounter:" + this.zeroCounter + " " + Helper.getMemInfo());
    }

    public Date getDataDate() {
        return this.osmDataDate;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

