/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.model.Calendar;
import com.conveyal.gtfs.model.CalendarDate;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.EnumSet;
import java.util.Map;

public class Service
implements Serializable {
    private static final long serialVersionUID = 7966238549509747091L;
    public String service_id;
    public Calendar calendar;
    public Map<LocalDate, CalendarDate> calendar_dates = Maps.newHashMap();

    public Service(String service_id) {
        this.service_id = service_id;
    }

    public Service removeDays(String service_id, EnumSet<DayOfWeek> daysToRemove) {
        Service service = new Service(service_id);
        if (this.calendar != null) {
            Calendar calendar = new Calendar();
            calendar.monday = daysToRemove.contains(DayOfWeek.MONDAY) ? 0 : this.calendar.monday;
            calendar.tuesday = daysToRemove.contains(DayOfWeek.TUESDAY) ? 0 : this.calendar.tuesday;
            calendar.wednesday = daysToRemove.contains(DayOfWeek.WEDNESDAY) ? 0 : this.calendar.wednesday;
            calendar.thursday = daysToRemove.contains(DayOfWeek.THURSDAY) ? 0 : this.calendar.thursday;
            calendar.friday = daysToRemove.contains(DayOfWeek.FRIDAY) ? 0 : this.calendar.friday;
            calendar.saturday = daysToRemove.contains(DayOfWeek.SATURDAY) ? 0 : this.calendar.saturday;
            calendar.sunday = daysToRemove.contains(DayOfWeek.SUNDAY) ? 0 : this.calendar.sunday;
            calendar.start_date = this.calendar.start_date;
            calendar.end_date = this.calendar.end_date;
            service.calendar = calendar;
        }
        this.calendar_dates.forEach((date, exception) -> {
            DayOfWeek dow = date.getDayOfWeek();
            if (!daysToRemove.contains(dow)) {
                CalendarDate newException = exception.clone();
                service.calendar_dates.put((LocalDate)date, newException);
            }
        });
        return service;
    }

    public boolean hasAnyService() {
        boolean hasAnyService = this.calendar != null && (this.calendar.monday == 1 || this.calendar.tuesday == 1 || this.calendar.wednesday == 1 || this.calendar.thursday == 1 || this.calendar.friday == 1 || this.calendar.saturday == 1 || this.calendar.sunday == 1);
        return hasAnyService |= this.calendar_dates.values().stream().anyMatch(cd2 -> cd2.exception_type == 1);
    }

    public boolean activeOn(LocalDate date) {
        boolean withinValidityRange;
        CalendarDate exception = this.calendar_dates.get(date);
        if (exception != null) {
            return exception.exception_type == 1;
        }
        if (this.calendar == null) {
            return false;
        }
        int gtfsDate = date.getYear() * 10000 + date.getMonthValue() * 100 + date.getDayOfMonth();
        boolean bl = withinValidityRange = this.calendar.end_date >= gtfsDate && this.calendar.start_date <= gtfsDate;
        if (!withinValidityRange) {
            return false;
        }
        switch (date.getDayOfWeek()) {
            case MONDAY: {
                return this.calendar.monday == 1;
            }
            case TUESDAY: {
                return this.calendar.tuesday == 1;
            }
            case WEDNESDAY: {
                return this.calendar.wednesday == 1;
            }
            case THURSDAY: {
                return this.calendar.thursday == 1;
            }
            case FRIDAY: {
                return this.calendar.friday == 1;
            }
            case SATURDAY: {
                return this.calendar.saturday == 1;
            }
            case SUNDAY: {
                return this.calendar.sunday == 1;
            }
        }
        throw new IllegalArgumentException("unknown day of week constant!");
    }

    public static boolean checkOverlap(Service s1, Service s2) {
        if (s1.calendar == null || s2.calendar == null) {
            return false;
        }
        boolean overlappingDays = s1.calendar.monday == 1 && s2.calendar.monday == 1 || s1.calendar.tuesday == 1 && s2.calendar.tuesday == 1 || s1.calendar.wednesday == 1 && s2.calendar.wednesday == 1 || s1.calendar.thursday == 1 && s2.calendar.thursday == 1 || s1.calendar.friday == 1 && s2.calendar.friday == 1 || s1.calendar.saturday == 1 && s2.calendar.saturday == 1 || s1.calendar.sunday == 1 && s2.calendar.sunday == 1;
        return overlappingDays;
    }
}

