/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.osmbinary.file;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.osmosis.osmbinary.file.CompressFlags;
import org.openstreetmap.osmosis.osmbinary.file.FileBlock;
import org.openstreetmap.osmosis.osmbinary.file.FileBlockPosition;

public class BlockOutputStream {
    OutputStream outwrite;
    List<FileBlockPosition> writtenblocks = new ArrayList<FileBlockPosition>();
    CompressFlags compression;

    public BlockOutputStream(OutputStream output) {
        this.outwrite = new DataOutputStream(output);
        this.compression = CompressFlags.DEFLATE;
    }

    public void setCompress(CompressFlags flag) {
        this.compression = flag;
    }

    public void setCompress(String s2) {
        if (s2.equals("none")) {
            this.compression = CompressFlags.NONE;
        } else if (s2.equals("deflate")) {
            this.compression = CompressFlags.DEFLATE;
        } else {
            throw new Error("Unknown compression type: " + s2);
        }
    }

    public void write(FileBlock block) throws IOException {
        this.write(block, this.compression);
    }

    public void write(FileBlock block, CompressFlags compression) throws IOException {
        FileBlockPosition ref = block.writeTo(this.outwrite, compression);
        this.writtenblocks.add(ref);
    }

    public void flush() throws IOException {
        this.outwrite.flush();
    }

    public void close() throws IOException {
        this.outwrite.flush();
        this.outwrite.close();
    }
}

