/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class ConfigurationParsingException
extends ConfigurationException {
    private static final long serialVersionUID = 1L;

    static Builder builder(String brief) {
        return new Builder(brief);
    }

    private ConfigurationParsingException(String path, String msg) {
        super(path, Collections.singleton(msg));
    }

    private ConfigurationParsingException(String path, String msg, Throwable cause) {
        super(path, Collections.singleton(msg), cause);
    }

    static class Builder {
        private static final int MAX_SUGGESTIONS = 5;
        private String summary;
        private String detail = "";
        private List<JsonMappingException.Reference> fieldPath = Collections.emptyList();
        private int line = -1;
        private int column = -1;
        @Nullable
        private Exception cause;
        private List<String> suggestions = new ArrayList<String>();
        @Nullable
        private String suggestionBase;
        private boolean suggestionsSorted = false;

        Builder(String summary) {
            this.summary = summary;
        }

        public String getSummary() {
            return this.summary.trim();
        }

        public String getDetail() {
            return this.detail.trim();
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public List<JsonMappingException.Reference> getFieldPath() {
            return this.fieldPath;
        }

        public boolean hasFieldPath() {
            return this.fieldPath != null && !this.fieldPath.isEmpty();
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean hasLocation() {
            return this.line > -1 && this.column > -1;
        }

        public List<String> getSuggestions() {
            if (this.suggestionsSorted || !this.hasSuggestionBase()) {
                return this.suggestions;
            }
            this.suggestions.sort(new LevenshteinComparator(Objects.requireNonNull(this.getSuggestionBase())));
            this.suggestionsSorted = true;
            return this.suggestions;
        }

        public boolean hasSuggestions() {
            return this.suggestions != null && !this.suggestions.isEmpty();
        }

        @Nullable
        public String getSuggestionBase() {
            return this.suggestionBase;
        }

        public boolean hasSuggestionBase() {
            return this.suggestionBase != null && !this.suggestionBase.isEmpty();
        }

        @Nullable
        public Exception getCause() {
            return this.cause;
        }

        public boolean hasCause() {
            return this.cause != null;
        }

        Builder setCause(Exception cause) {
            this.cause = cause;
            return this;
        }

        Builder setDetail(@Nullable String detail) {
            this.detail = Strings.nullToEmpty(detail);
            return this;
        }

        Builder setFieldPath(List<JsonMappingException.Reference> fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        Builder setLocation(JsonLocation location) {
            return location == null ? this : this.setLocation(location.getLineNr(), location.getColumnNr());
        }

        Builder setLocation(int line, int column) {
            this.line = line;
            this.column = column;
            return this;
        }

        Builder addSuggestion(String suggestion) {
            this.suggestionsSorted = false;
            this.suggestions.add(suggestion);
            return this;
        }

        Builder addSuggestions(Collection<String> suggestions) {
            this.suggestionsSorted = false;
            this.suggestions.addAll(suggestions);
            return this;
        }

        Builder setSuggestionBase(String base) {
            this.suggestionBase = base;
            this.suggestionsSorted = false;
            return this;
        }

        ConfigurationParsingException build(String path) {
            StringBuilder sb = new StringBuilder(this.getSummary());
            if (this.hasFieldPath()) {
                sb.append(" at: ").append(this.buildPath(this.getFieldPath()));
            } else if (this.hasLocation()) {
                sb.append(" at line: ").append(this.getLine() + 1).append(", column: ").append(this.getColumn() + 1);
            }
            if (this.hasDetail()) {
                sb.append("; ").append(this.getDetail());
            }
            if (this.hasSuggestions()) {
                int i;
                List<String> suggestions = this.getSuggestions();
                sb.append(ConfigurationException.NEWLINE).append("    Did you mean?:").append(ConfigurationException.NEWLINE);
                Iterator<String> it = suggestions.iterator();
                for (i = 0; it.hasNext() && i < 5; ++i) {
                    sb.append("      - ").append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(ConfigurationException.NEWLINE);
                }
                int total = suggestions.size();
                if (i < total) {
                    sb.append("        [").append(total - i).append(" more]");
                }
            }
            return this.hasCause() ? new ConfigurationParsingException(path, sb.toString(), Objects.requireNonNull(this.getCause())) : new ConfigurationParsingException(path, sb.toString());
        }

        private String buildPath(Iterable<JsonMappingException.Reference> path) {
            StringBuilder sb = new StringBuilder();
            if (path != null) {
                Iterator<JsonMappingException.Reference> it = path.iterator();
                while (it.hasNext()) {
                    JsonMappingException.Reference reference = it.next();
                    String name = reference.getFieldName();
                    if (name == null) {
                        sb.append('[').append(reference.getIndex()).append(']');
                    } else {
                        sb.append(name);
                    }
                    if (!it.hasNext()) continue;
                    sb.append('.');
                }
            }
            return sb.toString();
        }

        protected static class LevenshteinComparator
        implements Comparator<String>,
        Serializable {
            private static final long serialVersionUID = 1L;
            private static final LevenshteinDistance LEVENSHTEIN_DISTANCE = new LevenshteinDistance();
            private String base;

            public LevenshteinComparator(String base) {
                this.base = base;
            }

            @Override
            public int compare(String a, String b) {
                if (a.equals(b)) {
                    return 0;
                }
                if (a.equals(this.base)) {
                    return -1;
                }
                if (b.equals(this.base)) {
                    return 1;
                }
                return Integer.compare(LEVENSHTEIN_DISTANCE.apply(a, this.base), LEVENSHTEIN_DISTANCE.apply(b, this.base));
            }

            private void writeObject(ObjectOutputStream stream) throws IOException {
                stream.defaultWriteObject();
            }

            private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
                stream.defaultReadObject();
            }
        }
    }
}

