/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.ResponsePath;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.ViaInstruction;
import com.graphhopper.util.details.PathDetail;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PathSimplification {
    private final PointList pointList;
    private final List<Partition> partitions;
    private final DouglasPeucker douglasPeucker;
    private final int numPartitions;
    private final int[] currIntervalIndex;
    private final int[] currIntervalStart;
    private final int[] currIntervalEnd;
    private final boolean[] partitionFinished;
    private final int[] removedPointsInCurrInterval;
    private final int[] removedPointsInPrevIntervals;

    public static PointList simplify(ResponsePath responsePath, DouglasPeucker douglasPeucker, boolean enableInstructions) {
        final PointList pointList = responsePath.getPoints();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (enableInstructions) {
            final InstructionList instructions = responsePath.getInstructions();
            partitions.add(new Partition(){

                @Override
                public int size() {
                    return instructions.size();
                }

                @Override
                public int getIntervalLength(int index) {
                    return instructions.get(index).getLength();
                }

                @Override
                public void setInterval(int index, int start, int end) {
                    Instruction instruction = instructions.get(index);
                    if (instruction instanceof ViaInstruction || instruction instanceof FinishInstruction) {
                        if (start != end) {
                            throw new IllegalStateException("via- and finish-instructions are expected to have zero length");
                        }
                        ++end;
                    }
                    instruction.setPoints(pointList.shallowCopy(start, end, false));
                }
            });
        }
        for (Map.Entry<String, List<PathDetail>> entry : responsePath.getPathDetails().entrySet()) {
            final List<PathDetail> detail = entry.getValue();
            if (detail.isEmpty() && pointList.size() > 1) {
                throw new IllegalStateException("PathDetails " + entry.getKey() + " must not be empty");
            }
            partitions.add(new Partition(){

                @Override
                public int size() {
                    return detail.size();
                }

                @Override
                public int getIntervalLength(int index) {
                    return ((PathDetail)detail.get(index)).getLength();
                }

                @Override
                public void setInterval(int index, int start, int end) {
                    PathDetail pd = (PathDetail)detail.get(index);
                    pd.setFirst(start);
                    pd.setLast(end);
                }
            });
        }
        PathSimplification.simplify(responsePath.getPoints(), partitions, douglasPeucker);
        PathSimplification.assertConsistencyOfPathDetails(responsePath.getPathDetails());
        if (enableInstructions) {
            PathSimplification.assertConsistencyOfInstructions(responsePath.getInstructions(), responsePath.getPoints().size());
        }
        return pointList;
    }

    public static void simplify(PointList pointList, List<Partition> partitions, DouglasPeucker douglasPeucker) {
        new PathSimplification(pointList, partitions, douglasPeucker).simplify();
    }

    private PathSimplification(PointList pointList, List<Partition> partitions, DouglasPeucker douglasPeucker) {
        this.pointList = pointList;
        this.partitions = partitions;
        this.douglasPeucker = douglasPeucker;
        this.numPartitions = this.partitions.size();
        this.currIntervalIndex = new int[this.numPartitions];
        this.currIntervalStart = new int[this.numPartitions];
        this.currIntervalEnd = new int[this.numPartitions];
        this.partitionFinished = new boolean[this.numPartitions];
        this.removedPointsInCurrInterval = new int[this.numPartitions];
        this.removedPointsInPrevIntervals = new int[this.numPartitions];
    }

    private void simplify() {
        if (this.pointList.size() <= 2) {
            this.pointList.makeImmutable();
            return;
        }
        if (this.partitions.isEmpty()) {
            this.douglasPeucker.simplify(this.pointList, 0, this.pointList.size() - 1);
            this.pointList.makeImmutable();
            return;
        }
        int intervalStart = 0;
        for (int i = 0; i < this.numPartitions; ++i) {
            this.currIntervalEnd[i] = this.partitions.get(i).getIntervalLength(this.currIntervalIndex[i]);
        }
        for (int p = 0; p < this.pointList.size(); ++p) {
            int s2;
            int removed = 0;
            for (s2 = 0; s2 < this.numPartitions; ++s2) {
                if (this.partitionFinished[s2] || p != this.currIntervalEnd[s2]) continue;
                boolean compress = false;
                removed = this.douglasPeucker.simplify(this.pointList, intervalStart, this.currIntervalEnd[s2], false);
                intervalStart = p;
                break;
            }
            for (s2 = 0; s2 < this.numPartitions; ++s2) {
                boolean nextIntervalHasOnlyOnePoint;
                if (this.partitionFinished[s2]) continue;
                int n = s2;
                this.removedPointsInCurrInterval[n] = this.removedPointsInCurrInterval[n] + removed;
                while (p == this.currIntervalEnd[s2] && (nextIntervalHasOnlyOnePoint = this.updateInterval(p, s2))) {
                }
            }
        }
        DouglasPeucker.removeNaN(this.pointList);
        this.pointList.makeImmutable();
        this.assertConsistencyOfIntervals();
    }

    private boolean updateInterval(int p, int s2) {
        boolean nextIntervalHasOnlyOnePoint = false;
        int updatedStart = this.currIntervalStart[s2] - this.removedPointsInPrevIntervals[s2];
        int updatedEnd = this.currIntervalEnd[s2] - this.removedPointsInPrevIntervals[s2] - this.removedPointsInCurrInterval[s2];
        this.partitions.get(s2).setInterval(this.currIntervalIndex[s2], updatedStart, updatedEnd);
        int n = s2;
        this.removedPointsInPrevIntervals[n] = this.removedPointsInPrevIntervals[n] + this.removedPointsInCurrInterval[s2];
        this.removedPointsInCurrInterval[s2] = 0;
        int n2 = s2;
        this.currIntervalIndex[n2] = this.currIntervalIndex[n2] + 1;
        this.currIntervalStart[s2] = p;
        if (this.currIntervalIndex[s2] >= this.partitions.get(s2).size()) {
            this.partitionFinished[s2] = true;
        } else {
            int length = this.partitions.get(s2).getIntervalLength(this.currIntervalIndex[s2]);
            int n3 = s2;
            this.currIntervalEnd[n3] = this.currIntervalEnd[n3] + length;
            if (length == 0) {
                nextIntervalHasOnlyOnePoint = true;
            }
        }
        return nextIntervalHasOnlyOnePoint;
    }

    private void assertConsistencyOfIntervals() {
        int expected = this.pointList.size() - 1;
        for (int i = 0; i < this.partitions.size(); ++i) {
            Partition partition = this.partitions.get(i);
            int count = 0;
            for (int j = 0; j < partition.size(); ++j) {
                count += partition.getIntervalLength(j);
            }
            if (count == expected) continue;
            throw new IllegalStateException("Simplified intervals are inconsistent: " + count + " vs. " + expected + " for intervals with index: " + i);
        }
    }

    private static void assertConsistencyOfPathDetails(Map<String, List<PathDetail>> pathDetails) {
        for (Map.Entry<String, List<PathDetail>> pdEntry : pathDetails.entrySet()) {
            List<PathDetail> list = pdEntry.getValue();
            if (list.isEmpty()) continue;
            PathDetail prevPD = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                if (prevPD.getLast() != list.get(i).getFirst()) {
                    throw new IllegalStateException("PathDetail list " + pdEntry.getKey() + " is inconsistent due to entries " + prevPD + " vs. " + list.get(i));
                }
                prevPD = list.get(i);
            }
        }
    }

    private static void assertConsistencyOfInstructions(InstructionList instructions, int numPoints) {
        int expected = numPoints - 1;
        int count = 0;
        for (Instruction instruction : instructions) {
            count += instruction.getLength();
        }
        if (count != expected) {
            throw new IllegalArgumentException("inconsistent instructions, total interval length: " + count + " vs. point list length " + expected);
        }
    }

    static interface Partition {
        public int size();

        public int getIntervalLength(int var1);

        public void setInterval(int var1, int var2, int var3);
    }
}

