/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.util.Helper;

public enum RoadEnvironment {
    OTHER("other"),
    ROAD("road"),
    FERRY("ferry"),
    TUNNEL("tunnel"),
    BRIDGE("bridge"),
    FORD("ford"),
    SHUTTLE_TRAIN("shuttle_train");

    public static final String KEY = "road_environment";
    private final String name;

    private RoadEnvironment(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static RoadEnvironment find(String name) {
        if (name == null) {
            return OTHER;
        }
        try {
            return RoadEnvironment.valueOf(Helper.toUpperCase(name));
        }
        catch (IllegalArgumentException ex) {
            return OTHER;
        }
    }
}

