/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.DijkstraBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AlternativeRouteEdgeCH
extends DijkstraBidirectionEdgeCHNoSOD {
    private final double maxWeightFactor;
    private final double maxShareFactor;
    private final double localOptimalityFactor;
    private final int maxPaths;
    private final List<AlternativeInfo> alternatives = new ArrayList<AlternativeInfo>();
    private int extraVisitedNodes = 0;

    public AlternativeRouteEdgeCH(RoutingCHGraph graph, PMap hints) {
        super(graph);
        this.maxWeightFactor = hints.getDouble("alternative_route.max_weight_factor", 1.25);
        this.maxShareFactor = hints.getDouble("alternative_route.max_share_factor", 0.8);
        this.localOptimalityFactor = hints.getDouble("alternative_route.local_optimality_factor", 0.25);
        this.maxPaths = hints.getInt("alternative_route.max_paths", 3);
    }

    @Override
    public boolean finished() {
        if (this.finishedFrom && this.finishedTo) {
            return true;
        }
        return this.currFrom.weight >= this.bestWeight * this.maxWeightFactor && this.currTo.weight >= this.bestWeight * this.maxWeightFactor;
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedCountFrom + this.visitedCountTo + this.extraVisitedNodes;
    }

    List<AlternativeInfo> calcAlternatives(int s2, int t) {
        this.checkAlreadyRun();
        this.init(s2, 0.0, t, 0.0);
        this.runAlgo();
        Path bestPath = this.extractPath();
        if (!bestPath.isFound()) {
            return Collections.emptyList();
        }
        this.alternatives.add(new AlternativeInfo(bestPath, 0.0));
        ArrayList<PotentialAlternativeInfo> potentialAlternativeInfos = new ArrayList<PotentialAlternativeInfo>();
        HashMap bestWeightMapByNode = new HashMap();
        this.bestWeightMapTo.forEach((key, value) -> {
            bestWeightMapByNode.put(value.adjNode, value);
            return true;
        });
        this.bestWeightMapFrom.forEach((wurst, fromSPTEntry) -> {
            SPTEntry toSPTEntry = (SPTEntry)bestWeightMapByNode.get(fromSPTEntry.adjNode);
            if (toSPTEntry == null) {
                return true;
            }
            if (fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath() > bestPath.getWeight() * this.maxWeightFactor) {
                return true;
            }
            Path preliminaryRoute = this.createPathExtractor().extract((SPTEntry)fromSPTEntry, toSPTEntry, fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath());
            double preliminaryShare = this.calculateShare(preliminaryRoute);
            if (preliminaryShare > this.maxShareFactor) {
                return true;
            }
            assert (fromSPTEntry.adjNode == toSPTEntry.adjNode);
            PotentialAlternativeInfo potentialAlternativeInfo = new PotentialAlternativeInfo();
            potentialAlternativeInfo.v = fromSPTEntry.adjNode;
            potentialAlternativeInfo.edgeIn = this.getIncomingEdge((SPTEntry)fromSPTEntry);
            potentialAlternativeInfo.weight = 2.0 * (fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath()) + preliminaryShare;
            potentialAlternativeInfos.add(potentialAlternativeInfo);
            return true;
        });
        potentialAlternativeInfos.sort(Comparator.comparingDouble(o -> o.weight));
        for (PotentialAlternativeInfo potentialAlternativeInfo : potentialAlternativeInfos) {
            IntIndexedContainer svNodes;
            int vIndex;
            double share;
            double directLength;
            int v = potentialAlternativeInfo.v;
            int tailSv = potentialAlternativeInfo.edgeIn;
            DijkstraBidirectionEdgeCHNoSOD svRouter = new DijkstraBidirectionEdgeCHNoSOD(this.graph);
            Path suvPath = svRouter.calcPath(s2, v, -2, tailSv);
            this.extraVisitedNodes += svRouter.getVisitedNodes();
            int u = this.graph.getBaseGraph().getEdgeIteratorState(tailSv, v).getBaseNode();
            DijkstraBidirectionEdgeCHNoSOD vtRouter = new DijkstraBidirectionEdgeCHNoSOD(this.graph);
            Path uvtPath = vtRouter.calcPath(u, t, tailSv, -2);
            Path path = AlternativeRouteEdgeCH.concat(this.graph.getBaseGraph(), suvPath, uvtPath);
            this.extraVisitedNodes += vtRouter.getVisitedNodes();
            double sharedDistanceWithShortest = this.sharedDistanceWithShortest(path);
            double detourLength = path.getDistance() - sharedDistanceWithShortest;
            if (detourLength > (directLength = bestPath.getDistance() - sharedDistanceWithShortest) * this.maxWeightFactor || (share = this.calculateShare(path)) > this.maxShareFactor || !this.tTest(path, vIndex = (svNodes = suvPath.calcNodes()).size() - 1)) continue;
            this.alternatives.add(new AlternativeInfo(path, share));
            if (this.alternatives.size() < this.maxPaths) continue;
            break;
        }
        return this.alternatives;
    }

    private double calculateShare(Path path) {
        double sharedDistance = this.sharedDistance(path);
        return sharedDistance / path.getDistance();
    }

    private double sharedDistance(Path path) {
        double sharedDistance = 0.0;
        List<EdgeIteratorState> edges = path.calcEdges();
        for (EdgeIteratorState edge : edges) {
            if (!this.nodesInCurrentAlternativeSetContains(edge.getBaseNode()) || !this.nodesInCurrentAlternativeSetContains(edge.getAdjNode())) continue;
            sharedDistance += edge.getDistance();
        }
        return sharedDistance;
    }

    private double sharedDistanceWithShortest(Path path) {
        double sharedDistance = 0.0;
        List<EdgeIteratorState> edges = path.calcEdges();
        for (EdgeIteratorState edge : edges) {
            if (!this.alternatives.get((int)0).nodes.contains(edge.getBaseNode()) || !this.alternatives.get((int)0).nodes.contains(edge.getAdjNode())) continue;
            sharedDistance += edge.getDistance();
        }
        return sharedDistance;
    }

    private boolean nodesInCurrentAlternativeSetContains(int v) {
        for (AlternativeInfo alternative : this.alternatives) {
            if (!alternative.nodes.contains(v)) continue;
            return true;
        }
        return false;
    }

    private boolean tTest(Path path, int vIndex) {
        if (path.getEdgeCount() == 0) {
            return true;
        }
        double detourDistance = this.detourDistance(path);
        double T = 0.5 * this.localOptimalityFactor * detourDistance;
        EdgeIteratorState fromNode = this.getPreviousNodeTMetersAway(path, vIndex, T);
        EdgeIteratorState toNode = this.getNextNodeTMetersAway(path, vIndex, T);
        DijkstraBidirectionEdgeCHNoSOD tRouter = new DijkstraBidirectionEdgeCHNoSOD(this.graph);
        Path tPath = tRouter.calcPath(fromNode.getBaseNode(), toNode.getAdjNode(), fromNode.getEdge(), toNode.getEdge());
        this.extraVisitedNodes += tRouter.getVisitedNodes();
        IntIndexedContainer tNodes = tPath.calcNodes();
        int v = path.calcNodes().get(vIndex);
        return tNodes.contains(v);
    }

    private double detourDistance(Path path) {
        return path.getDistance() - this.sharedDistanceWithShortest(path);
    }

    private EdgeIteratorState getPreviousNodeTMetersAway(Path path, int vIndex, double T) {
        int i;
        List<EdgeIteratorState> edges = path.calcEdges();
        double distance = 0.0;
        for (i = vIndex; i > 0 && distance < T; distance += edges.get(i - 1).getDistance(), --i) {
        }
        return edges.get(i);
    }

    private EdgeIteratorState getNextNodeTMetersAway(Path path, int vIndex, double T) {
        int i;
        List<EdgeIteratorState> edges = path.calcEdges();
        double distance = 0.0;
        for (i = vIndex; i < edges.size() - 1 && distance < T; distance += edges.get(i).getDistance(), ++i) {
        }
        return edges.get(i - 1);
    }

    private static Path concat(Graph graph, Path suvPath, Path uvtPath) {
        assert (suvPath.isFound());
        assert (uvtPath.isFound());
        Path path = new Path(graph);
        path.setFromNode(suvPath.calcNodes().get(0));
        path.getEdges().addAll(suvPath.getEdges());
        Iterator<IntCursor> uvtPathI = uvtPath.getEdges().iterator();
        if (!uvtPathI.hasNext()) {
            return suvPath;
        }
        uvtPathI.next();
        uvtPathI.forEachRemaining(edge -> path.addEdge(edge.value));
        path.setEndNode(uvtPath.getEndNode());
        path.setWeight(suvPath.getWeight() + uvtPath.getWeight());
        path.setDistance(suvPath.getDistance() + uvtPath.getDistance());
        path.addTime(suvPath.getTime() + uvtPath.getTime());
        path.setFound(true);
        return path;
    }

    @Override
    public List<Path> calcPaths(int from, int to) {
        List<AlternativeInfo> alts = this.calcAlternatives(from, to);
        if (alts.isEmpty()) {
            return Collections.singletonList(this.createEmptyPath());
        }
        ArrayList<Path> paths = new ArrayList<Path>(alts.size());
        for (AlternativeInfo a : alts) {
            paths.add(a.path);
        }
        return paths;
    }

    public static class AlternativeInfo {
        final double shareWeight;
        final Path path;
        final IntIndexedContainer nodes;

        AlternativeInfo(Path path, double shareWeight) {
            this.path = path;
            this.shareWeight = shareWeight;
            this.nodes = path.calcNodes();
        }

        public String toString() {
            return "AlternativeInfo{shareWeight=" + this.shareWeight + ", path=" + this.path.calcNodes() + '}';
        }

        public Path getPath() {
            return this.path;
        }
    }

    public static class PotentialAlternativeInfo {
        public int v;
        public int edgeIn;
        double weight;
    }
}

