/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSMTurnRelation {
    private final long fromOsmWayId;
    private final long viaOsmNodeId;
    private final long toOsmWayId;
    private final Type restriction;
    private String vehicleTypeRestricted;
    private List<String> vehicleTypesExcept;

    public OSMTurnRelation(long fromWayID, long viaNodeID, long toWayID, Type restrictionType) {
        this.fromOsmWayId = fromWayID;
        this.viaOsmNodeId = viaNodeID;
        this.toOsmWayId = toWayID;
        this.restriction = restrictionType;
        this.vehicleTypeRestricted = "";
        this.vehicleTypesExcept = new ArrayList<String>();
    }

    public long getOsmIdFrom() {
        return this.fromOsmWayId;
    }

    public long getOsmIdTo() {
        return this.toOsmWayId;
    }

    public long getViaOsmNodeId() {
        return this.viaOsmNodeId;
    }

    public Type getRestriction() {
        return this.restriction;
    }

    public String getVehicleTypeRestricted() {
        return this.vehicleTypeRestricted;
    }

    public void setVehicleTypeRestricted(String vehicleTypeRestricted) {
        this.vehicleTypeRestricted = vehicleTypeRestricted;
    }

    public List<String> getVehicleTypesExcept() {
        return this.vehicleTypesExcept;
    }

    public void setVehicleTypesExcept(List<String> vehicleTypesExcept) {
        this.vehicleTypesExcept = vehicleTypesExcept;
    }

    public boolean isVehicleTypeConcernedByTurnRestriction(Collection<String> vehicleTypes) {
        if (!Collections.disjoint(vehicleTypes, this.vehicleTypesExcept)) {
            return false;
        }
        return this.vehicleTypeRestricted.isEmpty() || vehicleTypes.contains(this.vehicleTypeRestricted);
    }

    public String toString() {
        return "*-(" + this.fromOsmWayId + ")->" + this.viaOsmNodeId + "-(" + this.toOsmWayId + ")->*";
    }

    public static enum Type {
        UNSUPPORTED,
        NOT,
        ONLY;

        private static final Map<String, Type> tags;

        public static Type getRestrictionType(String tag) {
            Type result = null;
            if (tag != null) {
                result = tags.get(tag);
            }
            return result != null ? result : UNSUPPORTED;
        }

        static {
            tags = new HashMap<String, Type>();
            tags.put("no_left_turn", NOT);
            tags.put("no_right_turn", NOT);
            tags.put("no_straight_on", NOT);
            tags.put("no_u_turn", NOT);
            tags.put("no_entry", NOT);
            tags.put("only_right_turn", ONLY);
            tags.put("only_left_turn", ONLY);
            tags.put("only_straight_on", ONLY);
        }
    }
}

