/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.util.EdgeIteratorState;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MultiCriteriaLabelSetting {
    private final Comparator<Label> queueComparator;
    private final List<Label> targetLabels;
    private long startTime;
    private final EnumEncodedValue<GtfsStorage.EdgeType> typeEnc;
    private final IntObjectMap<List<Label>> fromMap;
    private final PriorityQueue<Label> fromHeap;
    private final int maxVisitedNodes;
    private final boolean reverse;
    private final boolean mindTransfers;
    private final boolean profileQuery;
    private int visitedNodes;
    private final GraphExplorer explorer;
    private double betaTransfers;
    private double betaWalkTime = 1.0;
    private long limitStreetTime = Long.MAX_VALUE;

    public MultiCriteriaLabelSetting(GraphExplorer explorer, PtEncodedValues flagEncoder, boolean reverse, boolean mindTransfers, boolean profileQuery, int maxVisitedNodes, List<Label> solutions) {
        this.maxVisitedNodes = maxVisitedNodes;
        this.explorer = explorer;
        this.reverse = reverse;
        this.mindTransfers = mindTransfers;
        this.profileQuery = profileQuery;
        this.targetLabels = solutions;
        this.typeEnc = flagEncoder.getTypeEnc();
        this.queueComparator = Comparator.comparingLong(this::weight).thenComparingLong(l -> l.nTransfers).thenComparingLong(l -> l.walkTime).thenComparingLong(l -> this.departureTimeCriterion((Label)l) != null ? this.departureTimeCriterion((Label)l) : 0L).thenComparingLong(l -> l.impossible ? 1L : 0L);
        this.fromHeap = new PriorityQueue<Label>(this.queueComparator);
        this.fromMap = new IntObjectHashMap<List<Label>>();
    }

    public Stream<Label> calcLabels(int from, Instant startTime) {
        this.startTime = startTime.toEpochMilli();
        return StreamSupport.stream(new MultiCriteriaLabelSettingSpliterator(from), false).limit(this.maxVisitedNodes).peek(label -> ++this.visitedNodes);
    }

    void setBetaTransfers(double betaTransfers) {
        this.betaTransfers = betaTransfers;
    }

    void setBetaWalkTime(double betaWalkTime) {
        this.betaWalkTime = betaWalkTime;
    }

    boolean isNotDominatedByAnyOf(Label me, Collection<Label> sptEntries) {
        for (Label they : sptEntries) {
            if (!this.dominates(they, me)) continue;
            return false;
        }
        return true;
    }

    void removeDominated(Label me, Collection<Label> sptEntries) {
        Iterator<Label> iterator = sptEntries.iterator();
        while (iterator.hasNext()) {
            Label sptEntry = iterator.next();
            if (!this.dominates(me, sptEntry)) continue;
            sptEntry.deleted = true;
            iterator.remove();
        }
    }

    private boolean dominates(Label me, Label they) {
        if (this.weight(me) > this.weight(they)) {
            return false;
        }
        if (this.profileQuery && (me.departureTime != null && they.departureTime != null ? this.departureTimeCriterion(me) > this.departureTimeCriterion(they) : this.travelTimeCriterion(me) > this.travelTimeCriterion(they))) {
            return false;
        }
        if (this.mindTransfers && me.nTransfers > they.nTransfers) {
            return false;
        }
        if (me.impossible && !they.impossible) {
            return false;
        }
        if (this.weight(me) < this.weight(they)) {
            return true;
        }
        if (this.profileQuery && (me.departureTime != null && they.departureTime != null ? this.departureTimeCriterion(me) < this.departureTimeCriterion(they) : this.travelTimeCriterion(me) < this.travelTimeCriterion(they))) {
            return true;
        }
        if (this.mindTransfers && me.nTransfers < they.nTransfers) {
            return true;
        }
        return this.queueComparator.compare(me, they) <= 0;
    }

    private Long departureTimeCriterion(Label label) {
        return label.departureTime == null ? null : Long.valueOf(this.reverse ? label.departureTime : -label.departureTime.longValue());
    }

    long weight(Label label) {
        return this.timeSinceStartTime(label) + (long)((double)label.nTransfers * this.betaTransfers) + (long)((double)label.walkTime * (this.betaWalkTime - 1.0));
    }

    long timeSinceStartTime(Label label) {
        return (long)(this.reverse ? -1 : 1) * (label.currentTime - this.startTime);
    }

    private long travelTimeCriterion(Label label) {
        if (label.departureTime == null) {
            return label.walkTime;
        }
        return (long)(this.reverse ? -1 : 1) * (label.currentTime - label.departureTime);
    }

    public void setLimitStreetTime(long limitStreetTime) {
        this.limitStreetTime = limitStreetTime;
    }

    int getVisitedNodes() {
        return this.visitedNodes;
    }

    private class MultiCriteriaLabelSettingSpliterator
    extends Spliterators.AbstractSpliterator<Label> {
        MultiCriteriaLabelSettingSpliterator(int from) {
            super(0L, 0);
            Label label = new Label(MultiCriteriaLabelSetting.this.startTime, -1, from, 0, null, 0L, 0L, false, null);
            ArrayList<Label> labels = new ArrayList<Label>(1);
            labels.add(label);
            MultiCriteriaLabelSetting.this.fromMap.put(from, labels);
            MultiCriteriaLabelSetting.this.fromHeap.add(label);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Label> action) {
            while (!MultiCriteriaLabelSetting.this.fromHeap.isEmpty() && ((Label)((MultiCriteriaLabelSetting)MultiCriteriaLabelSetting.this).fromHeap.peek()).deleted) {
                MultiCriteriaLabelSetting.this.fromHeap.poll();
            }
            if (MultiCriteriaLabelSetting.this.fromHeap.isEmpty()) {
                return false;
            }
            Label label = (Label)MultiCriteriaLabelSetting.this.fromHeap.poll();
            action.accept(label);
            MultiCriteriaLabelSetting.this.explorer.exploreEdgesAround(label).forEach(edge -> {
                boolean impossible;
                long walkTime;
                long nextTime = MultiCriteriaLabelSetting.this.reverse ? label.currentTime - MultiCriteriaLabelSetting.this.explorer.calcTravelTimeMillis((EdgeIteratorState)edge, label.currentTime) : label.currentTime + MultiCriteriaLabelSetting.this.explorer.calcTravelTimeMillis((EdgeIteratorState)edge, label.currentTime);
                int nTransfers = label.nTransfers + MultiCriteriaLabelSetting.this.explorer.calcNTransfers((EdgeIteratorState)edge);
                Long firstPtDepartureTime = label.departureTime;
                GtfsStorage.EdgeType edgeType = (GtfsStorage.EdgeType)((Object)((Object)edge.get(MultiCriteriaLabelSetting.this.typeEnc)));
                if (!(MultiCriteriaLabelSetting.this.reverse || edgeType != GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK && edgeType != GtfsStorage.EdgeType.WAIT)) {
                    if (label.nTransfers == 0) {
                        firstPtDepartureTime = nextTime - label.walkTime;
                    }
                } else if (MultiCriteriaLabelSetting.this.reverse && (edgeType == GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK || edgeType == GtfsStorage.EdgeType.WAIT_ARRIVAL) && label.nTransfers == 0) {
                    firstPtDepartureTime = nextTime + label.walkTime;
                }
                if ((walkTime = label.walkTime + (edgeType == GtfsStorage.EdgeType.HIGHWAY || edgeType == GtfsStorage.EdgeType.ENTER_PT || edgeType == GtfsStorage.EdgeType.EXIT_PT ? (long)(MultiCriteriaLabelSetting.this.reverse ? -1 : 1) * (nextTime - label.currentTime) : 0L)) > MultiCriteriaLabelSetting.this.limitStreetTime) {
                    return;
                }
                ArrayList<Label> sptEntries = (ArrayList<Label>)MultiCriteriaLabelSetting.this.fromMap.get(edge.getAdjNode());
                if (sptEntries == null) {
                    sptEntries = new ArrayList<Label>(1);
                    MultiCriteriaLabelSetting.this.fromMap.put(edge.getAdjNode(), sptEntries);
                }
                boolean bl = impossible = label.impossible || MultiCriteriaLabelSetting.this.explorer.isBlocked((EdgeIteratorState)edge) || !MultiCriteriaLabelSetting.this.reverse && edgeType == GtfsStorage.EdgeType.BOARD && label.residualDelay > 0L || MultiCriteriaLabelSetting.this.reverse && edgeType == GtfsStorage.EdgeType.ALIGHT && label.residualDelay < MultiCriteriaLabelSetting.this.explorer.getDelayFromAlightEdge((EdgeIteratorState)edge, label.currentTime);
                long residualDelay = !MultiCriteriaLabelSetting.this.reverse ? (edgeType == GtfsStorage.EdgeType.WAIT || edgeType == GtfsStorage.EdgeType.TRANSFER ? Math.max(0L, label.residualDelay - MultiCriteriaLabelSetting.this.explorer.calcTravelTimeMillis((EdgeIteratorState)edge, label.currentTime)) : (edgeType == GtfsStorage.EdgeType.ALIGHT ? label.residualDelay + MultiCriteriaLabelSetting.this.explorer.getDelayFromAlightEdge((EdgeIteratorState)edge, label.currentTime) : (edgeType == GtfsStorage.EdgeType.BOARD ? -MultiCriteriaLabelSetting.this.explorer.getDelayFromBoardEdge((EdgeIteratorState)edge, label.currentTime) : label.residualDelay))) : (edgeType == GtfsStorage.EdgeType.WAIT || edgeType == GtfsStorage.EdgeType.TRANSFER ? label.residualDelay + MultiCriteriaLabelSetting.this.explorer.calcTravelTimeMillis((EdgeIteratorState)edge, label.currentTime) : 0L);
                if (!MultiCriteriaLabelSetting.this.reverse && edgeType == GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK && residualDelay > 0L) {
                    Label newImpossibleLabelForDelayedTrip = new Label(nextTime, edge.getEdge(), edge.getAdjNode(), nTransfers, firstPtDepartureTime, walkTime, residualDelay, true, label);
                    this.insertIfNotDominated(sptEntries, newImpossibleLabelForDelayedTrip);
                    nextTime += residualDelay;
                    residualDelay = 0L;
                    Label newLabel = new Label(nextTime, edge.getEdge(), edge.getAdjNode(), nTransfers, firstPtDepartureTime, walkTime, residualDelay, impossible, label);
                    this.insertIfNotDominated(sptEntries, newLabel);
                } else {
                    Label newLabel = new Label(nextTime, edge.getEdge(), edge.getAdjNode(), nTransfers, firstPtDepartureTime, walkTime, residualDelay, impossible, label);
                    this.insertIfNotDominated(sptEntries, newLabel);
                }
            });
            return true;
        }

        private void insertIfNotDominated(Collection<Label> sptEntries, Label label) {
            if (MultiCriteriaLabelSetting.this.isNotDominatedByAnyOf(label, sptEntries) && MultiCriteriaLabelSetting.this.isNotDominatedByAnyOf(label, MultiCriteriaLabelSetting.this.targetLabels)) {
                MultiCriteriaLabelSetting.this.removeDominated(label, sptEntries);
                sptEntries.add(label);
                MultiCriteriaLabelSetting.this.fromHeap.add(label);
            }
        }
    }

    public static interface SPTVisitor {
        public void visit(Label var1);
    }
}

