/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.bundles.assets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonDeserialize(builder=Builder.class)
public class AssetsConfiguration {
    public static final String SLASH = "/";
    private Map<String, String> mappings = Maps.newHashMap();
    private String cacheSpec = null;
    @NotNull
    private Map<String, String> overrides = Maps.newHashMap();
    @NotNull
    private Map<String, String> mimeTypes = Maps.newHashMap();
    private String cacheControlHeader = null;
    private Map<String, String> resourcePathToUriMappings;

    private AssetsConfiguration(String cacheControlHeader, String cacheSpec, Map<String, String> mappings, Map<String, String> mimeTypes, Map<String, String> overrides) {
        this.cacheControlHeader = cacheControlHeader;
        this.cacheSpec = cacheSpec;
        this.mappings = Collections.unmodifiableMap(mappings);
        this.mimeTypes = Collections.unmodifiableMap(mimeTypes);
        this.overrides = Collections.unmodifiableMap(overrides);
    }

    public Map<String, String> getResourcePathToUriMappings() {
        if (this.resourcePathToUriMappings == null) {
            ImmutableMap.Builder<String, String> mapBuilder = ImmutableMap.builder();
            for (Map.Entry<String, String> mapping : this.mappings().entrySet()) {
                mapBuilder.put(this.ensureEndsWithSlash(mapping.getKey()), this.ensureEndsWithSlash(mapping.getValue()));
            }
            this.resourcePathToUriMappings = mapBuilder.build();
        }
        return this.resourcePathToUriMappings;
    }

    private String ensureEndsWithSlash(String value) {
        return value != null ? (value.endsWith(SLASH) ? value : value + SLASH) : SLASH;
    }

    protected Map<String, String> mappings() {
        return this.mappings;
    }

    public String getCacheSpec() {
        return this.cacheSpec;
    }

    public Map<String, String> getOverrides() {
        return Collections.unmodifiableMap(this.overrides);
    }

    public Map<String, String> getMimeTypes() {
        return Collections.unmodifiableMap(this.mimeTypes);
    }

    public String getCacheControlHeader() {
        return this.cacheControlHeader;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @JsonProperty
        private String cacheControlHeader;
        @JsonProperty
        private String cacheSpec;
        @JsonProperty
        private Map<String, String> mappings = Maps.newHashMap();
        @JsonProperty
        private Map<String, String> mimeTypes = Maps.newHashMap();
        @JsonProperty
        private Map<String, String> overrides = Maps.newHashMap();

        private Builder() {
        }

        public Builder cacheControlHeader(String cacheControlHeader) {
            this.cacheControlHeader = cacheControlHeader;
            return this;
        }

        public Builder cacheSpec(String cacheSpec) {
            this.cacheSpec = cacheSpec;
            return this;
        }

        public Builder mappings(Map<String, String> mappings) {
            this.mappings = Preconditions.checkNotNull(mappings);
            return this;
        }

        public Builder mimeTypes(Map<String, String> mimeTypes) {
            this.mimeTypes = Preconditions.checkNotNull(mimeTypes);
            return this;
        }

        public Builder overrides(Map<String, String> overrides) {
            this.overrides = Preconditions.checkNotNull(overrides);
            return this;
        }

        public AssetsConfiguration build() {
            return new AssetsConfiguration(this.cacheControlHeader, this.cacheSpec, this.mappings, this.mimeTypes, this.overrides);
        }
    }
}

