/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.TransportationMode;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Polygon;

public abstract class AbstractSpatialRule
implements SpatialRule {
    public static final int DEFAULT_PRIORITY = 100;
    private final List<Polygon> borders;

    public AbstractSpatialRule(List<Polygon> borders) {
        this.borders = borders;
    }

    public AbstractSpatialRule(Polygon border) {
        this(Collections.singletonList(border));
    }

    @Override
    public double getMaxSpeed(RoadClass roadClass, TransportationMode transport, double currentMaxSpeed) {
        return currentMaxSpeed;
    }

    @Override
    public RoadAccess getAccess(RoadClass roadClass, TransportationMode transport, RoadAccess currentRoadAccess) {
        return currentRoadAccess;
    }

    @Override
    public List<Polygon> getBorders() {
        return this.borders;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SpatialRule)) {
            return false;
        }
        return this.getId().equals(((SpatialRule)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SpatialRule [getId()=");
        builder.append(this.getId());
        builder.append(", getPriority()=");
        builder.append(this.getPriority());
        builder.append("]");
        return builder.toString();
    }
}

