/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.OSMTurnRelation;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TurnCostParser;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OSMTurnRelationParser
implements TurnCostParser {
    private String name;
    private DecimalEncodedValue turnCostEnc;
    private final Collection<String> restrictions;
    private BooleanEncodedValue accessEnc;
    private EdgeExplorer cachedOutExplorer;
    private EdgeExplorer cachedInExplorer;

    public OSMTurnRelationParser(String name, int maxTurnCosts) {
        this(name, maxTurnCosts, Collections.emptyList());
    }

    public OSMTurnRelationParser(String name, int maxTurnCosts, Collection<String> restrictions) {
        this.name = name;
        this.turnCostEnc = TurnCost.create(name, maxTurnCosts);
        this.restrictions = restrictions.isEmpty() ? (name.contains("car") ? Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access") : (name.contains("motorbike") || name.contains("motorcycle") ? Arrays.asList("motorcycle", "motor_vehicle", "vehicle", "access") : (name.contains("truck") ? Arrays.asList("hgv", "motor_vehicle", "vehicle", "access") : (name.contains("bike") || name.contains("bicycle") ? Arrays.asList("bicycle", "vehicle", "access") : Arrays.asList("motor_vehicle", "vehicle", "access"))))) : restrictions;
    }

    DecimalEncodedValue getTurnCostEnc() {
        return this.turnCostEnc;
    }

    @Override
    public void createTurnCostEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        String accessKey = EncodingManager.getKey(this.name, "access");
        this.accessEnc = lookup.getEncodedValue(accessKey, BooleanEncodedValue.class);
        registerNewEncodedValue.add(this.turnCostEnc);
    }

    @Override
    public void handleTurnRelationTags(OSMTurnRelation turnRelation, TurnCostParser.ExternalInternalMap map, Graph graph) {
        if (!turnRelation.isVehicleTypeConcernedByTurnRestriction(this.restrictions)) {
            return;
        }
        this.addRelationToTCStorage(turnRelation, map, graph);
    }

    private EdgeExplorer getInExplorer(Graph graph) {
        return this.cachedInExplorer == null ? (this.cachedInExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.inEdges(this.accessEnc))) : this.cachedInExplorer;
    }

    private EdgeExplorer getOutExplorer(Graph graph) {
        return this.cachedOutExplorer == null ? (this.cachedOutExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.outEdges(this.accessEnc))) : this.cachedOutExplorer;
    }

    void addRelationToTCStorage(OSMTurnRelation osmTurnRelation, TurnCostParser.ExternalInternalMap map, Graph graph) {
        TurnCostStorage tcs = graph.getTurnCostStorage();
        int viaNode = map.getInternalNodeIdOfOsmNode(osmTurnRelation.getViaOsmNodeId());
        EdgeExplorer edgeOutExplorer = this.getOutExplorer(graph);
        EdgeExplorer edgeInExplorer = this.getInExplorer(graph);
        try {
            int edgeIdFrom = -1;
            EdgeIterator iter = edgeInExplorer.setBaseNode(viaNode);
            while (iter.next()) {
                if (map.getOsmIdOfInternalEdge(iter.getEdge()) != osmTurnRelation.getOsmIdFrom()) continue;
                edgeIdFrom = iter.getEdge();
                break;
            }
            if (!EdgeIterator.Edge.isValid(edgeIdFrom)) {
                return;
            }
            iter = edgeOutExplorer.setBaseNode(viaNode);
            while (iter.next()) {
                int edgeId = iter.getEdge();
                long wayId = map.getOsmIdOfInternalEdge(edgeId);
                if ((edgeId == edgeIdFrom || osmTurnRelation.getRestriction() != OSMTurnRelation.Type.ONLY || wayId == osmTurnRelation.getOsmIdTo()) && (osmTurnRelation.getRestriction() != OSMTurnRelation.Type.NOT || wayId != osmTurnRelation.getOsmIdTo() || wayId < 0L)) continue;
                tcs.set(this.turnCostEnc, edgeIdFrom, viaNode, iter.getEdge(), Double.POSITIVE_INFINITY);
                if (osmTurnRelation.getRestriction() != OSMTurnRelation.Type.NOT) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not built turn table entry for relation of node with osmId:" + osmTurnRelation.getViaOsmNodeId(), e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

