/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Transfer;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.gtfs.EmptyLocationIndex;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsReader;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.GtfsStorageI;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.reader.DataReader;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperGtfs
extends GraphHopperOSM {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphHopperGtfs.class);
    private final GraphHopperConfig ghConfig;
    private GtfsStorage gtfsStorage;

    public GraphHopperGtfs(GraphHopperConfig ghConfig) {
        this.ghConfig = ghConfig;
    }

    @Override
    protected void registerCustomEncodedValues(EncodingManager.Builder emBuilder) {
        PtEncodedValues.createAndAddEncodedValues(emBuilder);
    }

    @Override
    protected DataReader importData() throws IOException {
        if (this.ghConfig.has("datareader.file")) {
            return super.importData();
        }
        this.getGraphHopperStorage().create(1000L);
        return new DataReader(){

            @Override
            public DataReader setFile(File file) {
                return this;
            }

            @Override
            public DataReader setElevationProvider(ElevationProvider ep) {
                return this;
            }

            @Override
            public DataReader setWorkerThreads(int workerThreads) {
                return this;
            }

            @Override
            public DataReader setWayPointMaxDistance(double wayPointMaxDistance) {
                return this;
            }

            @Override
            public DataReader setWayPointElevationMaxDistance(double elevationWayPointMaxDistance) {
                return this;
            }

            @Override
            public DataReader setSmoothElevation(boolean smoothElevation) {
                return this;
            }

            @Override
            public DataReader setLongEdgeSamplingDistance(double longEdgeSamplingDistance) {
                return this;
            }

            @Override
            public void readGraph() {
            }

            @Override
            public Date getDataDate() {
                return null;
            }
        };
    }

    @Override
    protected LocationIndex createLocationIndex(Directory dir) {
        LocationIndexTree tmpIndex = new LocationIndexTree(this.getGraphHopperStorage(), dir);
        if (tmpIndex.loadExisting()) {
            return tmpIndex;
        }
        if (this.getGraphHopperStorage().getNodes() > 0) {
            LocationIndexTree locationIndexTree = new LocationIndexTree(this.getGraphHopperStorage(), new RAMDirectory());
            if (!locationIndexTree.loadExisting()) {
                locationIndexTree.prepareIndex();
            }
            return locationIndexTree;
        }
        return new EmptyLocationIndex();
    }

    @Override
    protected void importPublicTransit() {
        this.gtfsStorage = new GtfsStorage(this.getGraphHopperStorage().getDirectory());
        if (!this.getGtfsStorage().loadExisting()) {
            this.ensureWriteAccess();
            this.getGtfsStorage().create();
            GraphHopperStorage graphHopperStorage = this.getGraphHopperStorage();
            LocationIndex streetNetworkIndex = this.getLocationIndex();
            try {
                int idx = 0;
                List<String> gtfsFiles = this.ghConfig.has("gtfs.file") ? Arrays.asList(this.ghConfig.getString("gtfs.file", "").split(",")) : Collections.emptyList();
                for (String gtfsFile : gtfsFiles) {
                    try {
                        this.getGtfsStorage().loadGtfsFromZipFile("gtfs_" + idx++, new ZipFile(gtfsFile));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                boolean createTransferStopsConnectSameOsmNode = this.ghConfig.has("gtfs.create_transfers_stops_same_osm_node") && this.ghConfig.getBool("gtfs.create_transfers_stops_same_osm_node", false);
                HashMap<String, GtfsReader> readers = new HashMap<String, GtfsReader>();
                this.getGtfsStorage().getGtfsFeeds().forEach((id, gtfsFeed) -> {
                    Transfers transfers = new Transfers((GTFSFeed)gtfsFeed);
                    GtfsReader gtfsReader = new GtfsReader((String)id, graphHopperStorage, graphHopperStorage.getEncodingManager(), this.getGtfsStorage(), streetNetworkIndex, transfers);
                    gtfsReader.setCreateTransferStopsConnectSameOsmNode(createTransferStopsConnectSameOsmNode);
                    gtfsReader.connectStopsToStreetNetwork();
                    this.getType0TransferWithTimes((String)id, (GTFSFeed)gtfsFeed).forEach(t -> {
                        t.transfer.transfer_type = 2;
                        t.transfer.min_transfer_time = (int)(t.time / 1000L);
                        gtfsFeed.transfers.put(t.id, t.transfer);
                    });
                    LOGGER.info("Building transit graph for feed {}", (Object)gtfsFeed.feedId);
                    gtfsReader.buildPtNetwork();
                    readers.put((String)id, gtfsReader);
                });
                this.insertTransfersBetweenFeeds(readers);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while constructing transit network. Is your GTFS file valid? Please check log for possible causes.", e);
            }
            streetNetworkIndex.close();
            LocationIndexTree locationIndex = new LocationIndexTree(this.getGraphHopperStorage(), this.getGraphHopperStorage().getDirectory());
            locationIndex.prepareIndex();
            this.setLocationIndex(locationIndex);
        }
    }

    private void insertTransfersBetweenFeeds(HashMap<String, GtfsReader> readers) {
        LOGGER.info("Looking for inter-feed transfers");
        GraphHopperStorage graphHopperStorage = this.getGraphHopperStorage();
        QueryGraph queryGraph = QueryGraph.create((Graph)graphHopperStorage, Collections.emptyList());
        FastestWeighting accessEgressWeighting = new FastestWeighting(graphHopperStorage.getEncodingManager().getEncoder("foot"));
        PtEncodedValues ptEncodedValues = PtEncodedValues.fromEncodingManager(graphHopperStorage.getEncodingManager());
        GraphExplorer graphExplorer = new GraphExplorer(queryGraph, accessEgressWeighting, ptEncodedValues, this.getGtfsStorage(), RealtimeFeed.empty(this.getGtfsStorage()), true, true, 5.0, false);
        this.getGtfsStorage().getStationNodes().values().stream().distinct().forEach(stationNode -> {
            MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, ptEncodedValues, true, false, false, false, Integer.MAX_VALUE, new ArrayList<Label>());
            router.setLimitStreetTime(Duration.ofMinutes(2L).toMillis());
            Iterator iterator = router.calcLabels((int)stationNode, Instant.ofEpochMilli(0L), 0).iterator();
            while (iterator.hasNext()) {
                EdgeIteratorState edgeIteratorState;
                Label label = (Label)iterator.next();
                if (label.parent == null || (edgeIteratorState = graphHopperStorage.getEdgeIteratorState(label.edge, label.adjNode)).get(ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.EXIT_PT) continue;
                GtfsStorageI.PlatformDescriptor fromPlatformDescriptor = this.getGtfsStorage().getPlatformDescriptorByEdge().get(label.edge);
                DefaultEdgeFilter filter = DefaultEdgeFilter.outEdges(ptEncodedValues.getAccessEnc());
                EdgeExplorer edgeExplorer = graphHopperStorage.createEdgeExplorer(filter);
                EdgeIterator edgeIterator = edgeExplorer.setBaseNode((int)stationNode);
                while (edgeIterator.next()) {
                    if (edgeIterator.get(ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.ENTER_PT) continue;
                    GtfsStorageI.PlatformDescriptor toPlatformDescriptor = this.getGtfsStorage().getPlatformDescriptorByEdge().get(edgeIterator.getEdge());
                    if (toPlatformDescriptor.feed_id.equals(fromPlatformDescriptor.feed_id)) continue;
                    GtfsReader toFeedReader = (GtfsReader)readers.get(toPlatformDescriptor.feed_id);
                    toFeedReader.insertTransferEdges(label.adjNode, (int)Duration.ofMinutes(2L).getSeconds(), toPlatformDescriptor);
                }
            }
        });
    }

    private Stream<TransferWithTime> getType0TransferWithTimes(String id, GTFSFeed gtfsFeed) {
        GraphHopperStorage graphHopperStorage = this.getGraphHopperStorage();
        RealtimeFeed realtimeFeed = RealtimeFeed.empty(this.getGtfsStorage());
        PtEncodedValues ptEncodedValues = PtEncodedValues.fromEncodingManager(graphHopperStorage.getEncodingManager());
        FastestWeighting accessEgressWeighting = new FastestWeighting(graphHopperStorage.getEncodingManager().getEncoder("foot"));
        return gtfsFeed.transfers.entrySet().parallelStream().filter(e -> ((Transfer)e.getValue()).transfer_type == 0).map(e -> {
            PointList points = new PointList(2, false);
            int fromnode = this.getGtfsStorage().getStationNodes().get(new GtfsStorage.FeedIdWithStopId(id, ((Transfer)e.getValue()).from_stop_id));
            Snap fromstation = new Snap(graphHopperStorage.getNodeAccess().getLat(fromnode), graphHopperStorage.getNodeAccess().getLon(fromnode));
            fromstation.setClosestNode(fromnode);
            points.add(graphHopperStorage.getNodeAccess().getLat(fromnode), graphHopperStorage.getNodeAccess().getLon(fromnode));
            int tonode = this.getGtfsStorage().getStationNodes().get(new GtfsStorage.FeedIdWithStopId(id, ((Transfer)e.getValue()).to_stop_id));
            Snap tostation = new Snap(graphHopperStorage.getNodeAccess().getLat(tonode), graphHopperStorage.getNodeAccess().getLon(tonode));
            tostation.setClosestNode(tonode);
            points.add(graphHopperStorage.getNodeAccess().getLat(tonode), graphHopperStorage.getNodeAccess().getLon(tonode));
            QueryGraph queryGraph = QueryGraph.create((Graph)graphHopperStorage, Collections.emptyList());
            GraphExplorer graphExplorer = new GraphExplorer(queryGraph, accessEgressWeighting, ptEncodedValues, this.getGtfsStorage(), realtimeFeed, false, true, 5.0, false);
            MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, ptEncodedValues, false, false, false, false, Integer.MAX_VALUE, new ArrayList<Label>());
            Iterator iterator = router.calcLabels(fromnode, Instant.ofEpochMilli(0L), 0).iterator();
            Label solution = null;
            while (iterator.hasNext()) {
                Label label = (Label)iterator.next();
                if (tonode != label.adjNode) continue;
                solution = label;
                break;
            }
            if (solution == null) {
                throw new RuntimeException("Can't find a transfer walk route.");
            }
            TransferWithTime transferWithTime = new TransferWithTime();
            transferWithTime.id = (String)e.getKey();
            transferWithTime.transfer = (Transfer)e.getValue();
            transferWithTime.time = solution.currentTime;
            return transferWithTime;
        });
    }

    @Override
    public void close() {
        this.getGtfsStorage().close();
        super.close();
    }

    public GtfsStorage getGtfsStorage() {
        return this.gtfsStorage;
    }

    static class TransferWithTime {
        public String id;
        Transfer transfer;
        long time;

        TransferWithTime() {
        }
    }
}

