/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class GraphExplorer {
    private final EdgeExplorer edgeExplorer;
    private final PtEncodedValues flagEncoder;
    private final GtfsStorage gtfsStorage;
    private final RealtimeFeed realtimeFeed;
    private final boolean reverse;
    private final Weighting accessEgressWeighting;
    private final boolean walkOnly;
    private double walkSpeedKmH;
    private boolean ignoreValidities;

    public GraphExplorer(Graph graph, Weighting accessEgressWeighting, PtEncodedValues flagEncoder, GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed, boolean reverse, boolean walkOnly, double walkSpeedKmh, boolean ignoreValidities) {
        this.accessEgressWeighting = accessEgressWeighting;
        this.ignoreValidities = ignoreValidities;
        DefaultEdgeFilter accessEgressIn = DefaultEdgeFilter.inEdges(accessEgressWeighting.getFlagEncoder());
        DefaultEdgeFilter accessEgressOut = DefaultEdgeFilter.outEdges(accessEgressWeighting.getFlagEncoder());
        DefaultEdgeFilter ptIn = DefaultEdgeFilter.inEdges(flagEncoder.getAccessEnc());
        DefaultEdgeFilter ptOut = DefaultEdgeFilter.outEdges(flagEncoder.getAccessEnc());
        EdgeFilter in = edgeState -> accessEgressIn.accept(edgeState) || ptIn.accept(edgeState);
        EdgeFilter out = edgeState -> accessEgressOut.accept(edgeState) || ptOut.accept(edgeState);
        this.edgeExplorer = graph.createEdgeExplorer(reverse ? in : out);
        this.flagEncoder = flagEncoder;
        this.gtfsStorage = gtfsStorage;
        this.realtimeFeed = realtimeFeed;
        this.reverse = reverse;
        this.walkOnly = walkOnly;
        this.walkSpeedKmH = walkSpeedKmh;
    }

    Stream<EdgeIteratorState> exploreEdgesAround(Label label) {
        return this.allEdgesAround(label).filter(new EdgeIteratorStatePredicate(label));
    }

    private Stream<EdgeIteratorState> allEdgesAround(final Label label) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<EdgeIteratorState>(0L, 0){
            EdgeIterator edgeIterator;
            {
                super(x0, x1);
                this.edgeIterator = GraphExplorer.this.edgeExplorer.setBaseNode(label.adjNode);
            }

            @Override
            public boolean tryAdvance(Consumer<? super EdgeIteratorState> action) {
                if (this.edgeIterator.next()) {
                    GtfsStorage.EdgeType edgeType = this.edgeIterator.get(GraphExplorer.this.flagEncoder.getTypeEnc());
                    if (edgeType == GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK) {
                        if (GraphExplorer.this.walkOnly) {
                            return false;
                        }
                        action.accept(this.findEnterEdge());
                        return true;
                    }
                    action.accept(this.edgeIterator);
                    return true;
                }
                return false;
            }

            private EdgeIteratorState findEnterEdge() {
                ArrayList<EdgeIteratorState> allEnterEdges = new ArrayList<EdgeIteratorState>();
                allEnterEdges.add(this.edgeIterator.detach(false));
                while (this.edgeIterator.next()) {
                    allEnterEdges.add(this.edgeIterator.detach(false));
                }
                return allEnterEdges.stream().min(Comparator.comparingLong(e -> GraphExplorer.this.calcTravelTimeMillis((EdgeIteratorState)e, label2.currentTime))).get();
            }
        }, false);
    }

    long calcTravelTimeMillis(EdgeIteratorState edge, long earliestStartTime) {
        GtfsStorage.EdgeType edgeType = edge.get(this.flagEncoder.getTypeEnc());
        switch (edgeType) {
            case HIGHWAY: {
                return (long)((double)this.accessEgressWeighting.calcEdgeMillis(edge, this.reverse) * (5.0 / this.walkSpeedKmH));
            }
            case ENTER_TIME_EXPANDED_NETWORK: {
                if (this.reverse) {
                    return 0L;
                }
                return this.waitingTime(edge, earliestStartTime);
            }
            case LEAVE_TIME_EXPANDED_NETWORK: {
                if (this.reverse) {
                    return -this.waitingTime(edge, earliestStartTime);
                }
                return 0L;
            }
        }
        return edge.get(this.flagEncoder.getTimeEnc()) * 1000;
    }

    boolean isBlocked(EdgeIteratorState edge) {
        return this.realtimeFeed.isBlocked(edge.getEdge());
    }

    long getDelayFromBoardEdge(EdgeIteratorState edge, long currentTime) {
        return this.realtimeFeed.getDelayForBoardEdge(edge, Instant.ofEpochMilli(currentTime));
    }

    long getDelayFromAlightEdge(EdgeIteratorState edge, long currentTime) {
        return this.realtimeFeed.getDelayForAlightEdge(edge, Instant.ofEpochMilli(currentTime));
    }

    private long waitingTime(EdgeIteratorState edge, long earliestStartTime) {
        long l = (long)(edge.get(this.flagEncoder.getTimeEnc()) * 1000) - this.millisOnTravelDay(edge, earliestStartTime);
        if (!this.reverse) {
            if (l < 0L) {
                l += 86400000L;
            }
        } else if (l > 0L) {
            l -= 86400000L;
        }
        return l;
    }

    private long millisOnTravelDay(EdgeIteratorState edge, long instant) {
        ZoneId zoneId = this.gtfsStorage.getTimeZones().get((Object)Integer.valueOf((int)edge.get((IntEncodedValue)this.flagEncoder.getValidityIdEnc()))).zoneId;
        return Instant.ofEpochMilli(instant).atZone(zoneId).toLocalTime().toNanoOfDay() / 1000000L;
    }

    private boolean isValidOn(EdgeIteratorState edge, long instant) {
        GtfsStorage.EdgeType edgeType = edge.get(this.flagEncoder.getTypeEnc());
        if (edgeType == GtfsStorage.EdgeType.BOARD || edgeType == GtfsStorage.EdgeType.ALIGHT) {
            int validityId = edge.get(this.flagEncoder.getValidityIdEnc());
            GtfsStorage.Validity validity = this.realtimeFeed.getValidity(validityId);
            int trafficDay = (int)ChronoUnit.DAYS.between(validity.start, Instant.ofEpochMilli(instant).atZone(validity.zoneId).toLocalDate());
            return trafficDay >= 0 && validity.validity.get(trafficDay);
        }
        return true;
    }

    int calcNTransfers(EdgeIteratorState edge) {
        return edge.get(this.flagEncoder.getTransfersEnc());
    }

    private class EdgeIteratorStatePredicate
    implements Predicate<EdgeIteratorState> {
        private final Label label;
        boolean foundEnteredTimeExpandedNetworkEdge;

        EdgeIteratorStatePredicate(Label label) {
            this.label = label;
            this.foundEnteredTimeExpandedNetworkEdge = false;
        }

        @Override
        public boolean test(EdgeIteratorState edgeIterator) {
            GtfsStorage.EdgeType edgeType = edgeIterator.get(GraphExplorer.this.flagEncoder.getTypeEnc());
            if (edgeType == GtfsStorage.EdgeType.HIGHWAY) {
                if (GraphExplorer.this.reverse) {
                    return edgeIterator.getReverse(GraphExplorer.this.accessEgressWeighting.getFlagEncoder().getAccessEnc());
                }
                return edgeIterator.get(GraphExplorer.this.accessEgressWeighting.getFlagEncoder().getAccessEnc());
            }
            if (GraphExplorer.this.walkOnly && edgeType != (GraphExplorer.this.reverse ? GtfsStorage.EdgeType.EXIT_PT : GtfsStorage.EdgeType.ENTER_PT)) {
                return false;
            }
            if (!GraphExplorer.this.ignoreValidities && !GraphExplorer.this.isValidOn(edgeIterator, this.label.currentTime)) {
                return false;
            }
            return edgeType != GtfsStorage.EdgeType.WAIT_ARRIVAL || GraphExplorer.this.reverse;
        }
    }
}

