/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.http.RealtimeBundleConfiguration;
import com.graphhopper.http.RealtimeFeedLoadingCache;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.client.HttpClientBuilder;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class RealtimeBundle
implements ConfiguredBundle<RealtimeBundleConfiguration> {
    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(RealtimeBundleConfiguration configuration, Environment environment) {
        if (configuration.gtfsrealtime().getFeeds().isEmpty()) {
            environment.jersey().register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bindFactory(EmptyRealtimeFeedFactory.class).to(RealtimeFeed.class).in(Singleton.class);
                }
            });
        } else {
            CloseableHttpClient httpClient = new HttpClientBuilder(environment).using(configuration.gtfsrealtime().getHttpClientConfiguration()).build("gtfs-realtime-feed-loader");
            environment.jersey().register((Object)new AbstractBinder((HttpClient)httpClient, configuration){
                final /* synthetic */ HttpClient val$httpClient;
                final /* synthetic */ RealtimeBundleConfiguration val$configuration;
                {
                    this.val$httpClient = httpClient;
                    this.val$configuration = realtimeBundleConfiguration;
                }

                protected void configure() {
                    this.bind(this.val$httpClient).to(HttpClient.class);
                    this.bind(this.val$configuration).to(RealtimeBundleConfiguration.class);
                    this.bindFactory(RealtimeFeedLoadingCache.class, Singleton.class).to(RealtimeFeed.class);
                }
            });
        }
    }

    private static class EmptyRealtimeFeedFactory
    implements Factory<RealtimeFeed> {
        private final GtfsStorage staticGtfs;

        @Inject
        EmptyRealtimeFeedFactory(GtfsStorage staticGtfs) {
            this.staticGtfs = staticGtfs;
        }

        public RealtimeFeed provide() {
            return RealtimeFeed.empty((GtfsStorage)this.staticGtfs);
        }

        public void dispose(RealtimeFeed realtimeFeed) {
        }
    }
}

