/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator.relationship;

import com.graphaware.common.util.SameTypePair;
import com.graphaware.common.util.UnorderedPair;
import com.graphaware.module.algo.generator.config.DistributionBasedConfig;
import com.graphaware.module.algo.generator.distribution.MutableSimpleDegreeDistribution;
import com.graphaware.module.algo.generator.relationship.BaseRelationshipGenerator;
import com.graphaware.module.algo.generator.utils.WeightedReservoirSampler;
import java.util.ArrayList;
import java.util.List;

public class SimpleGraphRelationshipGenerator
extends BaseRelationshipGenerator<DistributionBasedConfig> {
    public SimpleGraphRelationshipGenerator(DistributionBasedConfig configuration) {
        super(configuration);
    }

    @Override
    protected List<SameTypePair<Integer>> doGenerateEdges() {
        ArrayList<SameTypePair<Integer>> edges = new ArrayList<SameTypePair<Integer>>();
        MutableSimpleDegreeDistribution distribution = new MutableSimpleDegreeDistribution(((DistributionBasedConfig)this.getConfiguration()).getDegrees());
        while (!distribution.isZeroList()) {
            UnorderedPair edgeCandidate;
            MutableSimpleDegreeDistribution temp;
            int index = 0;
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < distribution.size(); ++i) {
                int elem = distribution.get(i);
                if (elem == 0 || elem >= min) continue;
                min = elem;
                index = i;
            }
            WeightedReservoirSampler sampler = new WeightedReservoirSampler();
            while (true) {
                temp = new MutableSimpleDegreeDistribution(distribution.getDegrees());
                int candidateIndex = sampler.randomIndexChoice(temp.getDegrees(), index);
                edgeCandidate = new UnorderedPair((Object)candidateIndex, (Object)index);
                boolean skip = false;
                for (SameTypePair sameTypePair : edges) {
                    if (!sameTypePair.equals((Object)edgeCandidate)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                temp.decrease(index);
                temp.decrease(candidateIndex);
                if (temp.isValid()) break;
            }
            distribution = temp;
            edges.add((SameTypePair<Integer>)edgeCandidate);
        }
        return edges;
    }
}

