/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator.relationship;

import com.graphaware.common.util.SameTypePair;
import com.graphaware.module.algo.generator.config.InvalidConfigException;
import com.graphaware.module.algo.generator.config.RelationshipGeneratorConfig;
import com.graphaware.module.algo.generator.relationship.RelationshipGenerator;
import java.util.List;

public abstract class BaseRelationshipGenerator<T extends RelationshipGeneratorConfig>
implements RelationshipGenerator<T> {
    private final T configuration;

    protected BaseRelationshipGenerator(T configuration) {
        this.configuration = configuration;
    }

    @Override
    public int getNumberOfNodes() {
        return this.configuration.getNumberOfNodes();
    }

    @Override
    public List<SameTypePair<Integer>> generateEdges() throws InvalidConfigException {
        if (!this.configuration.isValid()) {
            throw new InvalidConfigException("The supplied config is not valid");
        }
        return this.doGenerateEdges();
    }

    protected abstract List<SameTypePair<Integer>> doGenerateEdges();

    protected T getConfiguration() {
        return this.configuration;
    }
}

