/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator.node;

import com.graphaware.common.util.FileScanner;
import com.graphaware.common.util.Pair;
import com.graphaware.module.algo.generator.node.NodeCreator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.unsafe.batchinsert.BatchInserter;

public class SocialNetworkNodeCreator
implements NodeCreator {
    private static final Label PERSON_LABEL = Label.label((String)"Person");
    private static final Label MALE_LABEL = Label.label((String)"Male");
    private static final Label FEMALE_LABEL = Label.label((String)"Female");
    private static final String NAME = "name";
    private static final SocialNetworkNodeCreator INSTANCE = new SocialNetworkNodeCreator();
    private List<Pair<Label, String>> gendersAndNames = new ArrayList<Pair<Label, String>>();
    private Random random = new Random();

    protected SocialNetworkNodeCreator() {
        this.populateGendersAndNames();
    }

    public static SocialNetworkNodeCreator getInstance() {
        return INSTANCE;
    }

    @Override
    public Node createNode(GraphDatabaseService database) {
        Node node = database.createNode(new Label[]{this.getPersonLabel()});
        Pair<Label, String> genderAndName = this.getGenderAndName();
        node.addLabel((Label)genderAndName.first());
        node.setProperty(NAME, genderAndName.second());
        return node;
    }

    @Override
    public long createNode(BatchInserter batchInserter) {
        Pair<Label, String> genderAndName = this.getGenderAndName();
        return batchInserter.createNode(Collections.singletonMap(NAME, genderAndName.second()), new Label[]{(Label)genderAndName.first()});
    }

    protected Pair<Label, String> getGenderAndName() {
        return this.gendersAndNames.get(this.random.nextInt(this.gendersAndNames.size()));
    }

    protected Label getPersonLabel() {
        return PERSON_LABEL;
    }

    private void populateGendersAndNames() {
        for (String line : FileScanner.produceLines((InputStream)SocialNetworkNodeCreator.class.getClassLoader().getResourceAsStream("fake_names.csv"), (int)0)) {
            String[] fields = line.split(",");
            this.gendersAndNames.add((Pair<Label, String>)new Pair((Object)("female".equals(fields[0]) ? FEMALE_LABEL : MALE_LABEL), (Object)(fields[1] + " " + fields[2])));
        }
    }
}

