/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator.distribution;

import com.graphaware.module.algo.generator.distribution.DegreeDistribution;
import com.graphaware.module.algo.generator.distribution.MutableSimpleDegreeDistribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleDegreeDistribution
implements DegreeDistribution {
    protected final List<Integer> degrees = new ArrayList<Integer>();

    public SimpleDegreeDistribution(List<Integer> degrees) {
        this.degrees.addAll(degrees);
    }

    @Override
    public List<Integer> getDegrees() {
        return Collections.unmodifiableList(this.degrees);
    }

    @Override
    public boolean isZeroList() {
        for (int degree : this.degrees) {
            if (degree <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int get(int index) {
        return this.degrees.get(index);
    }

    @Override
    public int size() {
        return this.degrees.size();
    }

    @Override
    public boolean isValid() {
        return this.passesErdosGallaiTest();
    }

    private boolean passesErdosGallaiTest() {
        MutableSimpleDegreeDistribution copy = new MutableSimpleDegreeDistribution(this.getDegrees());
        int L = copy.size();
        int degreeSum = 0;
        for (int degree : copy.getDegrees()) {
            if (degree < 0) {
                return false;
            }
            degreeSum += degree;
        }
        if (degreeSum % 2 != 0) {
            return false;
        }
        copy.sort(Collections.reverseOrder());
        for (int k = 1; k < L; ++k) {
            int sum = 0;
            for (int i = 0; i < k; ++i) {
                sum += copy.get(i);
            }
            int comp = 0;
            for (int j = k; j < L; ++j) {
                comp += Math.min(k, copy.get(j));
            }
            if (sum <= k * (k - 1) + comp) continue;
            return false;
        }
        return true;
    }

    protected final boolean passesHavelHakimiTest() {
        MutableSimpleDegreeDistribution copy = new MutableSimpleDegreeDistribution(this.getDegrees());
        int i = 0;
        int L = this.size();
        while (L > 0) {
            int first = copy.get(i);
            --L;
            int j = 1;
            for (int k = 0; k < first; ++k) {
                while (copy.get(j) == 0) {
                    if (++j <= L) continue;
                    return false;
                }
                copy.set(j, copy.get(j) - 1);
            }
            copy.set(i, 0);
            copy.sort(Collections.reverseOrder());
        }
        return true;
    }
}

