/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.internal;

import com.github.jengelman.gradle.plugins.shadow.relocation.RelocationContextKt;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.vafer.jdeb.shaded.objectweb.asm.commons.Remapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001a\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/internal/RelocatorRemapper;", "Lorg/vafer/jdeb/shaded/objectweb/asm/commons/Remapper;", "relocators", "", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "onModified", "Lkotlin/Function0;", "", "<init>", "(Ljava/util/Set;Lkotlin/jvm/functions/Function0;)V", "mapValue", "", "value", "map", "", "internalName", "mapName", "name", "mapLiterals", "", "mapNameImpl", "Companion", "shadow"})
public final class RelocatorRemapper
extends Remapper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Relocator> relocators;
    @NotNull
    private final Function0<Unit> onModified;
    @NotNull
    private static final Pattern classPattern;

    public RelocatorRemapper(@NotNull Set<? extends Relocator> relocators, @NotNull Function0<Unit> onModified) {
        Intrinsics.checkNotNullParameter(relocators, (String)"relocators");
        Intrinsics.checkNotNullParameter(onModified, (String)"onModified");
        super(589824);
        this.relocators = relocators;
        this.onModified = onModified;
    }

    public /* synthetic */ RelocatorRemapper(Set set, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = RelocatorRemapper::_init_$lambda$0;
        }
        this(set, (Function0<Unit>)function0);
    }

    @NotNull
    public Object mapValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value instanceof String ? this.mapName((String)value, true) : super.mapValue(value);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    @NotNull
    public String map(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        return RelocatorRemapper.mapName$default(this, internalName, false, 2, null);
    }

    private final String mapName(String name, boolean mapLiterals) {
        char[] cArray = new char[]{';'};
        String newName = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)name, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)";", null, null, (int)0, null, arg_0 -> RelocatorRemapper.mapName$lambda$0(this, mapLiterals, arg_0), (int)30, null);
        if (!Intrinsics.areEqual((Object)newName, (Object)name)) {
            this.onModified.invoke();
        }
        return newName;
    }

    static /* synthetic */ String mapName$default(RelocatorRemapper relocatorRemapper, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return relocatorRemapper.mapName(string, bl);
    }

    private final String mapNameImpl(String name, boolean mapLiterals) {
        String newName = name;
        Object prefix = "";
        String suffix = "";
        Matcher matcher = classPattern.matcher(newName);
        if (matcher.matches()) {
            prefix = matcher.group(1) + "L";
            suffix = "";
            String string = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            newName = string;
        }
        for (Relocator relocator : this.relocators) {
            if (mapLiterals && relocator.getSkipStringConstants()) {
                return name;
            }
            if (relocator.canRelocateClass(newName)) {
                return (String)prefix + RelocationContextKt.relocateClass(relocator, newName) + suffix;
            }
            if (!relocator.canRelocatePath(newName)) continue;
            return (String)prefix + RelocationContextKt.relocatePath(relocator, newName) + suffix;
        }
        return name;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final CharSequence mapName$lambda$0(RelocatorRemapper this$0, boolean $mapLiterals, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.mapNameImpl(it, $mapLiterals);
    }

    static {
        Pattern pattern = Pattern.compile("([\\[()BCDFIJSZ]*)?L([^;]+);?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        classPattern = pattern;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/internal/RelocatorRemapper$Companion;", "", "<init>", "()V", "classPattern", "Ljava/util/regex/Pattern;", "getClassPattern", "()Ljava/util/regex/Pattern;", "shadow"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getClassPattern() {
            return classPattern;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

