/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.tasks;

import com.github.jengelman.gradle.plugins.shadow.ShadowStats;
import com.github.jengelman.gradle.plugins.shadow.internal.DefaultDependencyFilter;
import com.github.jengelman.gradle.plugins.shadow.internal.DependencyFilter;
import com.github.jengelman.gradle.plugins.shadow.internal.GradleVersionUtil;
import com.github.jengelman.gradle.plugins.shadow.internal.MinimizeDependencyFilter;
import com.github.jengelman.gradle.plugins.shadow.internal.RelocationUtil;
import com.github.jengelman.gradle.plugins.shadow.internal.UnusedTracker;
import com.github.jengelman.gradle.plugins.shadow.internal.ZipCompressor;
import com.github.jengelman.gradle.plugins.shadow.relocation.CacheableRelocator;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.relocation.SimpleRelocator;
import com.github.jengelman.gradle.plugins.shadow.tasks.DefaultInheritManifest;
import com.github.jengelman.gradle.plugins.shadow.tasks.InheritManifest;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowCopyAction;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowSpec;
import com.github.jengelman.gradle.plugins.shadow.transformers.AppendingTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.GroovyExtensionModuleTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.ServiceFileTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.Transformer;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.NotNull;

@CacheableTask
public class ShadowJar
extends Jar
implements ShadowSpec {
    private List<Transformer> transformers;
    private List<Relocator> relocators;
    private List<FileCollection> configurations;
    private transient DependencyFilter dependencyFilter;
    private boolean enableRelocation;
    private String relocationPrefix = "shadow";
    private boolean minimizeJar;
    private final transient DependencyFilter dependencyFilterForMinimize;
    private FileCollection toMinimize;
    private FileCollection apiJars;
    private FileCollection sourceSetsClassesDirs;
    private final ShadowStats shadowStats = new ShadowStats();
    private final ConfigurableFileCollection includedDependencies = this.getProject().files(new Object[]{new Callable<FileCollection>(){

        @Override
        public FileCollection call() {
            return ShadowJar.this.dependencyFilter.resolve(ShadowJar.this.configurations);
        }
    }});

    public ShadowJar() {
        this.setDuplicatesStrategy(DuplicatesStrategy.INCLUDE);
        this.dependencyFilter = new DefaultDependencyFilter(this.getProject());
        this.dependencyFilterForMinimize = new MinimizeDependencyFilter(this.getProject());
        this.setManifest(new DefaultInheritManifest(this.getProject(), (FileResolver)this.getServices().get(FileResolver.class)));
        this.transformers = new ArrayList<Transformer>();
        this.relocators = new ArrayList<Relocator>();
        this.configurations = new ArrayList<FileCollection>();
        this.getInputs().property("minimize", () -> this.minimizeJar);
        this.getOutputs().doNotCacheIf("Has one or more transforms or relocators that are not cacheable", task -> {
            for (Transformer transformer : this.transformers) {
                if (this.isCacheableTransform(transformer.getClass())) continue;
                return true;
            }
            for (Relocator relocator : this.relocators) {
                if (this.isCacheableRelocator(relocator.getClass())) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public ShadowJar minimize() {
        this.minimizeJar = true;
        return this;
    }

    @Override
    public ShadowJar minimize(Action<DependencyFilter> c) {
        this.minimize();
        if (c != null) {
            c.execute((Object)this.dependencyFilterForMinimize);
        }
        return this;
    }

    @Override
    @Internal
    public ShadowStats getStats() {
        return this.shadowStats;
    }

    public InheritManifest getManifest() {
        return (InheritManifest)super.getManifest();
    }

    @NotNull
    protected CopyAction createCopyAction() {
        DocumentationRegistry documentationRegistry = (DocumentationRegistry)this.getServices().get(DocumentationRegistry.class);
        UnusedTracker unusedTracker = this.minimizeJar ? UnusedTracker.forProject(this.getApiJars(), this.getSourceSetsClassesDirs().getFiles(), this.getToMinimize()) : null;
        return new ShadowCopyAction(((RegularFile)this.getArchiveFile().get()).getAsFile(), this.getInternalCompressor(), documentationRegistry, this.getMetadataCharset(), this.transformers, this.relocators, this.getRootPatternSet(), this.shadowStats, this.isPreserveFileTimestamps(), this.minimizeJar, unusedTracker);
    }

    @Classpath
    FileCollection getToMinimize() {
        if (this.toMinimize == null) {
            this.toMinimize = this.minimizeJar ? this.dependencyFilterForMinimize.resolve(this.configurations).minus(this.getApiJars()) : this.getProject().getObjects().fileCollection();
        }
        return this.toMinimize;
    }

    @Classpath
    FileCollection getApiJars() {
        if (this.apiJars == null) {
            this.apiJars = this.minimizeJar ? UnusedTracker.getApiJarsFromProject(this.getProject()) : this.getProject().getObjects().fileCollection();
        }
        return this.apiJars;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    FileCollection getSourceSetsClassesDirs() {
        if (this.sourceSetsClassesDirs == null) {
            ConfigurableFileCollection allClassesDirs = this.getProject().getObjects().fileCollection();
            if (this.minimizeJar) {
                for (SourceSet sourceSet : (SourceSetContainer)this.getProject().getExtensions().getByType(SourceSetContainer.class)) {
                    FileCollection classesDirs = sourceSet.getOutput().getClassesDirs();
                    allClassesDirs.from(new Object[]{classesDirs});
                }
            }
            this.sourceSetsClassesDirs = allClassesDirs.filter(File::isDirectory);
        }
        return this.sourceSetsClassesDirs;
    }

    @Internal
    protected ZipCompressor getInternalCompressor() {
        return GradleVersionUtil.getInternalCompressor(this.getEntryCompression(), this);
    }

    @TaskAction
    protected void copy() {
        if (this.enableRelocation) {
            RelocationUtil.configureRelocation(this, this.relocationPrefix);
        }
        this.from(new Object[]{this.getIncludedDependencies()});
        super.copy();
        this.getLogger().info(this.shadowStats.toString());
    }

    @Classpath
    public FileCollection getIncludedDependencies() {
        return this.includedDependencies;
    }

    @Internal
    protected PatternSet getRootPatternSet() {
        return GradleVersionUtil.getRootPatternSet(this.getMainSpec());
    }

    @Override
    public ShadowJar dependencies(Action<DependencyFilter> c) {
        if (c != null) {
            c.execute((Object)this.dependencyFilter);
        }
        return this;
    }

    @Override
    public ShadowJar transform(Class<? extends Transformer> clazz) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return this.transform((Class)clazz, (Action)null);
    }

    @Override
    public <T extends Transformer> ShadowJar transform(Class<T> clazz, Action<T> c) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Transformer transformer = (Transformer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.addTransform(transformer, c);
        return this;
    }

    private boolean isCacheableTransform(Class<? extends Transformer> clazz) {
        return clazz.isAnnotationPresent(CacheableTransformer.class);
    }

    @Override
    public ShadowJar transform(Transformer transformer) {
        this.addTransform(transformer, null);
        return this;
    }

    private <T extends Transformer> void addTransform(T transformer, Action<T> c) {
        if (c != null) {
            c.execute(transformer);
        }
        this.transformers.add(transformer);
    }

    @Override
    public ShadowJar mergeServiceFiles() {
        try {
            this.transform(ServiceFileTransformer.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar mergeServiceFiles(String rootPath) {
        try {
            this.transform(ServiceFileTransformer.class, serviceFileTransformer -> serviceFileTransformer.setPath(rootPath));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar mergeServiceFiles(Action<ServiceFileTransformer> configureClosure) {
        try {
            this.transform(ServiceFileTransformer.class, (Action)configureClosure);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar mergeGroovyExtensionModules() {
        try {
            this.transform(GroovyExtensionModuleTransformer.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar append(String resourcePath) {
        try {
            this.transform(AppendingTransformer.class, transformer -> transformer.setResource(resourcePath));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar relocate(String pattern, String destination) {
        return this.relocate(pattern, destination, (Action)null);
    }

    @Override
    public ShadowJar relocate(String pattern, String destination, Action<SimpleRelocator> configure) {
        SimpleRelocator relocator = new SimpleRelocator(pattern, destination, new ArrayList<String>(), new ArrayList<String>());
        this.addRelocator(relocator, configure);
        return this;
    }

    @Override
    public ShadowJar relocate(Relocator relocator) {
        this.addRelocator(relocator, null);
        return this;
    }

    @Override
    public ShadowJar relocate(Class<? extends Relocator> relocatorClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return this.relocate(relocatorClass, (Action)null);
    }

    private <R extends Relocator> void addRelocator(R relocator, Action<R> configure) {
        if (configure != null) {
            configure.execute(relocator);
        }
        this.relocators.add(relocator);
    }

    @Override
    public <R extends Relocator> ShadowJar relocate(Class<R> relocatorClass, Action<R> configure) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Relocator relocator = (Relocator)relocatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.addRelocator(relocator, configure);
        return this;
    }

    private boolean isCacheableRelocator(Class<? extends Relocator> relocatorClass) {
        return relocatorClass.isAnnotationPresent(CacheableRelocator.class);
    }

    @Nested
    public List<Transformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<Transformer> transformers) {
        this.transformers = transformers;
    }

    @Nested
    public List<Relocator> getRelocators() {
        return this.relocators;
    }

    public void setRelocators(List<Relocator> relocators) {
        this.relocators = relocators;
    }

    @Classpath
    @Optional
    public List<FileCollection> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<FileCollection> configurations) {
        this.configurations = configurations;
    }

    @Internal
    public DependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    public void setDependencyFilter(DependencyFilter filter) {
        this.dependencyFilter = filter;
    }

    @Input
    public boolean isEnableRelocation() {
        return this.enableRelocation;
    }

    public void setEnableRelocation(boolean enableRelocation) {
        this.enableRelocation = enableRelocation;
    }

    @Input
    public String getRelocationPrefix() {
        return this.relocationPrefix;
    }

    public void setRelocationPrefix(String relocationPrefix) {
        this.relocationPrefix = relocationPrefix;
    }
}

