/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.util.Collections;
import shadow.org.apache.logging.log4j.Level;
import shadow.org.apache.logging.log4j.Marker;
import shadow.org.apache.logging.log4j.ThreadContext;
import shadow.org.apache.logging.log4j.core.LogEvent;
import shadow.org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import shadow.org.apache.logging.log4j.core.impl.ThrowableProxy;
import shadow.org.apache.logging.log4j.core.jackson.ContextDataAsEntryListDeserializer;
import shadow.org.apache.logging.log4j.core.jackson.ContextDataAsEntryListSerializer;
import shadow.org.apache.logging.log4j.core.jackson.ContextDataDeserializer;
import shadow.org.apache.logging.log4j.core.jackson.ContextDataSerializer;
import shadow.org.apache.logging.log4j.core.jackson.ExtendedStackTraceElementMixIn;
import shadow.org.apache.logging.log4j.core.jackson.InstantMixIn;
import shadow.org.apache.logging.log4j.core.jackson.LevelMixIn;
import shadow.org.apache.logging.log4j.core.jackson.Log4jStackTraceElementDeserializer;
import shadow.org.apache.logging.log4j.core.jackson.LogEventMixIn;
import shadow.org.apache.logging.log4j.core.jackson.MarkerMixIn;
import shadow.org.apache.logging.log4j.core.jackson.MessageSerializer;
import shadow.org.apache.logging.log4j.core.jackson.MutableThreadContextStackDeserializer;
import shadow.org.apache.logging.log4j.core.jackson.ObjectMessageSerializer;
import shadow.org.apache.logging.log4j.core.jackson.StackTraceElementMixIn;
import shadow.org.apache.logging.log4j.core.jackson.ThrowableProxyMixIn;
import shadow.org.apache.logging.log4j.core.jackson.ThrowableProxyWithStacktraceAsStringMixIn;
import shadow.org.apache.logging.log4j.core.jackson.ThrowableProxyWithoutStacktraceMixIn;
import shadow.org.apache.logging.log4j.core.time.Instant;
import shadow.org.apache.logging.log4j.message.Message;
import shadow.org.apache.logging.log4j.message.ObjectMessage;
import shadow.org.apache.logging.log4j.util.StringMap;

class Initializers {
    Initializers() {
    }

    static class SimpleModuleInitializer {
        SimpleModuleInitializer() {
        }

        void initialize(SimpleModule simpleModule, boolean objectMessageAsJsonObject) {
            simpleModule.addDeserializer(StackTraceElement.class, (JsonDeserializer)new Log4jStackTraceElementDeserializer());
            simpleModule.addDeserializer(ThreadContext.ContextStack.class, (JsonDeserializer)new MutableThreadContextStackDeserializer());
            if (objectMessageAsJsonObject) {
                simpleModule.addSerializer(ObjectMessage.class, (JsonSerializer)new ObjectMessageSerializer());
            }
            simpleModule.addSerializer(Message.class, (JsonSerializer)new MessageSerializer());
        }
    }

    static class SetupContextInitializer
    extends AbstractInitializer {
        SetupContextInitializer() {
        }

        @Override
        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            super.setupModule(context, includeStacktrace, stacktraceAsString);
            context.addSerializers((Serializers)new SimpleSerializers(Collections.singletonList(new ContextDataSerializer())));
            context.addDeserializers((Deserializers)new SimpleDeserializers(Collections.singletonMap(StringMap.class, new ContextDataDeserializer())));
        }
    }

    static class SetupContextAsEntryListInitializer
    extends AbstractInitializer {
        SetupContextAsEntryListInitializer() {
        }

        @Override
        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            super.setupModule(context, includeStacktrace, stacktraceAsString);
            context.addSerializers((Serializers)new SimpleSerializers(Collections.singletonList(new ContextDataAsEntryListSerializer())));
            context.addDeserializers((Deserializers)new SimpleDeserializers(Collections.singletonMap(StringMap.class, new ContextDataAsEntryListDeserializer())));
        }
    }

    private static abstract class AbstractInitializer {
        private AbstractInitializer() {
        }

        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            context.setMixInAnnotations(StackTraceElement.class, StackTraceElementMixIn.class);
            context.setMixInAnnotations(Marker.class, MarkerMixIn.class);
            context.setMixInAnnotations(Level.class, LevelMixIn.class);
            context.setMixInAnnotations(Instant.class, InstantMixIn.class);
            context.setMixInAnnotations(LogEvent.class, LogEventMixIn.class);
            context.setMixInAnnotations(ExtendedStackTraceElement.class, ExtendedStackTraceElementMixIn.class);
            context.setMixInAnnotations(ThrowableProxy.class, includeStacktrace ? (stacktraceAsString ? ThrowableProxyWithStacktraceAsStringMixIn.class : ThrowableProxyMixIn.class) : ThrowableProxyWithoutStacktraceMixIn.class);
        }
    }
}

