/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.logging.log4j.core.config;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import shadow.org.apache.logging.log4j.Level;
import shadow.org.apache.logging.log4j.LogManager;
import shadow.org.apache.logging.log4j.Logger;
import shadow.org.apache.logging.log4j.core.LoggerContext;
import shadow.org.apache.logging.log4j.core.config.Configuration;
import shadow.org.apache.logging.log4j.core.config.ConfigurationSource;
import shadow.org.apache.logging.log4j.core.config.LoggerConfig;
import shadow.org.apache.logging.log4j.core.impl.Log4jContextFactory;
import shadow.org.apache.logging.log4j.core.util.NetUtils;
import shadow.org.apache.logging.log4j.spi.LoggerContextFactory;
import shadow.org.apache.logging.log4j.status.StatusLogger;
import shadow.org.apache.logging.log4j.util.StackLocatorUtil;
import shadow.org.apache.logging.log4j.util.Strings;

public final class Configurator {
    private static final String FQCN = Configurator.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();

    private static Log4jContextFactory getFactory() {
        LoggerContextFactory factory = LogManager.getFactory();
        if (factory instanceof Log4jContextFactory) {
            return (Log4jContextFactory)factory;
        }
        if (factory != null) {
            LOGGER.error("LogManager returned an instance of {} which does not implement {}. Unable to initialize Log4j.", (Object)factory.getClass().getName(), (Object)Log4jContextFactory.class.getName());
        } else {
            LOGGER.fatal("LogManager did not return a LoggerContextFactory. This indicates something has gone terribly wrong!");
        }
        return null;
    }

    public static LoggerContext initialize(ClassLoader loader, ConfigurationSource source) {
        return Configurator.initialize(loader, source, null);
    }

    public static LoggerContext initialize(ClassLoader loader, ConfigurationSource source, Object externalContext) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            return factory == null ? null : factory.getContext(FQCN, loader, externalContext, false, source);
        }
        catch (Exception ex) {
            LOGGER.error("There was a problem obtaining a LoggerContext using the configuration source [{}]", (Object)source, (Object)ex);
            return null;
        }
    }

    public static LoggerContext initialize(String name, ClassLoader loader, String configLocation) {
        return Configurator.initialize(name, loader, configLocation, null);
    }

    public static LoggerContext initialize(String name, ClassLoader loader, String configLocation, Object externalContext) {
        if (Strings.isBlank(configLocation)) {
            return Configurator.initialize(name, loader, (URI)null, externalContext);
        }
        return configLocation.contains(",") ? Configurator.initialize(name, loader, NetUtils.toURIs(configLocation), externalContext) : Configurator.initialize(name, loader, NetUtils.toURI(configLocation), externalContext);
    }

    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation) {
        return Configurator.initialize(name, loader, configLocation, null);
    }

    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation, Object externalContext) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            return factory == null ? null : factory.getContext(FQCN, loader, externalContext, false, configLocation, name);
        }
        catch (Exception ex) {
            LOGGER.error("There was a problem initializing the LoggerContext [{}] using configuration at [{}].", (Object)name, (Object)configLocation, (Object)ex);
            return null;
        }
    }

    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation, Map.Entry<String, Object> entry) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            return factory == null ? null : factory.getContext(FQCN, loader, entry, false, configLocation, name);
        }
        catch (Exception ex) {
            LOGGER.error("There was a problem initializing the LoggerContext [{}] using configuration at [{}].", (Object)name, (Object)configLocation, (Object)ex);
            return null;
        }
    }

    public static LoggerContext initialize(String name, ClassLoader loader, List<URI> configLocations, Object externalContext) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            return factory == null ? null : factory.getContext(FQCN, loader, externalContext, false, configLocations, name);
        }
        catch (Exception ex) {
            LOGGER.error("There was a problem initializing the LoggerContext [{}] using configurations at [{}].", (Object)name, (Object)configLocations, (Object)ex);
            return null;
        }
    }

    public static LoggerContext initialize(String name, String configLocation) {
        return Configurator.initialize(name, null, configLocation);
    }

    public static LoggerContext initialize(Configuration configuration) {
        return Configurator.initialize(null, configuration, null);
    }

    public static LoggerContext initialize(ClassLoader loader, Configuration configuration) {
        return Configurator.initialize(loader, configuration, null);
    }

    public static LoggerContext initialize(ClassLoader loader, Configuration configuration, Object externalContext) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            return factory == null ? null : factory.getContext(FQCN, loader, externalContext, false, configuration);
        }
        catch (Exception ex) {
            LOGGER.error("There was a problem initializing the LoggerContext using configuration {}", (Object)configuration.getName(), (Object)ex);
            return null;
        }
    }

    public static void reconfigure(Configuration configuration) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory != null) {
                factory.getContext(FQCN, null, null, false).reconfigure(configuration);
            }
        }
        catch (Exception ex) {
            LOGGER.error("There was a problem initializing the LoggerContext using configuration {}", (Object)configuration.getName(), (Object)ex);
        }
    }

    public static void reconfigure() {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory != null) {
                factory.getSelector().getContext(FQCN, null, false).reconfigure();
            } else {
                LOGGER.warn("Unable to reconfigure - Log4j has not been initialized.");
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error encountered trying to reconfigure logging", (Throwable)ex);
        }
    }

    public static void reconfigure(URI uri) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory != null) {
                factory.getSelector().getContext(FQCN, null, false).setConfigLocation(uri);
            } else {
                LOGGER.warn("Unable to reconfigure - Log4j has not been initialized.");
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error encountered trying to reconfigure logging", (Throwable)ex);
        }
    }

    public static void setAllLevels(String parentLogger, Level level) {
        LoggerContext loggerContext = LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader(2), false, null);
        Configuration config = loggerContext.getConfiguration();
        boolean set = Configurator.setLevel(parentLogger, level, config);
        for (Map.Entry<String, LoggerConfig> entry : config.getLoggers().entrySet()) {
            if (!entry.getKey().startsWith(parentLogger)) continue;
            set |= Configurator.setLevel(entry.getValue(), level);
        }
        if (set) {
            loggerContext.updateLoggers();
        }
    }

    public static Logger setLevel(Logger logger, Level level) {
        Configurator.setLevel(LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader(2), false, null), logger.getName(), level);
        return logger;
    }

    public static void setLevel(Class<?> clazz, Level level) {
        String canonicalName = clazz.getCanonicalName();
        Configurator.setLevel(LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader(2), false, null), canonicalName != null ? canonicalName : clazz.getName(), level);
    }

    private static boolean setLevel(LoggerConfig loggerConfig, Level level) {
        boolean set;
        boolean bl = set = !loggerConfig.getLevel().equals(level);
        if (set) {
            loggerConfig.setLevel(level);
        }
        return set;
    }

    private static void setLevel(LoggerContext loggerContext, String loggerName, Level level) {
        if (Strings.isEmpty(loggerName)) {
            Configurator.setRootLevel(level, loggerContext);
        } else if (Configurator.setLevel(loggerName, level, loggerContext.getConfiguration())) {
            loggerContext.updateLoggers();
        }
    }

    public static void setLevel(Map<String, Level> levelMap) {
        LoggerContext loggerContext = LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader(2), false, null);
        Configuration config = loggerContext.getConfiguration();
        boolean set = false;
        for (Map.Entry<String, Level> entry : levelMap.entrySet()) {
            String loggerName = entry.getKey();
            Level level = entry.getValue();
            set |= Configurator.setLevel(loggerName, level, config);
        }
        if (set) {
            loggerContext.updateLoggers();
        }
    }

    public static void setLevel(String loggerName, Level level) {
        Configurator.setLevel(LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader(2), false, null), loggerName, level);
    }

    public static void setLevel(String loggerName, String level) {
        Configurator.setLevel(LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader(2), false, null), loggerName, Level.toLevel(level));
    }

    private static boolean setLevel(String loggerName, Level level, Configuration config) {
        boolean set;
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        if (!loggerName.equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(loggerName, level, true);
            config.addLogger(loggerName, loggerConfig);
            loggerConfig.setLevel(level);
            set = true;
        } else {
            set = Configurator.setLevel(loggerConfig, level);
        }
        return set;
    }

    public static void setRootLevel(Level level) {
        Configurator.setRootLevel(level, LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader(2), false, null));
    }

    private static void setRootLevel(Level level, LoggerContext loggerContext) {
        LoggerConfig loggerConfig = loggerContext.getConfiguration().getRootLogger();
        if (!loggerConfig.getLevel().equals(level)) {
            loggerConfig.setLevel(level);
            loggerContext.updateLoggers();
        }
    }

    public static void shutdown(LoggerContext ctx) {
        if (ctx != null) {
            ctx.stop();
        }
    }

    public static boolean shutdown(LoggerContext ctx, long timeout, TimeUnit timeUnit) {
        if (ctx != null) {
            return ctx.stop(timeout, timeUnit);
        }
        return true;
    }

    private Configurator() {
    }
}

