/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.MissingRootAndDuplicateIgnoringFileSystemSnapshotVisitor;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class IgnoredPathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    public static final IgnoredPathFingerprintingStrategy DEFAULT = new IgnoredPathFingerprintingStrategy();
    private final FileSystemLocationSnapshotHasher normalizedContentHasher;

    public IgnoredPathFingerprintingStrategy(FileSystemLocationSnapshotHasher fileSystemLocationSnapshotHasher) {
        super("IGNORED_PATH", fileSystemLocationSnapshotHasher);
        this.normalizedContentHasher = fileSystemLocationSnapshotHasher;
    }

    private IgnoredPathFingerprintingStrategy() {
        this(FileSystemLocationSnapshotHasher.DEFAULT);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot fileSystemSnapshot) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        fileSystemSnapshot.accept(new MissingRootAndDuplicateIgnoringFileSystemSnapshotVisitor(){

            @Override
            public void visitAcceptedEntry(FileSystemLocationSnapshot fileSystemLocationSnapshot, boolean bl2) {
                HashCode hashCode;
                if (fileSystemLocationSnapshot.getType() != FileType.Directory && (hashCode = IgnoredPathFingerprintingStrategy.this.getNormalizedContentHash(fileSystemLocationSnapshot, IgnoredPathFingerprintingStrategy.this.normalizedContentHasher)) != null) {
                    builder.put(fileSystemLocationSnapshot.getAbsolutePath(), IgnoredPathFileSystemLocationFingerprint.create(fileSystemLocationSnapshot.getType(), hashCode));
                }
            }
        });
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }
}

