/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.controller.operations.LoadOperationDetails;
import org.gradle.caching.internal.controller.operations.LoadOperationHitResult;
import org.gradle.caching.internal.controller.operations.LoadOperationMissResult;
import org.gradle.caching.internal.controller.operations.StoreOperationDetails;
import org.gradle.caching.internal.controller.operations.StoreOperationResult;
import org.gradle.caching.internal.controller.service.BaseRemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.gradle.caching.internal.operations.BuildCacheRemoteDisabledDueToFailureProgressDetails;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;

public class OpFiringRemoteBuildCacheServiceHandle
extends BaseRemoteBuildCacheServiceHandle {
    private final String buildPath;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationProgressEventEmitter buildOperationProgressEventEmitter;

    public OpFiringRemoteBuildCacheServiceHandle(String string, BuildCacheService buildCacheService, boolean bl2, BuildCacheServiceRole buildCacheServiceRole, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter buildOperationProgressEventEmitter, boolean bl3, boolean bl4) {
        super(buildCacheService, bl2, buildCacheServiceRole, bl3, bl4);
        this.buildPath = string;
        this.buildOperationRunner = buildOperationRunner;
        this.buildOperationProgressEventEmitter = buildOperationProgressEventEmitter;
    }

    @Override
    protected void loadInner(final String string, final BuildCacheKey buildCacheKey, final LoadTarget loadTarget) {
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext buildOperationContext) {
                OpFiringRemoteBuildCacheServiceHandle.this.loadInner(buildCacheKey, new OpFiringEntryReader(loadTarget));
                buildOperationContext.setResult(loadTarget.isLoaded() ? new LoadOperationHitResult(loadTarget.getLoadedSize()) : LoadOperationMissResult.INSTANCE);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName(string).details(new LoadOperationDetails(buildCacheKey)).progressDisplayName("Requesting from remote build cache");
            }
        });
    }

    @Override
    protected void storeInner(final String string, final BuildCacheKey buildCacheKey, final StoreTarget storeTarget) {
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext buildOperationContext) {
                OpFiringRemoteBuildCacheServiceHandle.super.storeInner(string, buildCacheKey, storeTarget);
                buildOperationContext.setResult(storeTarget.isStored() ? StoreOperationResult.STORED : StoreOperationResult.NOT_STORED);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName(string).details(new StoreOperationDetails(buildCacheKey, storeTarget.getSize())).progressDisplayName("Uploading to remote build cache");
            }
        });
    }

    @Override
    protected void onCacheDisabledDueToFailure(BuildCacheKey buildCacheKey, BaseRemoteBuildCacheServiceHandle.Operation operation, Throwable throwable) {
        BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType buildCacheOperationType = OpFiringRemoteBuildCacheServiceHandle.convertToBuildOperationType(operation);
        this.buildOperationProgressEventEmitter.emitNowIfCurrent(new RemoteDisabledDueToFailureProgressDetails(buildCacheKey, throwable, buildCacheOperationType));
    }

    private static BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType convertToBuildOperationType(BaseRemoteBuildCacheServiceHandle.Operation operation) {
        switch (operation) {
            case LOAD: {
                return BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType.LOAD;
            }
            case STORE: {
                return BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType.STORE;
            }
        }
        throw new IllegalStateException();
    }

    private class RemoteDisabledDueToFailureProgressDetails
    implements BuildCacheRemoteDisabledDueToFailureProgressDetails {
        private final BuildCacheKey key;
        private final Throwable e;
        private final BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType operationType;

        public RemoteDisabledDueToFailureProgressDetails(BuildCacheKey buildCacheKey, Throwable throwable, BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType buildCacheOperationType) {
            this.key = buildCacheKey;
            this.e = throwable;
            this.operationType = buildCacheOperationType;
        }
    }

    private static class UncheckedWrapper
    extends RuntimeException {
        UncheckedWrapper(IOException iOException) {
            super(iOException);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        IOException getIOException() {
            return (IOException)this.getCause();
        }
    }

    private class OpFiringEntryReader
    implements BuildCacheEntryReader {
        private final BuildCacheEntryReader delegate;

        OpFiringEntryReader(BuildCacheEntryReader buildCacheEntryReader) {
            this.delegate = buildCacheEntryReader;
        }

        @Override
        public void readFrom(final InputStream inputStream) throws IOException {
            try {
                OpFiringRemoteBuildCacheServiceHandle.this.buildOperationRunner.run(new RunnableBuildOperation(){

                    @Override
                    public void run(BuildOperationContext buildOperationContext) {
                        try {
                            OpFiringEntryReader.this.delegate.readFrom(inputStream);
                        }
                        catch (IOException iOException) {
                            throw new UncheckedWrapper(iOException);
                        }
                    }

                    @Override
                    public BuildOperationDescriptor.Builder description() {
                        return BuildOperationDescriptor.displayName("Download from remote build cache").progressDisplayName("Downloading");
                    }
                });
            }
            catch (UncheckedWrapper uncheckedWrapper) {
                throw uncheckedWrapper.getIOException();
            }
        }
    }
}

