/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;

public class CachingResourceHasher
implements ResourceHasher {
    private final ResourceHasher delegate;
    private final ResourceSnapshotterCacheService resourceSnapshotterCacheService;
    private final HashCode delegateConfigurationHash;

    public CachingResourceHasher(ResourceHasher resourceHasher, ResourceSnapshotterCacheService resourceSnapshotterCacheService) {
        this.delegate = resourceHasher;
        this.resourceSnapshotterCacheService = resourceSnapshotterCacheService;
        Hasher hasher = Hashing.newHasher();
        resourceHasher.appendConfigurationToHasher(hasher);
        this.delegateConfigurationHash = hasher.hash();
    }

    @Override
    public HashCode hash(RegularFileSnapshotContext regularFileSnapshotContext) throws IOException {
        return this.resourceSnapshotterCacheService.hashFile(regularFileSnapshotContext, this.delegate, this.delegateConfigurationHash);
    }

    @Override
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        return this.delegate.hash(zipEntryContext);
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
    }
}

